require('game/models/BaseModel');

Models.FallenTree = class FallenTree extends Models.BaseModel {
  static get modelName() {
    return 'fallen-tree';
  }

  static defaultData(gameObject) {
    const data = {
      hitboxX: 0,
      hitboxY: 0.5,
      hitboxWidth: 1.75,
      hitboxHeight: 0.125,
      offsetX: 12,
      spriteName: 'objects/$fallen-tree',
      spriteIndex: 0,
      direction: 2,
      pattern: 1,
      priority: 1,
      through: false
    };

    if (gameObject.hp !== undefined && gameObject.hp < 7) {
      switch(gameObject.hp) {
        case 6:
          data.direction = Direction.LEFT;
          data.pattern = 0;
          break;
        case 5:
          data.direction = Direction.LEFT;
          data.pattern = 1;
          break;
        case 4:
          data.direction = Direction.LEFT;
          data.pattern = 2;
          break;
        case 3:
          data.direction = Direction.RIGHT;
          data.pattern = 0;
          break;
        case 2:
          data.direction = Direction.RIGHT;
          data.pattern = 1;
          break;
        case 1:
          data.direction = Direction.RIGHT;
          data.pattern = 2;
          break;
      }
    }

    return data;
  }
};

Managers.FarmObjects.registerWideModel(Models.FallenTree.modelName);
Managers.FarmObjects.registerLargeModel(Models.FallenTree.modelName);
Managers.FarmObjects.registerCollisionModel(Models.FallenTree.modelName);