require('game/models/BaseModel');

Models.Boulder = class Boulder extends Models.BaseModel {
  static get modelName() {
    return 'boulder';
  }

  static defaultData(gameObject) {
    return {
      hitboxX: 0.25,
      hitboxY: 0.25,
      hitboxWidth: 1.5,
      hitboxHeight: 0.5,
      offsetX: 16,
      spriteName: '-boulder',
      spriteIndex: 0,
      direction: 2,
      pattern: 0,
      priority: 1,
      through: false
    };
  }
};

Managers.FarmObjects.registerLargeModel(Models.Boulder.modelName);
Managers.FarmObjects.registerTallModel(Models.Boulder.modelName);
Managers.FarmObjects.registerWideModel(Models.Boulder.modelName);
Managers.FarmObjects.registerCollisionModel(Models.Boulder.modelName);