require('game/models/Crop');

Models.BushCrop = class BushCrop extends Models.Crop {
  static get cropName() {
    return '';
  }

  static getHitboxX() {
    return 0;
  }

  static getHitboxY() {
    return 0.25;
  }

  static getHitboxWidth() {
    return 1;
  }

  static getHitboxHeight() {
    return 0.75;
  }

  static regrows() {
    return true;
  }

  static getWateredDeathChance() {
    return 0;
  }

  static getDryDeathChance() {
    return 0;
  }

  static canBeCut() {
    return false;
  }

  static getStageCaps() {
    return [30, 60, 63];
  }

  static getMinDeathAge() {
    return 3000;
  }

  static getPriority() {
    return 1;
  }

  static getBushData(gameObject) {
    return {
      cropStages: [{
        tileId: 8
      }, {
        tileId: 8
      }, {
        tileId: 8
      }]
    };
  }

  static processGameObjectNewDay(gameObject) {
    if (gameObject.points < 60) {
      gameObject.points = 60;
    }

    const mapSeason = Managers.Map.mapMonth(gameObject.mapId);
    if (this.cropGrownsOnSeason(mapSeason)) {
      const points = Math.randomInt(3);
      gameObject.increasePoints(this.getStageCaps(), points);
    }
  }

  static getData(gameObject) {
    const data = this.defaultData(gameObject);
    let stage = this.stage(gameObject);
    const mapSeason = Managers.Map.mapMonth(gameObject.mapId);

    const bushData = this.getBushData(gameObject);

    if (stage >= 3 && !this.cropGrownsOnSeason(mapSeason)) {
      stage = 2;
    }

    const stageData = bushData.cropStages[stage -1];
    if (!stageData) {
      return this.normalizeData(data);
    }

    return this.normalizeData(stageData);
  }

  static hasCollision() {
    return true;
  }
};
