require('game/models/BaseModel');

Models.TilledSoil = class TilledSoil extends Models.BaseModel {
  static get modelName() {
    return 'soil';
  }

  static defaultData(gameObject) {
    return {
      spriteName: '!crops',
      spriteIndex: 5,
      direction: 4,
      pattern: 0,
      priority: 0,
    };
  }

  static getData(gameObject) {
    const data = super.getData(gameObject);

    if (gameObject.watered) {
      data.pattern = 1;
    }

    return data;
  }

  static processGameObjectNewDay(gameObject) {
    if (Math.randomInt(100) < 30) {
      gameObject.clear();
      return;
    }

    const withinRange = Managers.FarmObjects.isTileWithinRangeOfASprinkler(gameObject.mapId, gameObject.x, gameObject.y);
    gameObject.watered = withinRange;

    if (Managers.Weather.isRaining()) {
      if (InsideFarmMaps.indexOf(gameObject.mapId) < 0) {
        gameObject.watered = true;
      }
    }
  }
};