require('game/models/BaseModel');

Models.MiningRock = class MiningRock extends Models.BaseModel {
  static get rockName() {
    return '';
  }
  static get modelName() {
    return `rock-${ this.rockName }`;
  }

  static getRockSettings() {
    return {
      spriteName: 'miningrocks_1',
      direction: 2,
      brokenDirection: 4,
      itemChance: 100
    };
  }

  static itemChance(gameObject) {
    const data = this.getData(gameObject);

    return data.itemChance || 100;
  }

  static getAvailableRocks() {
    return [];
  }

  static defaultData(gameObject) {
    const settings = this.getRockSettings();

    const data = {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxHeight: 0.25,

      spriteName: settings.spriteName || 'miningrocks_1',
      direction: gameObject.broken ? (settings.brokenDirection || 4) : (settings.direction || 2),
      itemChance: settings.itemChance || 100,

      priority: 1
    };

    return data;
  }

  static getData(gameObject) {
    const data = this.defaultData(gameObject);
    const rocks = this.getAvailableRocks();

    const rockIndex = !isNaN(gameObject.subtype) ? gameObject.subtype % rocks.length : 0;
    const rockTypeData = rocks[rockIndex];

    Utils.assignProperties(data, rockTypeData);

    return this.normalizeData(data);
  }

};