require('game/models/BaseModel');

Models.Item = class Item extends Models.BaseModel {
  static get modelName() {
    return 'item';
  }

  static defaultData(gameObject) {
    const itemData = Managers.Items.getItemData(gameObject.itemName);

    return {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxHeight: 0.25,
      offsetY: -4,
      priority: 1,
      iconIndex: itemData.iconIndex
    };
  }
};
