const BaseModel = require('./BaseModel');

class Button extends BaseModel {
  static get modelName() {
    return 'button';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'objects1x',
      spriteIndex: 4,
      direction: 6,
      pattern: 0,
      priority: 0,
    };
  }

  static getData(gameObject) {
    const data = super.getData(gameObject);

    if (gameObject.getButtonState(true) == FarmObjectState.BUTTON_PRESSED) {
      data.pattern = 1;
    }

    return data;
  }
}

Models.Button = Button;
module.exports = Button;