class BaseModel {
  static get modelName() {
    return '';
  }

  static defaultData(gameObject) {
    return {};
  }

  static normalizeData(data) {
    const normalizeAttribute = (propName, value) => {
      if (data[propName] === undefined) {
        data[propName] = value;
      }
    };

    normalizeAttribute('spriteName', '');
    normalizeAttribute('spriteIndex', 0);
    normalizeAttribute('direction', 2);
    normalizeAttribute('pattern', 0);
    normalizeAttribute('priority', 1);
    normalizeAttribute('through', false);

    normalizeAttribute('tileId', false);
    normalizeAttribute('iconIndex', false);

    normalizeAttribute('hitboxX', 0);
    normalizeAttribute('hitboxY', 0);
    normalizeAttribute('hitboxHeight', 1);
    normalizeAttribute('hitboxWidth', 1);

    normalizeAttribute('offsetX', 0);
    normalizeAttribute('offsetY', 0);

    if (data.spriteName == 'tileset') {
      data.spriteName = '';
      data.tileId = data.tileId || data.spriteIndex;
      data.spriteIndex = 0;
    }

    return data;
  }

  static getData(gameObject) {
    return this.normalizeData(this.defaultData(gameObject));
  }

  static getDataProp(gameObject, data, propName) {
    data = data || this.getData(gameObject);
    return data[propName];
  }

  static getTileId(gameObject, data) {
    return this.getDataProp(gameObject, data, 'tileId');
  }
  static getIconIndex(gameObject, data) {
    return this.getDataProp(gameObject, data, 'iconIndex');
  }
  static getSpriteName(gameObject, data) {
    return this.getDataProp(gameObject, data, 'spriteName');
  }
  static getSpriteIndex(gameObject, data) {
    return this.getDataProp(gameObject, data, 'spriteIndex');
  }
  static getDirection(gameObject, data) {
    return this.getDataProp(gameObject, data, 'direction');
  }
  static getPattern(gameObject, data) {
    return this.getDataProp(gameObject, data, 'pattern');
  }
  static getPriority(gameObject, data) {
    return this.getDataProp(gameObject, data, 'priority');
  }
  static getThrough(gameObject, data) {
    return this.getDataProp(gameObject, data, 'through');
  }
  static getHitboxX(gameObject, data) {
    return this.getDataProp(gameObject, data, 'hitboxX');
  }
  static getHitboxY(gameObject, data) {
    return this.getDataProp(gameObject, data, 'hitboxY');
  }
  static getHitboxWidth(gameObject, data) {
    return this.getDataProp(gameObject, data, 'hitboxWidth');
  }
  static getHitboxHeight(gameObject, data) {
    return this.getDataProp(gameObject, data, 'hitboxHeight');
  }
  static getOffsetX(gameObject, data) {
    return this.getDataProp(gameObject, data, 'offsetX');
  }
  static getOffsetY(gameObject, data) {
    return this.getDataProp(gameObject, data, 'offsetY');
  }

  static processGameObjectNewDay(/*gameObject*/) {
  }

  static isStaticPosition() {
    return false;
  }

  static hasCollision() {
    return true;
  }

  static isTree() {
    return false;
  }

  static isCrop() {
    return false;
  }

  static isFlower() {
    return false;
  }

  static isBig() {
    return false;
  }

  static canBeCut() {
    return false;
  }

  static isModel(modelClass) {
    return this == modelClass || this.prototype instanceof modelClass;
  }
}

Models.BaseModel = BaseModel;
module.exports = BaseModel;
