Managers.Visitors = class Visitors {
  constructor() {
    throw new Error('This is a static class');
  }

  static validateVisitorConditions(visitorData) {
    if (!visitorData) return false;

    const conditions = visitorData.conditions;
    // Visitors share the same condition options as the mailbox, plus time conditions
    return Managers.Mailbox.validateConditionList(conditions, false);
  }

  static checkVisitors() {
    if (!$dataVisitors) {
      return false;
    }

    for (const eventId in $dataVisitors) {
      if (Managers.History.daysSinceCutscene(eventId) !== false) {
        continue;
      }

      if (this.validateVisitorConditions($dataVisitors[eventId])) {
        $gameTemp.reserveCutscene(eventId);
        return true;
      }
    }

    return false;
  }
};