Managers.Updates = class Updates {
  constructor() {
    throw new Error('This is a static class');
  }

  static isVersionAccepted(proposedVersion, saveFormatVersion) {
    if (proposedVersion === undefined) return false;
    if (proposedVersion == this.currentVersion) return true;
    if (proposedVersion > this.currentVersion) {
      if (saveFormatVersion !== this.saveFormatVersion) return false;
    }
    if (proposedVersion < this.minVersion) return false;

    return true;
  }

  static runUpdates(loadedVersion, content) {
    this.loadedVersion = loadedVersion;

    if (loadedVersion < 0.2) {
      this.runV01Updates(loadedVersion, content);
    }

    if (loadedVersion < 0.3) {
      this.runV02Updates(loadedVersion, content);
    }

    if (loadedVersion < 0.4) {
      this.runV03Updates(loadedVersion, content);
    }

    if (loadedVersion < 0.5) {
      this.runV04Updates(loadedVersion, content);
    }

    if (loadedVersion < 0.6) {
      this.runV05Updates(loadedVersion, content);
    }

    if (loadedVersion < 0.7) {
      this.runV06Updates(loadedVersion, content);
    }

    if (loadedVersion < this.currentVersion) {
      Managers.History.registerUpdate(loadedVersion, this.currentVersion);
    }

    this.deleteOldData(loadedVersion);
    this.runDataChecks(loadedVersion);
    return true;
  }

  static addMigration(versionNumber, method, exactNumber = false) {
    if ((exactNumber && this.loadedVersion === versionNumber) || this.loadedVersion < versionNumber) {
      try {
        method();
      } catch(e) {
        console.error(...window.error(e));
        throw new Utils.UpdateError(versionNumber, e);
      }
    }
  }

  static getAllPatchNotes() {
    let fullText = '';

    let versionNumbers = this.currentVersionStr;
    if (window.isDemo) {
      versionNumbers += ' - DEMO';
    }

    const currentVersionLabel = Managers.Text.translateOnly("Current Version");
    const versionLabel = Managers.Text.translateOnly("Version");

    fullText += `${currentVersionLabel}:  <color:positive>${versionNumbers}</color>`;
    fullText += "\n";

    function addVersionNumber(versionNumber, versionDate) {
      fullText += "\n";
      fullText += `${versionLabel} ${versionNumber} - (<color:important>${versionDate}</color>):`;
      fullText += "\n";
    }

    function addItem(text) {
      fullText += "\\hi[193]";
      fullText += Managers.Text.translateOnly(text);
      fullText += "\n";
    }

    addVersionNumber("0.6.2.06", "2020-08-07");
    addItem("Show chicken list at the chicken festival.");

    addVersionNumber("0.6.2.05", "2020-08-06");
    addItem("Bug fixes.");

    addVersionNumber("0.6.2.04", "2020-08-06");
    addItem("Bug fixes.");
    addItem("Added bells inside the coop and barn.");

    addVersionNumber("0.6.2.03", "2020-08-06");
    addItem("Bug fixes.");

    addVersionNumber("0.6.2.02", "2020-08-06");
    addItem("Bug fixes.");

    addVersionNumber("0.6.2.01", "2020-08-06");
    addItem("Bug fixes.");

    addVersionNumber("0.6.2.00", "2020-08-06");
    addItem("Improved Graphics");
    addItem("Added Sheep");
    addItem("Added Yarn Maker");
    addItem("Added dozens of new fish types");
    addItem("New villagers: Gary, Shinnosuke, Kaori and Yumiko");
    addItem("Replaced Salesman with Prince");
    addItem("Expanded Mia and Martin");
    addItem("Added an option to sell fish to Gary");
    addItem("Added an option to leave animals on the vet.");
    addItem("Added an ore shop");
    addItem("Changes to the fishing system");
    addItem("Improvements on animal behavior");
    addItem("Removed ducks from Rory's shop");
    addItem("Added wild ducks");
    addItem("Improved chicken race");
    addItem("Added portraits for every villager");
    addItem("Improved HUDs");
    addItem("Added unavailable tool upgrades to the blacksmith shop");
    addItem("Changed default resolution and zoom level");
    addItem("Added footsteps and new sound effects");
    addItem("Performance Improvements");
    addItem("Added colorblind mode to the Flower Festival");
    addItem("New Trees and Animations");

    addVersionNumber("0.6.1.25", "2020-06-18");
    addItem("Fixed issue with the cooking screen causing lag.");
    addItem("Fixed issue on Annie's conversations.");
    addItem("Fixed issue on Lucas friendship event.");
    addItem("Fixed issue on Stella's events.");
    addItem("Reduced fatigue level of watering can and upgraded tools.");
    addItem("Fixed request board issue.");

    addVersionNumber("0.6.1.20", "2020-05-27");
    addItem("Fixed fatal error when talking to Julia.");

    addVersionNumber("0.6.1.19", "2020-05-26");
    addItem("Fixed an issue that could cause some conversation to never happen.");
    addItem("Fixed patch notes list not showing on large resolutions.");

    addVersionNumber("0.6.1.18", "2020-05-25");
    addItem("Improved the bells functionality.");
    addItem("Fixed the following bugs:");
    addItem("* Julia not responding to hang out requests.");
    addItem("* Animals left on the bathroom on version 0.6 were nowhere to be found.");

    addVersionNumber("0.6.1.17", "2020-05-22");
    addItem("Fixed an error triggered by hitting two rocks at the same time.");

    addVersionNumber("0.6.1.16", "2020-05-18");
    addItem("Fixed an issue that caused some crops to die.");

    addVersionNumber("0.6.1.15", "2020-05-16");
    addItem("Fixed the following bugs:");
    addItem("* Player could sometimes get stuck on cutscene mode during Duke introduction.");
    addItem("* Festival games could sometimes be played twice on the same day.");

    addVersionNumber("0.6.1.14", "2020-05-15");
    addItem("Moved some objects that were too hidden and hard to find.");
    addItem("Fixed the following bugs:");
    addItem("* Some Sacis could be found multiple times.");
    addItem("* Sarah appearing on top of a fridge.");
    addItem("* Player could walk through the lumber near Raphael's house.");

    addVersionNumber("0.6.1.13", "2020-05-14");
    addItem("The game will now give you more information if a save file fails to load.");
    addItem("Fixed the following bugs:");
    addItem("* Error when loading saves generated between versions 0.2.9.2 and 0.5.0.6.");

    addVersionNumber("0.6.1.12", "2020-05-12");
    addItem("Fixed the following bugs:");
    addItem("* Devin events not triggered for new players.");
    addItem("* Affected area not updating when trying to place buildings.");
    addItem("* Graphic glitch under bridges during winter.");

    addVersionNumber("0.6.1.11", "2020-05-11");
    addItem("Replaced the town sign boards for requests and festivals.");
    addItem("Updated the festival list.");
    addItem("Pause the game when Steam Overlay is active.");
    addItem("Stop spawning items over player objects.");

    addVersionNumber("0.6.1.10", "2020-05-10");
    addItem("Fixed the following bugs:");
    addItem("* Serge was not saying anything on weekends.");
    addItem("* Passage to the mountain top not working when riding a horse.");
    addItem("* Cindy was invisible when inside the inn.");

    addVersionNumber("0.6.1.09", "2020-05-10");
    addItem("Made cheat codes harder to trigger by accident.");
    addItem("Fixed the following bugs:");
    addItem("* Some villagers were appearing on the forest map by error.");
    addItem("* Fatal Error when talking to Nathalia.");
    addItem("* Some seeds were lost when trying to use them too fast.");
    addItem("* Finding many Sacis without changing areas could sometimes crash.");

    addVersionNumber("0.6.1.08", "2020-05-07");
    addItem("Fixed fishing achievements.");
    addItem("Show number of fish caught on the main diary.");
    addItem("Show money made and spent on the main diary.");
    addItem("Fixed issue with Raphael's Request not completing.");

    addVersionNumber("0.6.1.07", "2020-05-07");
    addItem("Fixed some cutscenes.");

    addVersionNumber("0.6.1.06", "2020-05-06");
    addItem("Replaced town building signs.");
    addItem("Updated female character picture on the character creation screen.");
    addItem("Fixed the following bugs:");
    addItem("* HUD not refreshing when max fatigue increased.");
    addItem("* Saci disappearing without animation on his introduction cutscene.");
    addItem("* Brittany not saying anything.");
    addItem("* Interactions not triggering properly in some positions.");

    addVersionNumber("0.6.1.05", "2020-05-05");
    addItem("Bug fixes.");

    addVersionNumber("0.6.1.04", "2020-02-29");
    addItem("Balancing ores, mines and tools.");
    addItem("Bug fixes.");

    addVersionNumber("0.6.1.03", "2020-02-25");
    addItem("Added feedback form.");
    addItem("Bug fixes.");

    addVersionNumber("0.6.1.02", "2020-02-24");
    addItem("Bug fixes.");

    addVersionNumber("0.6.1.01", "2020-02-23");
    addItem("Added spa.");
    addItem("Bug fixes.");

    addVersionNumber("0.6.1.0", "2020-02-22");
    addItem("Send seeds to the farm storage when lacking inventory space.");
    addItem("You can now change items and tools while riding your horse.");
    addItem("Added the Sacis.");
    addItem("Added Termite Nests.");
    addItem("New house sprites.");
    addItem("New home graphics.");
    addItem("Changed Brittany's house.");
    addItem("Changed Julia's house.");
    addItem("Changed Rory's house.");
    addItem("New general store.");
    addItem("New blacksmith.");
    addItem("New inn/restaurant.");
    addItem("New library.");
    addItem("New carpenter workshop.");
    addItem("New clinic.");
    addItem("New tasks.");
    addItem("New villagers: Duke, Sarah and Thalia.");
    addItem("New house upgrade.");
    addItem("New cooking system.");
    addItem("New animal and friend list on the diary menu.");
    addItem("Improved save/load menus.");
    addItem("Changed the way crops die.");
    addItem("New conversations.");
    addItem("New heart events.");
    addItem("New furniture shop.");
    addItem("New sound effects.");
    addItem("Separate contents of each trash can.");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.18", "2019-12-17");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.17", "2019-12-15");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.16", "2019-11-30");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.14", "2019-11-25");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.13", "2019-11-17");
    addItem("Bug fixes.");
    addItem("New Tasks.");

    addVersionNumber("0.6.0.11", "2019-11-12");
    addItem("Added bells for animal control.");
    addItem("Enabled firepit cooking.");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.10", "2019-11-11");
    addItem("Bug fixes.");

    addVersionNumber("0.6.0.00", "2019-11-01");
    addItem("Bug fixes.");
    addItem("New conversations.");
    addItem("Added health buffs.");
    addItem("Fixed health hud.");
    addItem("New design for Gabriel and Amanda.");
    addItem("Merged Milker and Clippers into a single tool.");
    addItem("Added Magnifier tool.");
    addItem("Added fallen trees.");
    addItem("Added dating system.");

    addVersionNumber("0.5.2.03", "2019-09-16");
    addItem("Bug fixes.");
    addItem("New gift preferences.");
    addItem("New way to access the Winter Fields.");
    addItem("New emotes.");
    addItem("New conversations.");
    addItem("Added animal details window.");
    addItem("Changed the formula for calculating chicken sell price.");

    addVersionNumber("0.5.2.02", "2019-09-10");
    addItem("Improved translation system for modders.");

    addVersionNumber("0.5.2.0", "2019-09-09");
    addItem("Bug fixes.");
    addItem("New festival area.");
    addItem("Added Flower Festival.");
    addItem("Fixed Chicken Race's winning odds.");
    addItem("New sprite and portrait for Serge.");
    addItem("Added Richard's portrait.");
    addItem("New emotes.");
    addItem("Increased rain chance on spring.");

    addVersionNumber("0.5.1.16", "2019-09-01");
    addItem("Bug fixes.");

    addVersionNumber("0.5.1.15", "2019-08-31");
    addItem("Bug fixes.");
    addItem("Moved extra farm land to the left side of the initial farm.");
    addItem("Implemented new beach.");
    addItem("Added Animal Sanctuary.");
    addItem("Fixed keyboard mapping screen.");
    addItem("Performance Improvements.");
    addItem("New Kinds of Rocks.");
    addItem("New Mines.");
    addItem("Added Shipped Items List to Achievements Screen.");
    addItem("Added Game Progress Details to Achievements Screen.");
    addItem("Added Fishing Rod Upgrades.");
    addItem("Changed fish spawn rate and prices.");
    addItem("Added key to open inventory directly.");
    addItem("Added shortcut to mountains.");
    addItem("Improved some graphics.");
    addItem("Implemented GamePad Profiles.");
    addItem("Added Support to Nintendo Switch JoyCons.");
    addItem("Implemented Tool Experience.");
    addItem("Added 5 new villager portraits.");
    addItem("Added TV announcements for festivals.");
    addItem("Added Snow Weather.");
    addItem("Show name of nearby crops and creatures.");
    addItem("Ores and Lumber can now be purchased after certain conditions.");
    addItem("Hay Maker now accepts wheat too.");
    addItem("Removed the bank system.");
    addItem("Removed the miner's guild.");
    addItem("Removed the fun guys.");
    addItem("New Tasks.");

    addVersionNumber("0.5.0.18", "2019-07-15");
    addItem("Bug fixes.");
    addItem("Made a few tasks slightly easier.");

    addVersionNumber("0.5.0.17", "2019-07-04");
    addItem("Bug fixes.");

    addVersionNumber("0.5.0.16", "2019-07-02");
    addItem("Bug fixes.");

    addVersionNumber("0.5.0.15", "2019-07-02");
    addItem("Added log files.");

    addVersionNumber("0.5.0.14", "2019-07-02");
    addItem("Bug fixes.");
    addItem("Increased blue ore nodes spawn rate.");

    addVersionNumber("0.5.0.13", "2019-06-27");
    addItem("Bug fixes.");

    addVersionNumber("0.5.0.12", "2019-06-24");
    addItem("Bug fixes.");

    addVersionNumber("0.5.0.11", "2019-06-24");
    addItem("Bug fixes.");

    addVersionNumber("0.5.0.10", "2019-06-24");
    addItem("Bug fixes.");
    addItem("Reorganized mouse based controls.");
    addItem("New Save System.");
    addItem("New Menu.");
    addItem("New Item Shop Screen.");
    addItem("New Animal Shop Screen.");
    addItem("New Storage Screen.");
    addItem("New Character Creation Screen.");
    addItem("New Trash Screen.");
    addItem("New Shipping Screen.");
    addItem("New Title Screen.");
    addItem("New Splash Screen.");
    addItem("New Recipes Screen.");
    addItem("New Weather Graphics.");
    addItem("Added Maps.");
    addItem("Added Credits Screen.");
    addItem("New code structure and tools for modders.");
    addItem("Added a series of tasks for unlocking the teleporter.");
    addItem("Added Cheat Codes.");
    addItem("Added Mayo Maker.");
    addItem("Added Cheese Maker.");
    addItem("Added Hay Maker.");
    addItem("Added Bird Feed Maker.");
    addItem("Added Seed Maker.");
    addItem("Hundreds of new conversations.");
    addItem("A lot of new basic tasks.");
    addItem("Using the sickle will now drop seeds and weeds.");
    addItem("Changed availability of animals in shops");
    addItem("Rebalanced crops and seeds.");
    addItem("Added Easter Eggs.");
    addItem("Added Salesman Shop.");
    addItem("Backup Saves on Steam Cloud.");
    addItem("Added Portraits for Main Characters.");
    addItem("Changed style of some villagers.");
    addItem("Renamed Cinth to Cindy.");
    addItem("Improved villager schedules.");
    addItem("Pause time inside all houses.");
    addItem("Flowers no longer need to be watered.");

    addVersionNumber("0.4.0.30", "2018-10-20");
    addItem("Bug fixes.");
    addItem("Internal changes.");

    addVersionNumber("0.4.0.20", "2018-10-04");
    addItem("Bug fixes.");
    addItem("New setting: FPS Calibration.");

    addVersionNumber("0.4.0.10", "2018-10-02");
    addItem("Bug fixes.");
    addItem("New setting: Use Screen Refresh Rate.");

    addVersionNumber("0.4", "2018-09-28");
    addItem("Bug fixes.");

    addVersionNumber("0.3.3.08", "2018-09-27");
    addItem("Improved game performance.");
    addItem("Added new conversations with Serge, Richard and Julia.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.3.07", "2018-09-26");
    addItem("Improved game performance.");

    addVersionNumber("0.3.3.06", "2018-09-25");
    addItem("Added new conversations with Serge.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.3.05", "2018-09-24");
    addItem("Restored forageable items and nerfed some of their prices.");
    addItem("Added new conversations with Devin.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.3.04", "2018-09-23");
    addItem("Bug fixes.");

    addVersionNumber("0.3.3.03", "2018-09-20");
    addItem("Bug fixes.");
    addItem("Added more fish on the mountain river.");

    addVersionNumber("0.3.3.02", "2018-09-19");
    addItem("Bug fixes.");
    addItem("Improved game performance.");

    addVersionNumber("0.3.3.01", "2018-09-19");
    addItem("Bug fixes.");
    addItem("Added festival preparation area.");
    addItem("Restored wild animals.");

    addVersionNumber("0.3.3.00", "2018-09-18");
    addItem("The whole world was redrawn.");
    addItem("Improved art style.");
    addItem("Improved game performance.");
    addItem("Rock Town was merged with Orange Town.");
    addItem("Changed they way fish spawn and how they behave.");
    addItem("Changed the way items spawn.");
    addItem("Changed game to start with a dog from the very first scene.");
    addItem("Added option to select the game speed (30, 40, 48 or 60 fps).");

    addVersionNumber("0.3.2.03", "2018-07-11");
    addItem("Changed trees.");
    addItem("Changed some areas.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.2.02", "2018-07-06");
    addItem("Prevent crops from dying too soon.");

    addVersionNumber("0.3.2.01", "2018-07-03");
    addItem("Changed trees.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.2.00", "2018-07-03");
    addItem("New cutscenes.");

    addVersionNumber("0.3.1.05", "2018-07-02");
    addItem("New fishes.");
    addItem("Changes to the fishing system.");

    addVersionNumber("0.3.1.04", "2018-07-01");
    addItem("New cutscenes.");
    addItem("New hair colors.");
    addItem("New options on the storage screen.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.1.03", "2018-06-29");
    addItem("New cutscenes.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.1.02", "2018-06-27");
    addItem("Improvements on the mod system.");
    addItem("Made a few changes to make the game more balanced.");
    addItem("New cutscenes.");
    addItem("New hair and skin colors.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.1.01", "2018-06-22");
    addItem("Multiple recipes for the same dish are now counted as one.");
    addItem("Improved game performance.");
    addItem("Bug fixes.");

    addVersionNumber("0.3.1", "2018-06-21");
    addItem("Replaced Roberto with Martin.");
    addItem("Simplified Miner's Guild quest.");
    addItem("You can now ride animals as soon as you buy them.");
    addItem("Simplified interactions with large animals.");
    addItem("Upgraded hammers now increase your chance of getting blue crystals.");
    addItem("Decreased drop rate of large blue crystals.");
    addItem("Redesigned the northern side of the forest.");
    addItem("Added new cave.");
    addItem("Added emerald nodes.");
    addItem("Added boulders.");
    addItem("Improved some graphics.");
    addItem("New gift reactions.");
    addItem("Improved Stella's routine.");
    addItem("New initial tasks.");
    addItem("Removed gates.");
    addItem("You can now jump over fences.");
    addItem("Added database screen.");
    addItem("Crops can die now.");
    addItem("Bug fixes.");
    
    addVersionNumber("0.3.0.5", "2018-05-14");
    addItem("Bug fixes.");

    addVersionNumber("0.3.0.4", "2018-05-14");
    addItem("Bug fixes.");
    addItem("Improved recipe list.");
    addItem("Added new items.");
    addItem("Increased auto tasks rewards.");
    addItem("You can now cook without kitchen utensils.");
    
    addVersionNumber("0.3.0.3", "2018-05-10");
    addItem("Bug fixes.");

    addVersionNumber("0.3.0.2", "2018-05-09");
    addItem("Fixed default volume.");
    addItem("Several bug fixes.");

    addVersionNumber("0.3.0.1", "2018-05-08");
    addItem("Added a screen to check the recipes you've already learned.");
    addItem("Several bug fixes.");

    addVersionNumber("0.3.0.0", "2018-05-07");
    addItem("Added more items and recipes.");
    addItem("Improved compatibility with different screen resolutions.");
    addItem("Fixed many bugs.");
    addItem("Improved inventory management.");
    addItem("Paused the time inside the player's house.");

    addVersionNumber("0.2.9.3", "2018-05-02");
    addItem("Added a few new items.");
    addItem("Improved gamepad support.");
    addItem("Improved compatibility with different screen resolutions.");
    addItem("Several bug fixes.");
    addItem("Removed hunger and sleepiness system.");
    addItem("Improved volume control.");

    addVersionNumber("0.2.9.2", "2018-04-30");
    addItem("Added 32 new items.");
    addItem("Added Cooking System.");
    addItem("Added 6 Cooking Utensils.");
    addItem("Added 85 Cooking Recipes.");
    addItem("Added Wandering Salesman.");
    addItem("Several bug fixes.");

    addVersionNumber("0.2.9.1", "2018-04-21");
    addItem("Recreated the inventory system.");
    addItem("Increased max inventory space.");
    addItem("Recreated the mailbox system.");
    addItem("Deep changes on the health system.");
    addItem("New HUD.");
    addItem("Many new animations.");
    addItem("You can now pass out when your stamina ends.");
    addItem("Fixed many bugs.");
    addItem("Remodeled the cemetery.");
    addItem("Added Karl.");
    
    addVersionNumber("0.2.9.0", "2018-02-14");
    addItem("Moved Mia's house to Rock Town.");
    addItem("Added a Trash Can.");
    addItem("Several bug fixes.");
    addItem("Added 9 new unlockable seeds.");
    
    addVersionNumber("0.2.8.7", "2018-02-13");
    addItem("Improved mouse support.");
    addItem("Trees will now become transparent when you stand behind them.");
    addItem("Added new gift reactions for Benjamin.");
    addItem("Made caves and night time become darker, but added light effects on the existing lamps.");
    addItem("The selected tool is now highlighted in the toolbar.");
    addItem("Changed blue crystal drop rate (small crystals are more common now).");
    addItem("Added shiny items random spawn.");
    addItem("Added Tomato Festival.");

    addVersionNumber("0.2.8.6", "2018-02-05");
    addItem("Auto Run is now enabled by default.");
    addItem("Changed the spawn rate of all items.");
    addItem("Added a lot of new items.");
    addItem("Several bug fixes.");

    addVersionNumber("0.2.8.5", "2018-01-31");
    addItem("Added new option to choose a color scheme for the menus.");
    addItem("Several bug fixes.");

    addVersionNumber("0.2.8.4", "2018-01-30");
    addItem("Added Dwarf Clouds.");
    addItem("Added Golden Oranges.");
    addItem("Several bug fixes.");

    addVersionNumber("0.2.8.3", "2018-01-28");
    addItem("Changed default font and window style.");
    addItem("Improved interface elements on small resolutions.");
    addItem("Added achievements screen.");
    addItem("Several bug fixes.");

    addVersionNumber('0.2.8.2', '2018-01-26');
    addItem("Fixed issue with empty item appearing on inventory.");

    addVersionNumber('0.2.8.1', '2018-01-23');
    addItem("Improved game performance.");
    addItem("New Setting: Max Frame Skip.");
    addItem("Several bug fixes.");

    addVersionNumber('0.2.8', '2018-01-22');
    addItem("Fixed hud flickering.");
    addItem("Fixed invalid location when moving between summer areas.");
    addItem("Added new villager conversations.");
    addItem("Improved calendar.");
    addItem("Changed general store layout.");
    addItem("Improved game performance.");
    addItem("Added Green Watering Can Update.");
    addItem("Added a New Shop Scene and used it on all stores.");
    addItem("Tool Upgrading now takes a few days to complete.");
    addItem("Added an option to sell animals.");
    addItem("Added an option to chat and gift villagers while they work.");
    addItem("Changed blue crystal drop rate to be less random.");

    addVersionNumber('0.2.7.2', '2018-01-10');
    addItem("Fixed issue that caused the rooster to never be delivered.");
    addItem("Fixed the Curupira's quest triggers.");

    addVersionNumber('0.2.7.1', '2018-01-09');
    addItem("Added option to shutdown the game from the pause menu.");
    addItem("Changed watered tiled soil color.");
    addItem("Fixed bug that could be used to duplicate items.");
    addItem("Fixed issue that caused objects to stop working if you were inside the mines at 6am.");
    addItem("Fixed issue that caused the game to crash on macs.");
    addItem("Fixed issue that caused the game to give the player free items\n when they don't have enough money to buy something.");

    addVersionNumber('0.2.7', '2018-01-08');
    
    addItem("New character: The Curupira.");
    addItem("Companion System.");
    addItem("Added Raphael's companion skill.");
    addItem("Added Devin's companion skill.");
    addItem("Added Nathalia's companion skill.");
    addItem("Added Benjamin's companion skill.");
    addItem("Added Annie's companion skill.");
    addItem("Added Viktor's companion skill.");
    addItem("Added Julia's companion skill.");
    addItem("Added quest to lift the forest spell.");
    addItem("You can now gift villagers every day.");
    addItem("New items on Chloe's Shop: Coffee and Hot Milk.");
    addItem("Added 4 new forest areas.");
    addItem("Added a new cave.");
    addItem("Added Forest of the Eternal Fall and the Fall Fields.");
    addItem("Fixed issues with cave puzzles breaking after going to sleep.");
    addItem("Fixed issues that caused ducks to change color.");
    addItem("Fixed issue that caused animals to get stuck inside your house.");
    addItem("Created a new screen for purchasing animals.");
    addItem("Added an option to type names with the keyboard.");
    addItem("Added Patch Notes window.");

    return Managers.Text.replaceBasicTextVariables(fullText);
  }
};

Managers.Updates.currentVersion = 0.6206;
// Save format version NEEDS to be changed everytime there's anything more than bug fixes
Managers.Updates.saveFormatVersion = 0.6206;
Managers.Updates.currentVersionStr = "0.6.2.06 (Early Access)";
Managers.Updates.minVersion = 0.102;