//-----------------------------------------------------------------------------
// ToolManager
//
// The static class that handles the usage of tools
Managers.Tools = class Tools {
  constructor() {
    throw new Error('This is a static class');
  }

  static get toolId() {
    return this._toolId;
  }
  static set toolId(value) {
    this._toolId = value;
  }

  static get maxWater() {
    if (Switches.hasGreenWateringCan) {
      return 200;
    } else if (Switches.hasRedWateringCan) {
      return 100;
    } else if (Switches.hasSilverWateringCan) {
      return 50;
    } else if (Switches.hasRegularWateringCan) {
      return 25;
    } else {
      return 0;
    }
  }

  static get effectiveToolId() {
    if (Managers.Items.isHoldingItem()) {
      return Managers.Items.selectedItem.id;
    } else {
      if (Managers.Items.waiting) {
        return undefined;
      }

      return this.toolId;
    }
  }

  static get effectiveTool() {
    const toolId = this.effectiveToolId;
    return toolId ? this.getTool(toolId) : null;
  }

  static get toolLevel() {
    return this.getMaxToolLevel() || 0;
  }

  static setTool(toolId) {
    if (toolId === undefined || toolId === 'empty') {
      this.toolId = undefined;
    } else {
      this.toolId = toolId;
      Managers.Sound.playEquip();
      Managers.Items.runEvent(`equip-${toolId}`);
    }

    Managers.Items.requestHudRefresh();
  }

  static storeTool() {
    this.setTool('empty');
  }

  static registerTool(toolClass) {
    this.toolList[toolClass.toolName] = toolClass;
  }

  static isToolValid(toolId) {
    return this.getTool(toolId) !== undefined;
  }

  static getMaxToolLevel(toolId) {
    if (!toolId) toolId = this.effectiveToolId;

    const data = this.getTool(toolId);
    if (data) {
      return data.level || 0;
    }

    return 0;
  }

  static isToolTypeEquipped(toolType) {
    if (!this._toolId) return false;
    const toolId = this.effectiveToolId;

    if (toolId && toolId.indexOf(toolType) >= 0) return true;

    if (toolId == 'animal-tools') {
      if (toolType == 'milker') return true;
      if (toolType == 'clippers') return true;
    }

    return false;
  }

  static getTool(toolId) {
    return this.toolList[toolId] || undefined;
  }

  static getAffectedTiles(includeInvalid, useCurrentMousePosition) {
    const tool = this.getTool(this.effectiveToolId);

    if (tool) {
      return tool.getAffectedTiles(tool.level || 0, includeInvalid, useCurrentMousePosition);
    } else {
      return [];
    }
  }

  static useToolId(toolId) {
    const tool = this.getTool(toolId);
    if (!tool) return false;

    tool.preloadSprite();
    const result = tool.use(tool.level);

    this.clearTargetTile();
    return result !== false;
  }

  static useToolAt(x, y) {
    return this.useTool(new TileHelper.Tile(x, y));
  }

  static useToolAtEvent(event) {
    const tool = this.getTool(this.effectiveToolId);
    if (tool && tool.useAtEvent) {
      return tool.useAtEvent(event, tool.level);
    }

    return this.useToolAt(event.x, event.y);
  }

  static toolCanBeUsedAnywhere() {
    const toolId = this.effectiveToolId;

    if (toolId == 'teleport') return true;
    if (toolId == 'sleep') return true;

    return false;
  }

  static useTool(targetTile = null) {
    const tool = this.getTool(this.effectiveToolId);
    let result = false;

    if (tool !== undefined) {
      tool.preloadSprite();
      result = tool.use(tool.level, targetTile);
    }

    this.clearTargetTile();
    return result !== false;
  }

  static isTileBetterThanDefault(x, y, checkIfItIsDefault = false) {
    const tool = this.getTool(this.effectiveToolId);

    if (tool === undefined) {
      return false;
    }

    const distance = $gamePlayer.distanceToTile(x, y);

    const distanceOk = distance <= (tool.usageDistance - 0.25);
    const result = distanceOk && tool.isTileBetterThanDefault(x, y);

    if (checkIfItIsDefault && !result) {
      const defaultTile = tool.getFrontTile();
      if (defaultTile && defaultTile.x == x && defaultTile.y == y) {
        return true;
      }
    }

    return result;
  }

  static setTargetTile(x, y) {
    this.targetTile = TileHelper.newTile(x, y);
  }

  static clearTargetTile() {
    this.targetTile = false;
  }

  static getAllTools() {
    const tools = this.tools();
    const list = [];

    for (let i = 0; i < tools.length; i++) {
      list.push(tools[i].id);
    }

    return list;
  }

  static getHotkeyConfig() {
    const tools = this.tools();

    const shortcuts = {
      '10' : 'empty'
    };

    for (let i = 0; i < tools.length; i++) {
      if (!tools[i]) continue;
      if (tools[i].hotkey === undefined || tools[i].hotkey === null) continue;

      shortcuts[tools[i].hotkey] = tools[i].id;
    }

    return shortcuts;
  }

  static toolsOnly(includeNulls) {
    const tools = [];

    let hoeId = '';
    let hoeIcon = 1;
    let hoeExp = 0;
    let nextHoeIcon = 0;
    let nextHoeId = '';

    let hammerId = '';
    let hammerIcon = 49;
    let hammerExp = 0;
    let nextHammerIcon = 0;
    let nextHammerId = '';

    let sickleId = '';
    let sickleIcon = 81;
    let sickleExp = 0;
    let nextSickleIcon = 0;
    let nextSickleId = '';

    let axeId = '';
    let axeIcon = 33;
    let axeExp = 0;
    let nextAxeIcon = 0;
    let nextAxeId = '';

    let canId = '';
    let canIcon = 32;
    let canExp = 0;
    let nextCanIcon = 0;
    let nextCanId = '';

    let rodId = '';
    let rodIcon = 64;
    let rodExp = 0;
    let nextRodIcon = 0;
    let nextRodId = '';

    let toolOnBlacksmith;
    if (Switches.viktorIsUpgradingTool) {
      toolOnBlacksmith = Variables.viktorToolBeingUpgraded;
    }

    if (Switches.hasDiamondHoe && toolOnBlacksmith != 'hoe' && Managers.Player.hoeExp >= 3000) {
      hoeId = 'diamond-hoe';
      hoeIcon += 3;
      hoeExp = 100;
    } else if (Switches.hasGoldenHoe && toolOnBlacksmith != 'hoe' && Managers.Player.hoeExp >= 1500) {
      hoeId = 'golden-hoe';
      hoeIcon += 2;
      hoeExp = (Managers.Player.hoeExp - 1500) / 15;
      // nextHoeIcon = 4;
      // nextHoeId = 'diamond-hoe';
    } else if (Switches.hasSilverHoe && toolOnBlacksmith != 'hoe' && Managers.Player.hoeExp >= 750) {
      hoeId = 'silver-hoe';
      hoeIcon += 1;
      hoeExp = (Managers.Player.hoeExp - 750) / 7.5;
      nextHoeIcon = 3;
      nextHoeId = 'golden-hoe';
    } else if (Switches.hasCopperHoe && toolOnBlacksmith != 'hoe' && Managers.Player.hoeExp >= 250) {
      hoeId = 'copper-hoe';
      hoeExp = (Managers.Player.hoeExp - 250) / 5;
      nextHoeIcon = 2;
      nextHoeId = 'silver-hoe';
    } else if (Switches.hasIronHoe && toolOnBlacksmith != 'hoe') {
      hoeId = 'iron-hoe';
      hoeIcon = 65;
      hoeExp = Managers.Player.hoeExp / 2.5;
      nextHoeIcon = 1;
      nextHoeId = 'copper-hoe';
    }

    if (Switches.hasDiamondHammer && toolOnBlacksmith != 'hammer' && Managers.Player.miningExp >= 3000) {
      hammerId = 'diamond-hammer';
      hammerIcon += 3;
      hammerExp = 100;
    } else if (Switches.hasGoldenHammer && toolOnBlacksmith != 'hammer' && Managers.Player.miningExp >= 1500) {
      hammerId = 'golden-hammer';
      hammerIcon += 2;
      hammerExp = (Managers.Player.miningExp - 1500) / 15;
      // nextHammerIcon = 52;
      // nextHammerId = 'diamond-hammer';
    } else if (Switches.hasSilverHammer && toolOnBlacksmith != 'hammer' && Managers.Player.miningExp >= 750) {
      hammerId = 'silver-hammer';
      hammerIcon += 1;
      hammerExp = (Managers.Player.miningExp - 750) / 7.5;
      nextHammerIcon = 51;
      nextHammerId = 'golden-hammer';
    } else if (Switches.hasCopperHammer && toolOnBlacksmith != 'hammer' && Managers.Player.miningExp >= 250) {
      hammerId = 'copper-hammer';
      hammerExp = (Managers.Player.miningExp - 250) / 5;
      nextHammerIcon = 50;
      nextHammerId = 'silver-hammer';
    } else if (Switches.hasIronHammer && toolOnBlacksmith != 'hammer') {
      hammerId = 'iron-hammer';
      hammerIcon = 67;
      nextHammerIcon = 49;
      hammerExp = Managers.Player.miningExp / 2.5;
      nextHammerId = 'copper-hammer';
    }

    if (Switches.hasDiamondSickle && toolOnBlacksmith != 'sickle' && Managers.Player.sickleExp >= 3000) {
      sickleId = 'diamond-sickle';
      sickleIcon += 3;
      sickleExp = 100;
    } else if (Switches.hasGoldenSickle && toolOnBlacksmith != 'sickle' && Managers.Player.sickleExp >= 1500) {
      sickleId = 'golden-sickle';
      sickleIcon += 2;
      sickleExp = (Managers.Player.sickleExp - 1500) / 15;
      // nextSickleIcon = 84;
      // nextSickleId = 'diamond-sickle';
    } else if (Switches.hasSilverSickle && toolOnBlacksmith != 'sickle' && Managers.Player.sickleExp >= 750) {
      sickleId = 'silver-sickle';
      sickleIcon += 1;
      sickleExp = (Managers.Player.sickleExp - 750) / 7.5;
      nextSickleIcon = 83;
      nextSickleId = 'golden-sickle';
    } else if (Switches.hasCopperSickle && toolOnBlacksmith != 'sickle' && Managers.Player.sickleExp >= 250) {
      sickleId = 'copper-sickle';
      sickleExp = (Managers.Player.sickleExp - 250) / 5;
      nextSickleIcon = 82;
      nextSickleId = 'silver-sickle';
    } else if (Switches.hasIronSickle && toolOnBlacksmith != 'sickle') {
      sickleId = 'iron-sickle';
      sickleIcon = 68;
      sickleExp = Managers.Player.sickleExp / 2.5;
      nextSickleIcon = 81;
      nextSickleId = 'copper-sickle';
    }

    if (Switches.hasDiamondAxe && toolOnBlacksmith != 'axe' && Managers.Player.woodcuttingExp >= 3000) {
      axeId = 'diamond-axe';
      axeIcon += 3;
      axeExp = 100;
    } else if (Switches.hasGoldenAxe && toolOnBlacksmith != 'axe' && Managers.Player.woodcuttingExp >= 1500) {
      axeId = 'golden-axe';
      axeIcon += 2;
      axeExp = (Managers.Player.woodcuttingExp - 1500) / 15;
      // nextAxeIcon = 36;
      // nextAxeId = 'diamond-axe';
    } else if (Switches.hasSilverAxe && toolOnBlacksmith != 'axe' && Managers.Player.woodcuttingExp >= 750) {
      axeId = 'silver-axe';
      axeIcon += 1;
      axeExp = (Managers.Player.woodcuttingExp - 750) / 7.5;
      nextAxeIcon = 35;
      nextAxeId = 'golden-axe';
    } else if (Switches.hasCopperAxe && toolOnBlacksmith != 'axe' && Managers.Player.woodcuttingExp >= 250) {
      axeId = 'copper-axe';
      axeExp = (Managers.Player.woodcuttingExp - 250) / 5;
      nextAxeIcon = 34;
      nextAxeId = 'silver-axe';
    } else if (Switches.hasIronAxe && toolOnBlacksmith != 'axe') {
      axeId = 'iron-axe';
      axeIcon = 66;
      axeExp = Managers.Player.woodcuttingExp / 2.5;
      nextAxeIcon = 33;
      nextAxeId = 'copper-axe';
    } else if (Switches.hasBrokenAxe && toolOnBlacksmith != 'axe') {
      axeId = 'broken-axe';
      axeIcon = 289;
      axeExp = 100;
      nextAxeIcon = 66;
      nextAxeId = 'iron-axe';
    }

    if (Switches.hasGreenWateringCan && toolOnBlacksmith != 'watering-can' && Managers.Player.waterExp >= 3000) {
      //Emerald
      canId = 'green-watering-can';
      canIcon = 211;
      canExp = 100;
    } else if (Switches.hasRedWateringCan && toolOnBlacksmith != 'watering-can' && Managers.Player.waterExp >= 2000) {
      //Ruby
      canId = 'red-watering-can';
      canIcon = 209;
      canExp = (Managers.Player.waterExp - 2000) / 10;
      nextCanIcon = 211;
      nextCanId = 'green-watering-can';
    } else if (Switches.hasSilverWateringCan && toolOnBlacksmith != 'watering-can' && Managers.Player.waterExp >= 1000) {
      //Crystal and Silver
      canId = 'silver-watering-can';
      canIcon = 210;
      canExp = (Managers.Player.waterExp - 1000) / 10;
      nextCanIcon = 209;
      nextCanId = 'red-watering-can';
    } else if (Switches.hasRegularWateringCan && toolOnBlacksmith != 'watering-can') {
      canId = 'watering-can';
      canExp = Managers.Player.waterExp / 10;
      nextCanIcon = 210;
      nextCanId = 'silver-watering-can';
    }

    if (Switches.hasBlueFishingRod && toolOnBlacksmith != 'fishing-rod' && Managers.Player.fishingExp >= 2000) {
      rodId = 'blue-fishing-rod';
      rodIcon = 460;
      rodExp = 100;
    } else if (Switches.hasGreenFishingRod && toolOnBlacksmith != 'fishing-rod' && Managers.Player.fishingExp >= 1000) {
      rodId = 'green-fishing-rod';
      rodIcon = 459;
      rodExp = (Managers.Player.fishingExp - 1000) / 10;
      nextRodIcon = 460;
      nextRodId = 'blue-fishing-rod';
    } else if (Switches.hasFishingRod && toolOnBlacksmith != 'fishing-rod') {
      rodId = 'fishing-rod';
      rodExp = Managers.Player.fishingExp / 10;
      nextRodIcon = 459;
      nextRodId = 'green-fishing-rod';
    }

    if (hoeId !== '') {
      tools.push({
        type : 'tool',
        toolType: 'hoe',
        id : hoeId,
        iconIndex : hoeIcon,
        hotkey : 1,
        exp: hoeExp.clamp(0, 100),
        nextIcon: nextHoeIcon,
        nextId: nextHoeId
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (canId !== '') {
      tools.push({
        type : 'tool',
        toolType: 'watering-can',
        id : canId,
        iconIndex : canIcon,
        hotkey : 2,
        exp: canExp.clamp(0, 100),
        nextIcon: nextCanIcon,
        nextId: nextCanId
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (hammerId !== '') {
      tools.push({
        type : 'tool',
        toolType: 'hammer',
        id : hammerId,
        iconIndex : hammerIcon,
        hotkey : 3,
        exp: hammerExp.clamp(0, 100),
        nextIcon: nextHammerIcon,
        nextId: nextHammerId
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (axeId !== '') {
      tools.push({
        type : 'tool',
        toolType: 'axe',
        id : axeId,
        iconIndex : axeIcon,
        hotkey : 4,
        exp: axeExp.clamp(0, 100),
        nextIcon: nextAxeIcon,
        nextId: nextAxeId
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (sickleId !== '') {
      tools.push({
        type : 'tool',
        toolType: 'sickle',
        id : sickleId,
        iconIndex : sickleIcon,
        hotkey : 5,
        exp: sickleExp.clamp(0, 100),
        nextIcon: nextSickleIcon,
        nextId: nextSickleId
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (rodId !== '') {
      tools.push({
        type : 'tool',
        toolType: 'rod',
        id : rodId,
        iconIndex : rodIcon,
        hotkey : 6,
        exp: rodExp.clamp(0, 100),
        nextIcon: nextRodIcon,
        nextId: nextRodId
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (Switches.hasMilker && Switches.hasClippers) {
      tools.push({
        type : 'tool',
        toolType: 'animal-tools',
        id : 'animal-tools',
        iconIndex : 390,
        hotkey : 7,
        exp : 0,
        nextIcon: 0,
        nextId: ''
      });
    } else if (Switches.hasMilker) {
      tools.push({
        type : 'tool',
        toolType: 'milker',
        id : 'milker',
        iconIndex : 16,
        hotkey : 7,
        exp : 0,
        nextIcon: 0,
        nextId: ''
      });
    } else if (Switches.hasClippers) {
      tools.push({
        type : 'tool',
        toolType: 'clippers',
        id : 'clippers',
        iconIndex : 48,
        hotkey : 7,
        exp: 0,
        nextIcon: 0,
        nextId: ''
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    if (Switches.hasMagnifier) {
      tools.push({
        type : 'tool',
        toolType: 'magnifier',
        id : 'magnifier',
        iconIndex : 342,
        hotkey : 8,
        exp: 0,
        nextIcon: 0,
        nextId: ''
      });
    } else if (includeNulls) {
      tools.push(null);
    }

    Managers.Content.vetoToolList(tools);

    return tools;
  }

  static skillsOnly(includeNulls) {
    const skills = [];

    if (Switches.hasRibbon) {
      skills.push({
        type : 'tool',
        toolType: 'teleport',
        id : 'teleport',
        iconIndex : 397,
        hotkey: 9,
        exp : 0,
        nextIcon: 0,
        nextId: ''
      });
    } else if (includeNulls) {
      skills.push(null);
    }

    skills.push({
      type : 'tool',
      toolType: 'sleep',
      id : 'sleep',
      iconIndex : 389,
      hotkey: 0,
      exp : 0,
      nextIcon: 0,
      nextId: ''
    });

    Managers.Content.vetoSkillList(skills);
    return skills;
  }

  static tools(includeNulls) {
    return this.toolsOnly(includeNulls).concat(this.skillsOnly(includeNulls));
  }

  static shouldToolBeUsedOnEvent(event) {
    const tool = this.effectiveTool;
    if (!tool) return false;

    return tool.shouldBeUsedOnEvent(event);
  }
};

Managers.Tools.toolId = undefined;
Managers.Tools.toolList = {};
Managers.Tools.targetTile = false;
Managers.Tools.water = 0;
