Managers.Shop = class Shop {
  static prepareShopForSwitch(switchId) {
    this.switchId = switchId;
  }

  static openShopSceneForItem(itemId) {
    Managers.Scenes.snapForBackground();
    Managers.Scenes.push(GameScenes.ShopItem);
    Managers.Scenes.prepareNextScene(itemId);
  }

  static maxBuyNumberForItem(item, price, ingredients) {
    if (!item) {
      return 0;
    }

    if (price === undefined || isNaN(price)) {
      price = Managers.Items.getBuyPrice(item.id);
    }

    if (ingredients === undefined) {
      ingredients = Managers.Items.getItemIdIngredients(item.id);
    }

    const itemMax = Managers.Items.maxItems(item);
    let max = itemMax - Managers.Items.numItems(item);

    if ((item.amount || item.amount === 0) && item.amount < max) {
      max = item.amount;
    }

    if (price > 0) {
      const gold = Managers.Items.gold >= 1000000 ? 999999 : Managers.Items.gold;
      max = Math.min(max, Math.floor(gold / price));
    }

    if (!!ingredients && ingredients.length > 0) {
      for (let i = 0; i < ingredients.length; i++) {
        const numItems = Managers.Items.numItemsById(ingredients[i]);
        let times = 0;
        for (let j = 0; j < ingredients.length; j++) {
          if (ingredients[j] == ingredients[i]) {
            times++;
          }
        }

        if (numItems / times < max) {
          max = Math.floor(numItems / times);
        }
      }
    }

    return max;
  }

  static clear() {
    this.switchId = 0;
  }

  static addChicksToList(list) {
    list.push('chick');
  }

  static addChickensToList(list) {
    list.push('chicken');
    list.push('dark-chicken');
    list.push('cinnamon-chicken');
    list.push('brown-chicken');
  }

  static addGoatsToList(list) {
    list.push('goat');
    list.push('goat2');
    list.push('goat3');
    list.push('goat4');
    list.push('goat5');
    list.push('goat6');
  }

  static addMountainGoatsToList(list) {
    list.push('mountain-goat');
    list.push('mountain-goat2');
    list.push('mountain-goat3');
    list.push('mountain-goat4');
    list.push('mountain-goat5');
    list.push('mountain-goat6');
    list.push('mountain-goat7');
    list.push('mountain-goat8');
  }

  static addYaksToList(list) {
    list.push('yak');
    list.push('yak2');
    list.push('yak3');
    list.push('yak4');
    list.push('yak5');
    list.push('yak6');
    list.push('yak7');
    list.push('yak8');
  }

  static addHorsesToList(list) {
    list.push('horse');
  }

  static addCowsToList(list) {
    list.push('cow');
    list.push('cow2');
    list.push('cow3');
    list.push('cow4');
    list.push('cow5');
    list.push('cow6');
    list.push('cow7');
    list.push('cow8');
  }

  static addSheepToList(list) {
    list.push('sheep');
    list.push('sheep2');
    list.push('sheep3');
    // list.push('sheep4');
    // list.push('sheep5');
    list.push('sheep6');
    list.push('sheep7');
    list.push('sheep8');
    list.push('sheep9');
    list.push('sheep10');
    list.push('sheep11');
  }

  static buyBrittanyAnimals() {
    Managers.Scenes.snapForBackground();
    Managers.Scenes.push(GameScenes.AnimalsForSale);

    const animalTypes = [];
    this.addChicksToList(animalTypes);
    this.addChickensToList(animalTypes);
    this.addCowsToList(animalTypes);
    this.addSheepToList(animalTypes);
    this.addGoatsToList(animalTypes);
    this.addHorsesToList(animalTypes);

    Managers.Scenes.prepareNextScene(animalTypes);
  }

  static buyRoryAnimals() {
    Managers.Scenes.snapForBackground();
    Managers.Scenes.push(GameScenes.AnimalsForSale);

    const animalTypes = [];
    this.addMountainGoatsToList(animalTypes);
    this.addYaksToList(animalTypes);

    Managers.Scenes.prepareNextScene(animalTypes);
  }
};

Managers.Shop.clear();
