Managers.ShippingBin = class ShippingBin {
  static get container() {
    return this._container;
  }

  static clear() {
    if (!this._container) {
      this._container = new Engine.ItemContainer();
    }

    this._container.clear();
  }

  static onChangeTime() {
    if (Managers.Time.hour === 8 && Managers.Time.minute === 0 && Managers.Time.seconds === 0) {
      this.sellBinContents();
      return;
    }
  }

  static getItemTotal() {
    const items = this.container._items;
    const len = items.length;
    let totalGold = 0;

    for (let i = 0; i < len; i++) {
      const item = items[i];
      if (!item) continue;

      totalGold += item.amount * Managers.Items.getSellPrice(item.id);
    }

    return totalGold;
  }

  static sellBinContents() {
    const items = this.container._items;
    const len = items.length;
    let totalGold = 0;

    for (let i = 0; i < len; i++) {
      const item = items[i];
      if (!item) continue;

      const sellPrice = Managers.Items.getSellPrice(item.id);
      if (sellPrice > 0) {
        totalGold += item.amount * sellPrice;
        Managers.History.registerItemShipped(item.id, item.amount, totalGold);
        
        this.container.loseItem(item, item.amount);
      }
    }

    Managers.Items.gainGold(totalGold, true);
    Variables.shippedItems = Managers.History.getNumberOfItemsShippedToday();
  }

  static openBin() {
    if ($gameMap._mapId !== Maps.FARM) return;
    const eventData = $gameMap.event(1);
    if (!eventData) return;

    eventData.doDoorAnimation(false);
  }

  static closeBin() {
    if ($gameMap._mapId !== Maps.FARM) return;
    const eventData = $gameMap.event(1);
    if (!eventData) return;

    eventData.doCloseDoorAnimation(false);
  }
};

Managers.ShippingBin.clear();

Managers.Time.on('changeTime', Managers.ShippingBin.onChangeTime.bind(Managers.ShippingBin));