Managers.Preload = class Preload {
  constructor() {
    throw new Error('This is a static class');
  }

  static getFilesToPreload(moment) {
    const images = [];
    const sounds = [];

    for (const fileFolder of $dataPreload) {
      if (moment && fileFolder.when != moment) continue;

      let list;
      if (fileFolder.type === "img") {
        list = images;
      } else if (fileFolder.type === "sound") {
        list = sounds;
      } else {
        continue;
      }

      for (let j = 0; j < fileFolder.files.length; j++) {
        list.push({
          "folder" : fileFolder.folder,
          "filename" : fileFolder.files[j]
        });
      }
    }

    return {
      images,
      sounds
    };
  }

  static onLoadImage() {
    this._imagesLoaded++;

    if (this._imagesLoaded == this._imagesToLoad) {
      this._callback.call();
    }
  }

  static preloadFiles(callback, moment) {
    Engine.Data.loadDataFile('$dataPreload', 'Preload.json', () => {
      const files = this.getFilesToPreload(moment);

      this._imagesToLoad = files.images.length;
      this._soundsToLoad = files.sounds.length;
      this._imagesLoaded = 0;
      this._soundsLoaded = 0;
      this._callback = callback;

      let bitmap;
      for (let i = 0; i < files.images.length; i++) {
        bitmap = Managers.Images.loadBitmap(files.images[i].folder, files.images[i].filename);
        bitmap.addLoadListener(this.onLoadImage.bind(this));
      }
    });
  }
};