Managers.Player = class Player {
  static clear() {
    this._birthday = 0;
    this._skinType = 'a';
    this._hairType = 1;
    this._sprite = 'hero';
    this._gender = 'male';

    this.miningExp = 0;
    this.farmingExp = 0;
    this.fishingExp = 0;
    this.walkingExp = 0;
    this.cookingExp = 0;
    this.woodcuttingExp = 0;
    this.talkingExp = 0;
    this.sleepingExp = 0;
    this.magicExp = 0;
    this.sickleExp = 0;
    this.waterExp = 0;
    this.hoeExp = 0;

    this.costumeName = '';

    if ($gameActors) {
      this._name = $gameActors.actor(1).name();
    }
  }

  static getData() {
    return {
      birthday : this._birthday,
      skinType : this._skinType,
      hairType : this._hairType,
      sprite : this._sprite,
      gender : this._gender,
      costumeName : this.costumeName,

      miningExp : this.miningExp,
      farmingExp : this.farmingExp,
      fishingExp : this.fishingExp,
      walkingExp : this.walkingExp,
      cookingExp : this.cookingExp,
      woodcuttingExp : this.woodcuttingExp,
      sickleExp : this.sickleExp,
      waterExp : this.waterExp,
      hoeExp : this.hoeExp,
      talkingExp : this.talkingExp,
      sleepingExp : this.sleepingExp,
      magicExp : this.magicExp
    };
  }

  static setData(data, gamePlayer) {
    this.clear();
    if (!data) return;

    if (data.birthday) {
      this._birthday = data.birthday;
    }

    if (data.skinType) {
      this._skinType = data.skinType;
    }

    if (data.hairType) {
      this._hairType = data.hairType;
    }

    if (data.sprite) {
      this._sprite = data.sprite;
    }

    if (data.gender) {
      if (data.gender == 'female') {
        this._gender = 'female';
      } else {
        this._gender = 'male';
      }
    }

    if (data.costumeName) {
      this.costumeName = data.costumeName;
    }

    if (data.miningExp) {
      this.miningExp = Number(data.miningExp) || 0;
    }

    if (data.farmingExp) {
      this.farmingExp = Number(data.farmingExp) || 0;
    }

    if (data.waterExp) {
      this.waterExp = Number(data.waterExp) || 0;
    }

    if (data.hoeExp) {
      this.hoeExp = Number(data.hoeExp) || 0;
    }

    if (data.sickleExp) {
      this.sickleExp = Number(data.sickleExp) || 0;
    }

    if (data.fishingExp) {
      this.fishingExp = Number(data.fishingExp) || 0;
    }

    if (data.walkingExp) {
      this.walkingExp = Number(data.walkingExp) || 0;
    }

    if (data.cookingExp) {
      this.cookingExp = Number(data.cookingExp) || 0;
    }

    if (data.woodcuttingExp) {
      this.woodcuttingExp = Number(data.woodcuttingExp) || 0;
    }

    if (data.talkingExp) {
      this.talkingExp = Number(data.talkingExp) || 0;
    }

    if (data.sleepingExp) {
      this.sleepingExp = Number(data.sleepingExp) || 0;
    }

    if (data.magicExp) {
      this.magicExp = Number(data.magicExp) || 0;
    }

    if (gamePlayer) {
      const actor = gamePlayer.actor();
      if (actor) {
        this._name = actor.name();
      }
    }

    // this.changeActorData();
  }

  static genderName() {
    if (this._gender == 'female') {
      return t('Female');
    }

    return t('Male');
  }

  static getName() {
    return $gameActors.actorName(1);
  }

  static getSkinLabel() {
    return this._skinType.toUpperCase();
  }

  static getSkinValue() {
    return this._skinType;
  }

  static getBirthdayLabel() {
    if (this._birthday === 0) return t('Not Set');

    return '';
  }

  static getHairColor() {
    return this._hairType;
  }

  static getSpriteName() {
    return this._sprite;
  }

  static getSpriteLabel() {
    switch(this._sprite) {
      case 'hero':
        return t('Classic (male)');
      case 'heroine':
        return t('Classic (female)');
      default:
        return this._sprite;
    }
  }

  static generatePlayerSpriteName() {
    const contentSpriteName = Managers.Content.generatePlayerSpriteName();
    if (contentSpriteName && typeof contentSpriteName == 'string') {
      return contentSpriteName;
    }

    let name = '';

    name += this._sprite;
    name += this._hairType;
    name += this._skinType;

    return name;
  }

  static generatePlayerRidingSpriteName(animalType) {
    let name = '$';

    name += this._sprite;
    name += this._hairType;
    name += this._skinType;
    name += '_riding_';
    name += 'horse[4]';

    return name;
  }

  static changeCostumeName(newCostumeName) {
    if (this.costumeName == newCostumeName) {
      this.costumeName = '';
    } else {
      this.costumeName = newCostumeName || '';
    }

    this.changeActorData(false);

    $gamePlayer.refresh();
  }

  static changeActorData(preloadSprites) {
    const name = this.generatePlayerSpriteName();
    if (preloadSprites) {
      this.preloadSprites(name);
    }

    $gameActors.clear();
    $gamePlayer._characterName = name;

    const actor = $gameActors.actor(1);

    actor.setName(this._name);

    $gamePlayer._hitboxHeight = actor.hitboxHeight;
    $gamePlayer._hitboxWidth = actor.hitboxWidth;
    $gamePlayer._hitboxX = actor.hitboxX;
    $gamePlayer._hitboxY = actor.hitboxY;
  }

  static preloadSprites(baseName) {
    if (!Managers.Scenes.shouldPreloadSprites()) return;

    if (!baseName) {
      baseName = this.generatePlayerSpriteName();
    }

    const loadCharacter = (characterName, bitmapType) => {
      this._bitmapCache[bitmapType] = characterName;
    };

    this._bitmapCache = {};

    loadCharacter(baseName, 'default');
  }

  static isPreloadingReady() {
    for (let key in this._bitmapCache) {
      if (!this._bitmapCache.hasOwnProperty(key)) continue;
      if (this._bitmapCache[key].isReady()) continue;

      return false;
    }

    return true;
  }

  static clearPreloadData() {
    this._bitmapCache = {};
  }

  static getPreloadProgress() {
    let heartCount = 0;
    let totalCount = 0;
    let ignoreRemainingSprites = false;

    const checkSprite = (spriteType) => {
      totalCount++;
      const bitmap = this._bitmapCache[spriteType];

      if (!bitmap) return false;
      if (typeof bitmap == 'string') {
        if (ignoreRemainingSprites) return false;

        this._bitmapCache[spriteType] = Managers.Images.loadCharacter(bitmap);
        ignoreRemainingSprites = true;
        return false;
      }

      if (!bitmap.isReady()) {
        ignoreRemainingSprites = true;
        return false;
      }

      heartCount++;
      return true;
    };

    checkSprite('default');

    if (totalCount === 0) {
      return 0;
    }

    if (heartCount === totalCount) {
      return 1000;
    }

    return Math.round(heartCount * 1000 / totalCount).clamp(0, 1000);
  }

  static getGenderList() {
    return [
      'male',
      'female'
    ];
  }

  static getGender() {
    return this._gender;
  }

  static isMale() {
    return this._gender == 'male';
  }

  static getSkinList() {
    return [
      'a',
      'b',
      'c',
      'd',
      'e',
      'f',
      'g'
    ];
  }

  static getHairColorList() {
    const list = [];

    for (let i = 1; i <= 19; i++) {
      list.push(i);
    }

    return list;
  }

  static getSpriteList() {
    return [
      'hero',
      'heroine'
    ];
  }

  static recreateCharacter() {
    $gameTemp._isGameRunning = true;

    $gameTemp._initialData = this.getData();
    $gameTemp._initialName = this.getName();

    Managers.Scenes.push(GameScenes.CreateCharacter);
  }

  static createRandomCharacter() {
    const skinList = this.getSkinList();
    const hairList = this.getHairColorList();

    const skinIdx = Math.randomInt(skinList.length - 1); //Avoid the green skin as a default
    const hairIdx = Math.randomInt(hairList.length);

    if (Math.randomInt(2) === 1) {
      this._gender = 'male';
      this._sprite = 'hero';
    } else {
      this._gender = 'female';
      this._sprite = 'heroine';
    }

    this._hairType = hairList[hairIdx];
    this._skinType = skinList[skinIdx];
  }
};

Managers.Player._bitmapCache = {};
Managers.Player._name = '';

Managers.Player.clear();