Managers.PaperDolls = class PaperDolls {
  static registerPaperDoll(characterName, cards) {
    this.paperDolls[characterName] = cards;
  }

  static isPaperDollCharacter(characterName) {
    return this.paperDolls.hasOwnProperty(characterName);
  }

  static loadCharacter(fileName, hue) {
    const key = `paperdoll-${fileName}`;
    let bitmap = Managers.Images.cache.getItem(key);

    if (!bitmap) {
      const cards = this.paperDolls[fileName];
      if (!cards) {
        throw new Error(`Character Paper Doll Configuration not found: ${fileName}`);
      }

      bitmap = new Bitmap(10, 10);
      bitmap._loadingState = 'waiting';
      Managers.Images.cache.setItem(key, bitmap);

      let cardsLoaded = 0;
      const loadListenerFn = loadedCardBitmap => {
        if (bitmap.width < loadedCardBitmap.width || bitmap.height < loadedCardBitmap.height) {
          bitmap.resize(Math.max(bitmap.width, loadedCardBitmap.width), Math.max(bitmap.height, loadedCardBitmap.height));
        }

        cardsLoaded++;

        if (cardsLoaded == cards.length) {
          for (let i = 0; i < cards.length; i++) {
            const cardBitmap = Managers.Images.loadCharacter(cards[i], hue);
            bitmap.bltBitmap(cardBitmap, 0, 0, cardBitmap.width, cardBitmap.height, 0, 0, cardBitmap.width, cardBitmap.height);
          }
          bitmap._loadingState = 'none';
          bitmap._callLoadListeners();
        }
      };

      for (let i = 0; i < cards.length; i++) {
        const cardBitmap = Managers.Images.loadCharacter(cards[i], hue);
        cardBitmap.addLoadListener(loadListenerFn);
      }
    }

    return bitmap;
  }
};

Managers.PaperDolls.paperDolls = {};