Managers.Palletes = class Palletes {
  static registerPalleteCharacter(characterName, baseCharacter, palletesToUse) {
    this.palleteCharacters[characterName] = {
      baseCharacter,
      palletesToUse
    };
  }

  static registerPalletePortrait(characterName, baseCharacter, palletesToUse) {
    this.palletePortraits[characterName] = {
      baseCharacter,
      palletesToUse
    };
  }

  static registerPalletePicture(pictureName, basePicture, palletesToUse) {
    this.palletePictures[pictureName] = {
      basePicture,
      palletesToUse
    };
  }

  static isPalleteBasedCharacter(characterName) {
    return this.palleteCharacters.hasOwnProperty(characterName);
  }

  static isPalleteBasedPortrait(characterName) {
    return this.palletePortraits.hasOwnProperty(characterName);
  }

  static isPalleteBasedPicture(pictureName) {
    return this.palletePictures.hasOwnProperty(pictureName);
  }

  static loadCharacter(characterName, hue) {
    const key = `pallete-${characterName}`;
    let bitmap = Managers.Images.cache.getItem(key);

    if (!bitmap) {
      // If the file exists, load from it directly instead of using the pallete
      if (!Managers.Images.characterIsInvalid(`generated/${characterName}`)) {
        return Managers.Images.loadRegularCharacter(`generated/${characterName}`, hue);
      }

      const palleteData = this.palleteCharacters[characterName];
      if (!palleteData) {
        throw new Error(`Character Pallete Configuration not found: ${characterName}`);
      }

      bitmap = new Bitmap(10, 10);
      bitmap._loadingState = 'waiting';
      Managers.Images.cache.setItem(key, bitmap);

      const baseBitmap = Managers.Images.loadCharacter(palleteData.baseCharacter, hue);
      baseBitmap.addLoadListener(() => {
        bitmap.resize(baseBitmap.width, baseBitmap.height);
        bitmap.bltBitmap(baseBitmap, 0, 0, baseBitmap.width, baseBitmap.height, 0, 0);

        this.applyPalletes(bitmap, palleteData);
      });
    }

    return bitmap;
  }

  static loadPortrait(characterName, hue) {
    const key = `pallete-portrait-${characterName}`;
    let bitmap = Managers.Images.cache.getItem(key);

    if (!bitmap) {
      // If the file exists, load from it directly instead of using the pallete
      if (!Managers.Images.portraitIsInvalid(`generated/${characterName}`)) {
        return Managers.Images.loadRegularPortrait(`generated/${characterName}`, hue);
      }

      const palleteData = this.palletePortraits[characterName];
      if (!palleteData) {
        throw new Error(`Portrait Pallete Configuration not found: ${characterName}`);
      }

      bitmap = new Bitmap(10, 10);
      bitmap._loadingState = 'waiting';
      Managers.Images.cache.setItem(key, bitmap);

      const baseBitmap = Managers.Images.loadPortrait(palleteData.baseCharacter, hue);
      baseBitmap.addLoadListener(() => {
        bitmap.resize(baseBitmap.width, baseBitmap.height);
        bitmap.bltBitmap(baseBitmap, 0, 0, baseBitmap.width, baseBitmap.height, 0, 0);

        this.applyPalletes(bitmap, palleteData);
      });
    }

    return bitmap;
  }

  static loadPicture(pictureName, hue) {
    const key = `pallete-picture-${ pictureName }`;
    let bitmap = Managers.Images.cache.getItem(key);

    if (!bitmap) {
      // If the file exists, load from it directly instead of using the pallete
      if (!Managers.Images.pictureIsInvalid(pictureName)) {
        return Managers.Images.loadRegularPicture(pictureName, hue);
      }

      const palleteData = this.palletePictures[pictureName];
      if (!palleteData) {
        throw new Error(`Picture Pallete Configuration not found: ${ pictureName }`);
      }

      bitmap = new Bitmap(10, 10);
      bitmap._loadingState = 'waiting';
      Managers.Images.cache.setItem(key, bitmap);

      const baseBitmap = Managers.Images.loadPicture(palleteData.basePicture, hue);
      baseBitmap.addLoadListener(() => {
        bitmap.resize(baseBitmap.width, baseBitmap.height);
        bitmap.bltBitmap(baseBitmap, 0, 0, baseBitmap.width, baseBitmap.height, 0, 0);
        this.applyPalletes(bitmap, palleteData);
      });
    }

    return bitmap;
  }

  static findPalleteByName(palleteName) {
    for (const pallete of $dataPalletes) {
      if (!pallete) continue;
      if (pallete.name != palleteName) continue;

      return pallete;
    }

    return false;
  }

  static applyPalletes(bitmap, palleteData, baseBitmap) {
    const colorsToReplace = [];

    for (const newPalleteName of palleteData.palletesToUse) {
      const newPallete = this.findPalleteByName(newPalleteName);

      if (!newPallete) continue;

      for (const key in newPallete.swaps) {
        if (!newPallete.swaps.hasOwnProperty(key)) continue;

        colorsToReplace.push({
          oldColors: Utils.hexToRgb(key),
          newColors: Utils.hexToRgb(newPallete.swaps[key])
        });
      }
    }

    if (colorsToReplace.length > 0) {
      bitmap.replaceColors(colorsToReplace);
    } else {
      bitmap._loadingState = 'none';
      bitmap._callLoadListeners();
    }
  }
};

Managers.Palletes.palleteCharacters = {};
Managers.Palletes.palletePortraits = {};
Managers.Palletes.palletePictures = {};