require('./Extension');

//-----------------------------------------------------------------------------
// Package Manager
//
// The static class that manages the game packages

Managers.Packages = class Packages extends Managers.Extension {
  constructor() {
    throw new Error('This is a static class');
  }

  static getPackagesFolder() {
    const projectFolder = Utils.getProjectFolder();
    return Wrapper.joinFileNames(projectFolder, 'packages');
  }

  static loadPackage(packagePath, packageName) {
    try {
      if (Wrapper.isDirectory(packagePath)) {
        this.loadFolder(packagePath, packageName);
      }
    }
    catch(e){
      console.log(...log(e, `PackageManager.loadPackage [${ packageName }]`));
    }
  }

  static loadFolder(packageFolder, packageName) {
    if (this.loadExtensionFolderContent(packageFolder, packageName, 'package')) {
      return;
    }

    // If no standard folder was found, check if there's any JS file inside
    const fileList = Wrapper.readdirSync(packageFolder);
    let anyJsFile = false;
    let anyFolder = false;

    if (fileList && fileList.length) {
      for (let fileName of fileList) {
        if (!fileName) continue;
        const filePath = Wrapper.joinFileNames(packageFolder, fileName);

        if (Wrapper.isDirectory(filePath)) {
          anyFolder = true;
          continue;
        }

        if (fileName.toLowerCase().endsWith('.js')) {
          anyJsFile = true;
          break;
        }
      }
    }

    // There are unknown folders and NO js file, then treat this as a group of packages
    if (!anyJsFile && anyFolder) {
      for (let fileName of fileList) {
        const filePath = Wrapper.joinFileNames(packageFolder, fileName);
        this.loadPackage(filePath, `${ packageName }/${ fileName }`);
      }
    }
  }

  static autoLoadPackageFiles() {
    const packagesFolder = this.getPackagesFolder();
    const packageList = Wrapper.readdirSync(packagesFolder);

    for (let packageName of packageList) {
      const packagePath = Wrapper.joinFileNames(packagesFolder, packageName);
      this.loadPackage(packagePath, packageName);
    }
  }

  static getPath() {
    return this.getPackagesFolder();
  }
};

