require('./Extension');

//-----------------------------------------------------------------------------
// ModManager
//
// The static class that manages the mods.

Managers.Mods = class Mods extends Managers.Extension {
  static getModList() {
    try {
      const orangePath = Managers.Storage.localFileDirectoryPath(true);
      const pluginPath = Wrapper.joinFileNames(orangePath, 'mods');

      this._path = pluginPath;
    } catch(e) {
      return [];
    }

    if (Wrapper.existsSync(this._path)) {
      const modListPath = Wrapper.joinFileNames(this._path, 'modlist.txt');
      if (Wrapper.existsSync(modListPath)) {
        const modList = Wrapper.readFileSync(modListPath);
        if (!modList) {
          return [];
        }

        return modList.split('\n');
      }

      return Wrapper.readdirSync(this._path);
    }

    return [];
  }

  static loadMod(fileName) {
    if (!fileName) return;

    fileName = fileName.replace('\r', '');

    let filePath = Wrapper.joinFileNames(this._path, fileName);

    if (!Wrapper.existsSync(filePath)) {
      filePath += '.js';
      if (!Wrapper.existsSync(filePath)) {
        console.log(...log(`[ModManager] Mod not found: ${fileName}`));
      }
    }

    window.pluginName = fileName;
    window.pluginPath = filePath;
    window.usedMods = true;

    try {
      if (Wrapper.isDirectory(filePath)) {
        this.loadFolderMod(fileName, filePath);
      } else {
        this.loadFileExtension(fileName, filePath);
      }
    }
    catch(e) {
      console.log(...log(`[ModManager] Failed to load mod: ${fileName}`));
      console.error(e);
    }
  }

  static loadFolderMod(folderName, folderPath) {
    const mainFilePath = Wrapper.joinFileNames(folderPath, 'plugin.js');
    if (Wrapper.existsSync(mainFilePath)) {
      this.loadFileExtension(folderName, mainFilePath, folderName);
    }

    this.loadExtensionFolderContent(folderPath, folderName, 'mod');
  }

  static getPath() {
    return this._path;
  }
};

Managers.Mods._path = false;

window.ModManager = Managers.Mods;