Managers.Mine = class Mine {
  constructor() {
    throw new Error('This is a static class');
  }

  static removeAllTempEvents() {
    if ($gameSystem.hasMapGeneratedDailyEvents($gameMap._mapId)) return;

    Managers.FarmObjects.clearMapObjectsByFilter($gameMap._mapId, farmObject => {
      if (!farmObject) return false;
      
      if (farmObject.state == FarmObjectState.MINING_ROCK) return true;
      if (farmObject.modelName == FarmObjectState.STONE) return true;

      return false;
    });

    return true;
  }

  static processNewDay() {
    const mineFilter = (obj) => {
      if (!obj) return false;

      if (obj.modelName == FarmObjectState.STONE) return true;
      if (obj.state == FarmObjectState.MINING_ROCK) return true;

      if (['rock-2', 'rock-3', 'rock-4'].includes(obj.modelName)) {
        return false;
      }

      return false;
    };

    Managers.FarmObjects.clearMapObjectsByFilter(Maps.MAIN_MINE, mineFilter);
    Managers.FarmObjects.clearMapObjectsByFilter(Maps.MINE_LEVEL_2, mineFilter);

    Managers.FarmObjects.clearMapObjects(Maps.GOLD_MINE);
    Managers.FarmObjects.clearMapObjects(Maps.PATH_TO_RUINS);
    Managers.FarmObjects.clearMapObjects(Maps.TRAIN_STATION_CAVE);

    if (!Switches.gotAnyCrystalToday) {
      Variables.blueCrystalDropRate += 30;
      Variables.bigBlueCrystalDropRate += 20;
    }

    Switches.gotAnyCrystalToday = false;
  }
};


