Managers.Mailbox = class Mailbox {
  constructor() {
    throw new Error('This is a static class');
  }

  static clear() {
    this.receivedMail = [];
  }

  static getData() {
    return {
      receivedMail : this.receivedMail
    };
  }

  static setData(newData) {
    this.clear();
    if (!newData) return;

    if (newData.receivedMail) {
      this.receivedMail = newData.receivedMail;
    }
  }

  static checkMailbox() {
    Managers.CommonEvent.playEvent('check_mailbox');
  }

  static readMail() {
    const letters = this.getLetterList();
    if (letters.length > 0) {
      const eventName = letters.shift();
      if (Managers.CommonEvent.eventExists(eventName)) {
        Managers.CommonEvent.playEvent(eventName);
      } else {
        Managers.CommonEvent.playEvent('mailbox_spam');
      }
      return;
    }

    Managers.CommonEvent.playEvent('mailbox_empty');
  }

  static getLetterList() {
    return this.receivedMail;
  }

  static mailCount() {
    return this.receivedMail.length;
  }

  static updateMailboxSwitch() {
    Switches.newMail = this.mailCount() > 0;
  }

  static _checkConditionTasks(tasks) {
    if (tasks['not-started']) {
      if (!Managers.Tasks.tasksAndStatusesMatch(tasks['not-started'], [TaskStatus.NONE])) {
        return false;
      }
    }

    if (tasks.completed) {
      if (!Managers.Tasks.tasksAndStatusesMatch(tasks.completed, [TaskStatus.COMPLETED])) {
        return false;
      }
    }

    if (tasks['completed>week']) {
      const listedTasks = tasks['completed>week'];
      if (!Managers.Tasks.tasksAndStatusesMatch(listedTasks, [TaskStatus.COMPLETED])) {
        return false;
      }

      for (const taskId of listedTasks) {
        if (Managers.History.daysSinceEvent(`completed-task-${taskId}`) < 7) {
          return false;
        }
      }
    }

    return true;
  }

  static _checkConditionCutscenes(cutscenes) {
    if (cutscenes['not-played']) {
      for (const cutsceneId of cutscenes['not-played']) {
        if (Managers.History.daysSinceCutscene(cutsceneId) !== false) {
          return false;
        }
      }
    }

    if (cutscenes.played) {
      for (const cutsceneId of cutscenes['not-played']) {
        if (Managers.History.daysSinceCutscene(cutsceneId) === false) {
          return false;
        }
      }
    }

    if (cutscenes['played>week']) {
      for (const cutsceneId of cutscenes['not-played']) {
        const days = Managers.History.daysSinceCutscene(cutsceneId);
        if (!days || days < 7) {
          return false;
        }
      }
    }

    return true;
  }

  static validateConditionList(conditions, ignoreTimeConditions = true) {
    if (!conditions) {
      return true;
    }

    if (conditions.exactYearDate && conditions.exactYearDate != Managers.Time.yearDay) {
      return false;
    }

    if (conditions.minDays && conditions.minDays > Managers.Time.totalDays) {
      return false;
    }

    if (conditions.minYearDate && conditions.minYearDate > Managers.Time.yearDay) {
      return false;
    }

    if (conditions.maxYearDate && conditions.maxYearDate < Managers.Time.yearDay) {
      return false;
    }

    if (!ignoreTimeConditions) {
      if (conditions.minHour && conditions.minHour > Managers.Time.hour) {
        return false;
      }

      if (conditions.maxHour && conditions.maxHour < Managers.Time.hour) {
        return false;
      }

      if (conditions.minTime && !Managers.Time.isBetweenTimes(conditions.minTime, '23:59')) {
        return false;
      }

      if (conditions.maxTime && !Managers.Time.isBetweenTimes('00:00', conditions.maxTime)) {
        return false;
      }
    }

    if (conditions.knownCharacters) {
      for (let c = 0; c < conditions.knownCharacters.length; c++) {
        if (!Managers.Relationship.isCharacterKnown(conditions.knownCharacters[c])) {
          return false;
        }
      }
    }

    if (conditions.tasks) {
      if (!this._checkConditionTasks(conditions.tasks)) {
        return false;
      }
    }

    if (conditions.cutscenes) {
      if (!this._checkConditionCutscenes(conditions.cutscenes)) {
        return false;
      }
    }

    if (conditions['space-for-items']) {
      for (const itemId of conditions['space-for-items']) {
        if (!Managers.Items.canGainItemId(itemId)) {
          return false;
        }
      }
    }

    if (conditions.switches) {
      for (const switchId of conditions.switches) {
        if (!Switches[switchId]) {
          return false;
        }
      }
    }

    if (conditions['off-switches']) {
      for (const nSwitchId of conditions['off-switches']) {
        if (Switches[nSwitchId]) {
          return false;
        }
      }
    }

    if (conditions.script) {
      if (!MVC.safeEval(conditions.script)) {
        return false;
      }
    }

    return true;
  }

  static validateLetterConditions(letterData) {
    if (!letterData) return false;

    const conditions = letterData.conditions;

    return this.validateConditionList(conditions);
  }

  static processNewDay() {
    const mail = Managers.Content.getLetterList();
    for (let i = 0; i < mail.length; i++) {
      if (!this.receivedMail.includes(mail[i])) {
        this.receivedMail.push(mail[i]);
      }
    }

    if ($dataLetters) {
      for (const letterId in $dataLetters) {
        if (!this.receivedMail.includes(letterId)) {
          if (this.validateLetterConditions($dataLetters[letterId])) {
            this.receivedMail.push(letterId);
          }
        }
      }
    }
  }
};

Managers.Mailbox.clear();