Managers.Festivals = class Festivals {
  constructor() {
    throw new Error('This is a static class');
  }

  static registerFestival(festivalId, yearDay, contentClass, switchName, iconIndex, festivalName) {
    this.festivalList[festivalId] = {
      festivalId,
      yearDay,
      contentClass,
      switchName,
      iconIndex,
      festivalName
    };
  }

  static loopFestivals(callback) {
    for (const festivalId in this.festivalList) {
      if (!this.festivalList.hasOwnProperty(festivalId)) continue;

      const data = this.festivalList[festivalId];
      if (!data) continue;
      
      const result = callback.call(this, data);
      if (result !== undefined) return result;
    }
  }

  static getNextFestival(yearDay) {
    yearDay = yearDay || Managers.Time.yearDay;

    let firstFestivalId;
    let firstFestivalYearDay = Infinity;
    let nextFestivalId;
    let nextFestivalYearDay = Infinity;

    for (const festivalId in this.festivalList) {
      if (!this.festivalList.hasOwnProperty(festivalId)) continue;

      const data = this.festivalList[festivalId];
      if (!data) continue;

      if (data.yearDay < firstFestivalYearDay) {
        firstFestivalYearDay = data.yearDay;
        firstFestivalId = festivalId;
      }

      if (data.yearDay < nextFestivalYearDay && data.yearDay >= yearDay) {
        nextFestivalYearDay = data.yearDay;
        nextFestivalId = festivalId;
      }
    }

    // There are no festivals registered, apparently.
    if (!firstFestivalId) {
      return false;
    }

    if (!nextFestivalId) {
      nextFestivalId = firstFestivalId;
    }

    return this.festivalList[nextFestivalId];
  }

  static hasFestivalTomorrow() {
    const yearDay = Managers.Time.yearDay + 1;

    return this.loopFestivals(data => {
      if (data.yearDay != yearDay) return;

      return true;
    }) || false;
  }

  static clearSwitches() {
    Switches.isFestival = false;
    this.loopFestivals(data => {
      if (data.switchName) {
        Switches[data.switchName] = false;
      }
    });
  }

  static updateSwitches() {
    let yearDay = Managers.Time.yearDay;
    if (Managers.Time.hour < 6) {
      yearDay--;
    }

    this.loopFestivals(data => {
      if (data.switchName) {
        Switches[data.switchName] = data.yearDay == yearDay;
      }
      if (data.yearDay == yearDay) {
        Switches.isFestival = true;
      }
    });
  }

  static startFestivalDay() {
    const yearDay = Managers.Time.yearDay;

    this.loopFestivals(data => {
      if (data.yearDay == yearDay) {
        if (data.contentClass && data.contentClass.startDay) {
          data.contentClass.startDay();
        }
      }
    });
  }

  static updateFestival() {
    const yearDay = Managers.Time.yearDay;

    this.loopFestivals(data => {
      if (data.yearDay == yearDay) {
        if (data.contentClass && data.contentClass.update) {
          data.contentClass.update();
        }
      }
    });
  }

  static getMonthFestivalIcons(month) {
    if (month === undefined) month = Managers.Time.month;
    const festivals = {};

    const minDay = ((month - 1) * Managers.Time.monthLength) + 1;
    const maxDay = minDay + Managers.Time.monthLength - 1;
    this.loopFestivals(data => {
      if (data.yearDay < minDay) return;
      if (data.yearDay > maxDay) return;

      festivals[data.yearDay - minDay + 1] = data.iconIndex;
    });

    return festivals;
  }

  static onChangeDay() {
    if (Switches.isInsideFestival) return;

    Switches.isFestival = false;
    this.prepareThingsForPossibleFestival();
  }

  static prepareThingsForPossibleFestival() {
    if (Switches.isFestival) return;
    
    this.clearSwitches();
    this.updateSwitches();

    if (Switches.isFestival) {
      Switches.isFestivalEnding = false;
      Switches.isInsideFestival = false;
      Switches.isInsideFestivalCompetition = false;
    }
  }

  static onChangeMinute() {
    if (Switches.isFestival) return;

    this.prepareThingsForPossibleFestival();

    if (Switches.isFestival) {
      this.startFestivalDay();
    }
  }

  static processNewDay() {
    Switches.isFestival = false;
    this.prepareThingsForPossibleFestival();

    if ($gameMap._mapId === Maps.FESTIVAL_RECEPTION) {
      $gamePlayer.goHome();
    }

    if (Switches.isFestival) {
      Managers.Weather.currentWeather = WeatherType.SUN;
      this.startFestivalDay();
    }
  }

  static isFestivalPrepared() {
    if (!Switches.isFestival) return false;

    const yearDay = Managers.Time.yearDay;

    return this.loopFestivals(data => {
      if (data.yearDay == yearDay) {
        if (data.contentClass && data.contentClass.isFestivalPrepared) {
          return data.contentClass.isFestivalPrepared();
        }
      }
    }) || false;
  }

  static teleportToFestival() {
    $gameSystem.resetMap(Maps.FESTIVAL_RECEPTION, true);

    $gamePlayer.reserveTransfer(Maps.FESTIVAL_RECEPTION, 19, 33, Direction.UP, 0, false, false);
  }

  static enterFestival() {
    Switches.isInsideFestival = true;
    Switches.boughtFestivalAnimal = false;

    if ($gamePlayer.isRiding()) {
      const animalId = $gamePlayer._animalId;
      const animalData = Managers.Creatures.getCreatureById(animalId);

      if (animalData) {
        Managers.Creatures.moveAnimal(animalData, animalData.homeMapId, animalData.homeX, animalData.homeY, Direction.DOWN);
      }

      $gamePlayer.clearRideData();
    }

    if (Managers.Time.hour < 10) {
      Managers.Time.hour = 10;
      Managers.Time.minute = 0;
      Managers.Time.seconds = 0;

      Managers.Time.updateTime();
    }
    
    $gameMap.autoplay();
  }

  static leftFestival() {
    Switches.isInsideFestival = false;
    Switches.isFestivalEnding = false;

    if (Managers.Time.hour < 18) {
      Managers.Time.hour = 18;
      Managers.Time.minute = 0;
      Managers.Time.seconds = 0;
      Managers.Time.updateTime();
    }

    $gameMap.autoplay();
  }

  static update() {
    this.updateFestival();
  }

  static leaveUnpreparedFestivalArea() {
    if ($gameTemp.isCommonEventReserved()) return;
    if ($gameMap._interpreter.isRunning()) return;

    Managers.CommonEvent.playEvent('festival_not_ready');
  }
};

Managers.Festivals.festivalList = {};

Managers.Time.on('changeDay', Managers.Festivals.onChangeDay.bind(Managers.Festivals));
Managers.Time.on('changeMinute', Managers.Festivals.onChangeMinute.bind(Managers.Festivals));