Managers.Cooking = class Cooking {
  constructor() {
    throw new Error('This is a static class');
  }

  static clear() {
    this.lastRecipe = null;
    this.recipesLearnt = [];
    this.learnedNewRecipe = false;
  }

  static isValidUtensil(utensil) {
    if (!utensil) {
      return true;
    }

    switch(utensil) {
      case 'kitchen-knife':
        return Switches.hasKitchenKnife;
      case 'kitchen-pot':
        return Switches.hasKitchenPot;
      case 'kitchen-pan':
        return Switches.hasKitchenPan;
      case 'kitchen-oven':
        return Switches.hasKitchenOven;
      case 'kitchen-mixer':
        return Switches.hasKitchenMixer;
      case 'kitchen-blender':
        return Switches.hasKitchenBlender;
    }

    return false;
  }

  static playerHasAllIngredients(ingredients) {
    for (let itemId of ingredients) {
      if (Managers.Items.numItemsById(itemId) > 0) {
        continue;
      }

      if (Managers.Items.storageContainer.numItemsById(itemId) > 0) {
        continue;
      }

      return false;
    }

    return true;
  }

  static findRecipeForItems(utensil, ingredients, onlyKnown) {
    for (let i = 0; i < $dataRecipes.length; i++) {
      const recipe = $dataRecipes[i];

      // If the player chose an utensil, compare it to the recipe
      if (utensil) {
        if (recipe.utensil != utensil) continue;
      } else {
        //If the player is not using any utensil, then discard any recipe that needs one
        if (recipe.utensil) continue;
      }

      //If the ingredient count doesn't match, skip it already
      if (recipe.ingredients.length != ingredients.length) continue;

      let itemsMatched = 0;
      for (var j = 0; j < ingredients.length; j++) {
        if (recipe.ingredients.indexOf(ingredients[j]) < 0) break;

        itemsMatched++;
      }

      if (ingredients.length == itemsMatched) {
        if (onlyKnown && !this.recipesLearnt.includes(recipe.id)) {
          return false;
        }

        return recipe;
      }
    }

    return false;
  }

  static cookWithItems(utensil, ingredients) {
    this.lastRecipe = null;
    this.learnedNewRecipe = false;

    if (!ingredients.length) {
      throw new Error('no-ingredients');
    }

    // Before anything, let's check if the player has everything

    if (!this.isValidUtensil(utensil)) {
      throw new Error('no-utensil');
    }
    if (!this.playerHasAllIngredients(ingredients)) {
      throw new Error('insuficient-ingredients');
    }

    const recipe = this.findRecipeForItems(utensil, ingredients);

    // Spend all the items 
    for (let itemId of ingredients) {
      if (Managers.Items.numItemsById(itemId) > 0) {
        Managers.Items.loseItemId(itemId, 1);
      } else if (Managers.Items.storageContainer.numItemsById(itemId) > 0) {
        Managers.Items.storageContainer.loseItemId(itemId, 1);
      }
    }

    if (recipe) {
      this.lastRecipe = recipe;
      this.registerLearntRecipe(recipe.id);

      let newExp = 10 * ingredients.length;
      if (this.learnedNewRecipe) {
        // Managers.Health.increaseFatigue(10);
        newExp *= 2;
      } else {
        // Managers.Health.increaseFatigue(5);
      }

      Managers.Player.cookingExp += newExp;
      $gameTemp.reserveCutscene('cook_success');
      return true;
    } else {
      Managers.Player.cookingExp += 2;
      // Managers.Health.increaseFatigue(3);
      $gameTemp.reserveCutscene('cook_failure');
      return false;
    }
  }

  static getSortedLearntRecipes() {
    const ids = this.recipesLearnt || [];
    const recipes = [];

    for (let recipe of ($dataRecipes || [])) {
      if (ids.indexOf(recipe.id) >= 0) {
        recipes.push(recipe.id);
      }
    }

    return recipes;
  }

  static registerLearntRecipe(recipeId) {
    if (this.recipesLearnt.indexOf(recipeId) >= 0) return;

    this.recipesLearnt.push(recipeId);
    Managers.History.registerItem('recipe', recipeId);

    this.learnedNewRecipe = true;
  }

  static getRecipeData(recipeId) {
    for (var i = 0; i < $dataRecipes.length; i++) {
      if (!$dataRecipes[i]) continue;
      if ($dataRecipes[i].id == recipeId) {
        return $dataRecipes[i];
      }
    }

    return null;
  }

  static getRecipeStatistics() {
    const itemsWithRecipes = [];
    const itemsMade = [];

    for (let r = 0; r < $dataRecipes.length; r++) {
      if (!$dataRecipes[r]) continue;

      if (itemsWithRecipes.indexOf($dataRecipes[r].itemId) < 0) {
        itemsWithRecipes.push($dataRecipes[r].itemId);
      }
    }

    for (let i = 0; i < Managers.Cooking.recipesLearnt.length; i++) {
      let recipeId = Managers.Cooking.recipesLearnt[i];
      if (!recipeId) continue;

      let recipeData = Managers.Cooking.getRecipeData(recipeId);
      if (!recipeData) continue;

      if (itemsMade.indexOf(recipeData.itemId) < 0) {
        itemsMade.push(recipeData.itemId);
      }
    }

    return [itemsMade, itemsWithRecipes];
  }

  static getData() {
    return {
      recipesLearnt: Managers.Cooking.recipesLearnt
    };
  }

  static setData(data) {
    this.clear();

    if (!data) {
      return;
    }

    if (data.recipesLearnt) {
      Managers.Cooking.recipesLearnt = data.recipesLearnt;
    }
  }
};

Managers.Cooking.lastRecipe = null;
Managers.Cooking.learnedNewRecipe = false;
Managers.Cooking.recipesLearnt = [];
