Managers.Achievements = class Achievements {
  static activate(id) {
    return Managers.Steam.activateAchievement(id);
  }

  static registerActiveAchievement(id) {
    if (Managers.Achievements.activatedAchievements.includes(id)) return;

    Managers.Achievements.activatedAchievements.push(id);
    if ($gamePlayer) {
      $gamePlayer.requestBalloon(Balloons.SECRET);
    }
  }

  static getData() {
    return {
      active : Managers.Achievements.activatedAchievements
    };
  }

  static setData(achievementsData) {
    if (!achievementsData) return;

    if (achievementsData.active) {
      Managers.Achievements.activatedAchievements = achievementsData.active;
    }
  }

  static isAchievementPending(id) {
    if (Managers.Achievements.activatedAchievements.includes(id)) {
      return false;
    }

    return true;
  }

  static getAchievementList() {
    const achievements = [];
    let delay = 0;

    for (const achiev of $dataAchievements) {
      // If the achievement has no iconIndex set, it's because it is still pending
      if (achiev.iconIndex === 0) continue;

      const newData = {};
      newData.id = achiev.id;
      newData.iconIndex = achiev.iconIndex;

      newData.achieved = this.isAchievementRequirementsMet(achiev.id);
      newData.pending = this.isAchievementPending(achiev.id);

      if (newData.achieved && newData.pending) {
        delay += 1000;
        setTimeout(Managers.Steam.activateAchievement.bind(Managers.Steam, newData.id), delay);
      }

      if (!newData.achieved && achiev.hidden) {
        continue;
      }

      achievements.push(newData);
    }

    while (achievements.length < $dataAchievements.length) {
      achievements.push({
        id : 'hidden',
        iconIndex : 0,
        achieved : false,
        pending : true
      });
    }

    return achievements;
  }

  static isStampEnabled(stampId) {
    if (stampId == 'progress') {
      const lines = Managers.Content.getCustomDatabaseSummaryLines();
      const rate = Engine.Data.calculateGameCompletionRate(lines);
      return rate == 100;
    }

    return Managers.Content.isStampEnabled(stampId);
  }

  static getStampValue(stampId) {
    if (stampId == 'progress') {
      const lines = Managers.Content.getCustomDatabaseSummaryLines();
      const rate = Engine.Data.calculateGameCompletionRate(lines);
      return `${ rate }%`;
    }

    return Managers.Content.getStampValue(stampId);
  }

  static getMaxStampValue(stampId) {
    switch(stampId) {
      case 'progress':
        return false;
      case 'moneyEarned':
        return false;
      case 'moneySpent':
        return false;
      default:
        return Managers.Content.getMaxStampValue(stampId);
    }
  }

  static isAchievementRequirementsMet(id) {
    switch(id) {
      case 'FIRST_DATE' :
        // datingDevin .. datingAnnie
        for (let idx = 302; idx <= 311; idx++) {
          if ($gameSwitches.value(idx)) {
            return true;
          }
        }

        return false;
      case 'SHIP_EVERYTHING' :
        return false;
      case 'GET_IRON_SICKLE' :
        return Switches.hasIronSickle;
      case 'GET_IRON_HAMMER' :
        return Switches.hasIronHammer;
      case 'GET_IRON_AXE' :
        return Switches.hasIronAxe;
      case 'GET_FISHING_ROD' :
        return Switches.hasFishingRod;
      case 'FISH_1000' :
        return Managers.History.readTotal('fish-caught') >= 1000;
      case 'FISH_10000' :
        return Managers.History.readTotal('fish-caught') >= 10000;
      case 'EARN_GOLD_1' :
        return Variables.moneyEarned >= 10000;
      case 'EARN_GOLD_2' :
        return Variables.moneyEarned >= 100000;
      case 'EARN_GOLD_3' :
        return Variables.moneyEarned >= 1000000;
      case 'HARVEST_1' :
        return Variables.cropsHarvested >= 1;
      case 'HARVEST_100' :
        return Variables.cropsHarvested >= 100;
      case 'HARVEST_1000' :
        return Variables.cropsHarvested >= 1000;
      case 'HARVEST_10000' :
        return Variables.cropsHarvested >= 10000;
      case 'HARVEST_100000' :
        return Variables.cropsHarvested >= 100000;
      case 'SHIP_EVERY_CROP' :
        return false;
      case 'SHIP_EVERY_CROP_50' :
        return false;
      case 'SHIP_EVERY_CROP_500' :
        return false;
      case 'REACH_SUMMER' :
        return Managers.Time.month >= 2 || Managers.Time.year > 1;
      case 'REACH_FALL' :
        return Managers.Time.month >= 3 || Managers.Time.year > 1;
      case 'REACH_WINTER' :
        return Managers.Time.month >= 4 || Managers.Time.year > 1;
      case 'REACH_YEAR_2' :
        return Managers.Time.year > 1;
      case 'FIND_GOLDEN_ORANGES' :
        return false;
      case 'COMPLETE_TASK' :
        return Managers.Tasks.countTaskStatus(TaskStatus.COMPLETED) > 0;
      case 'COMPLETE_50_TASKS' :
        return Managers.Tasks.countTaskStatus(TaskStatus.COMPLETED) >= 50;
      case 'COMPLETE_100_TASKS' :
        return Managers.Tasks.countTaskStatus(TaskStatus.COMPLETED) >= 100;
      case 'GET_A_ROOSTER' :
        return Managers.Creatures.hasAnyCreatureOfRace('rooster');
    }
  }

  static checkAchievements() {
    let delay = 0;

    for (const achiev of $dataAchievements) {
      if (this.isAchievementPending(achiev.id)) {
        if (this.isAchievementRequirementsMet(achiev.id)) {
          delay += 1000;
          setTimeout(Managers.Steam.activateAchievement.bind(Managers.Steam, achiev.id), delay);
        }
      }
    }

    // if (this.isAchievementPending(Achievements.GET_A_ROOSTER)) {
    //   if (Managers.Creatures.hasAnyCreatureOfRace('rooster')) {
    //     Managers.Steam.activateAchievement(Achievements.GET_A_ROOSTER);
    //   }
    // }

    // if (this.isAchievementPending(Achievements.GET_IRON_HAMMER)) {
    //   if (Switches.hasIronHammer) {
    //     Managers.Steam.activateAchievement(Achievements.GET_IRON_HAMMER);
    //   }
    // }

    // if (this.isAchievementPending(Achievements.GET_IRON_SICKLE)) {
    //   if (Switches.hasIronSickle) {
    //     Managers.Steam.activateAchievement(Achievements.GET_IRON_SICKLE);
    //   }
    // }

    // if (this.isAchievementPending)
    // if (Switches.hasIronAxe) {
    //   Managers.Steam.activateAchievement(Achievements.GET_IRON_AXE);
    // }

    // if (Switches.hasFishingRod) {
    //   Managers.Steam.activateAchievement(Achievements.GET_FISHING_ROD);
    // }

    // if (Variables.moneyEarned >= 10000) {
    //   Managers.Steam.activateAchievement(Achievements.EARN_GOLD_1);

    //   if (Variables.moneyEarned >= 100000) {
    //     Managers.Steam.activateAchievement(Achievements.EARN_GOLD_2);

    //     if (Variables.moneyEarned >= 1000000) {
    //       Managers.Steam.activateAchievement(Achievements.EARN_GOLD_3);
    //     }
    //   }
    // }

    // this.checkCropsHarvestedAchievements();

    // if (Managers.Time.month >= 2 || Managers.Time.year > 1) {
    //   Managers.Steam.activateAchievement(Achievements.REACH_SUMMER);

    //   if (Managers.Time.month >= 3 || Managers.Time.year > 1) {
    //     Managers.Steam.activateAchievement(Achievements.REACH_FALL);

    //     if (Managers.Time.month >= 4 || Managers.Time.year > 1) {
    //       Managers.Steam.activateAchievement(Achievements.REACH_WINTER);

    //       if (Managers.Time.year > 1) {
    //         Managers.Steam.activateAchievement(Achievements.REACH_YEAR_2);
    //       }
    //     }
    //   }
    // }

    // var tasksCompleted = Managers.Tasks.countTaskStatus(TaskStatus.COMPLETED);
    // if (tasksCompleted > 0) {
    //   Managers.Steam.activateAchievement(Achievements.COMPLETE_TASK);

    //   if (tasksCompleted >= 50) {
    //     Managers.Steam.activateAchievement(Achievements.COMPLETE_50_TASKS);

    //     if (tasksCompleted >= 100) {
    //       Managers.Steam.activateAchievement(Achievements.COMPLETE_100_TASKS);
    //     }
    //   }
    // }
  }

  // Managers.Achievements.checkCropsHarvestedAchievements = function() {
  //   if (Variables.cropsHarvested >= 1) {
  //     Managers.Steam.activateAchievement(Achievements.HARVEST_1);

  //     if (Variables.cropsHarvested >= 100) {
  //       Managers.Steam.activateAchievement(Achievements.HARVEST_100);
  //       if (Variables.cropsHarvested >= 1000) {
  //         Managers.Steam.activateAchievement(Achievements.HARVEST_1000);
  //         if (Variables.cropsHarvested >= 10000) {
  //           Managers.Steam.activateAchievement(Achievements.HARVEST_10000);
  //           if (Variables.cropsHarvested >= 100000) {
  //             Managers.Steam.activateAchievement(Achievements.HARVEST_100000);
  //           }
  //         }
  //       }
  //     }
  //   }
  // };
};

// new achievement ideas:
// farm-acist - use medicines
// more than meets the sty - for pig related achievements


Managers.Achievements.activatedAchievements = [];
