var DirectionHelper = {};

window.down = 2;
window.left = 4;
window.right = 6;
window.up = 8;

(function($){
  $.directionList = [2, 4, 8, 6];
  $.directionNames = ['down', 'left', 'up', 'right'];

  $.directionIndex = function(direction) {
    return $.directionList.indexOf(direction);
  };

  $.getDirectionName = function(direction) {
    const idx = $.directionList.indexOf(direction);
    if (idx >= 0) {
      return $.directionNames[idx];
    }

    return false;
  };

  $.getDirectionByName = function(directionName) {
    var lower = directionName.toLowerCase();
    var idx = $.directionNames.indexOf(lower);

    if (idx >= 0) {
      return $.directionList[idx];
    }

    return 0;
  };

  $.parseDirection = function(directionToParse, defaultDirection) {
    let direction = directionToParse;

    if (typeof direction == 'string') {
      // "remove" is a valid direction when settting a target destination
      if (direction.toLowerCase() === 'remove') {
        return 'remove';
      }

      var newD = $.getDirectionByName(direction);
      if (newD > 0) return newD;

      direction = parseInt(direction, 10);
    }

    if ($.directionList.indexOf(direction) >= 0) {
      return direction;
    }

    return defaultDirection || 0;
  };

  $.getDirection = function(index) {
    return $.directionList[(index + 4) % 4];
  };

  $.leftSide = function(direction) {
    return $.getDirection($.directionIndex(direction) - 1);
  };

  $.rightSide = function(direction) {
    return $.getDirection($.directionIndex(direction) + 1);
  };

  $.backSide = function(direction) {
    return $.getDirection($.directionIndex(direction) + 2);
  };

  $.goesUp = function(d) {
    return [7, 8, 9].indexOf(d) >= 0;
  };

  $.goesDown = function(d) {
    return [1, 2, 3].indexOf(d) >= 0;
  };

  $.goesLeft = function(d) {
    return [1, 4, 7].indexOf(d) >= 0;
  };

  $.goesRight = function(d) {
    return [3, 6, 9].indexOf(d) >= 0;
  };

  $.isDiagonal = function(direction) {
    return direction !== Direction.UP && direction !== Direction.DOWN && direction !== Direction.LEFT && direction !== Direction.RIGHT;
  };

  $.joinDirections = function(dir1, dir2) {
    if (dir1 == Direction.UP || dir2 == Direction.UP) {
      if (dir1 == Direction.LEFT || dir2 == Direction.LEFT) {
        return Direction.UP_LEFT;
      } else if (dir1 == Direction.RIGHT || dir2 == Direction.RIGHT) {
        return Direction.UP_RIGHT;
      }
    } else if (dir1 == Direction.DOWN || dir2 == Direction.DOWN) {
      if (dir1 == Direction.LEFT || dir2 == Direction.LEFT) {
        return Direction.DOWN_LEFT;
      } else if (dir1 == Direction.RIGHT || dir2 == Direction.RIGHT) {
        return Direction.DOWN_RIGHT;
      }
    }

    if (dir1 >= 1 && dir1 <= 9 && dir1 != 5) {
      return dir1;
    } else {
      return dir2;
    }
  };

  $.getButtonName = function(direction, defaultValue) {
    switch (direction) {
      case Direction.UP:
        return 'up';
      case Direction.DOWN:
        return 'down';
      case Direction.LEFT:
        return 'left';
      case Direction.RIGHT:
        return 'right';
      default:
        break;
    }

    if (defaultValue === undefined) {
      defaultValue = '';
    }

    return defaultValue;
  };
})(DirectionHelper);