require('./Animal');

Creatures.MilkAnimal = MVC.deepClone(Creatures.Animal);

(function($){
  $.processCreatureNewDay = function(creature) {
    if (creature.mapId === Maps.ANIMAL_CAMP) {
      creature.milked = creature.hasMilk;
      creature.hasMilk = false;

      creature.upsetLevel -= 1;
      this.reduceStress(creature);
      return;
    }

    creature.milked = false;
    creature.hasMilk = false;

    if (!BarnMap.consumeAnimalFoodInMap(creature.mapId)) {
      if (!Managers.Map.mapIsFarm(creature.mapId)) {
        creature.upsetLevel += 1;
        creature.hasMilk = false;
        return;
      }

      if (Managers.Weather.isBadWeather() || Managers.Weather.wasBadWeather()) {
        creature.upsetLevel += 2;
        creature.hasMilk = false;
        return;
      }

      // additional upset level reduced when staying outside on good weather
      creature.upsetLevel -= 0.5;
    }

    creature.hasMilk = creature.upsetLevel <= 0;
    this.reduceStress(creature);
    if (creature.upsetLevel > 10) {
      creature.upsetLevel = 10;
    }
  };

  $.getMilkItemId = function() {
    return 'milk';
  };
})(Creatures.MilkAnimal);