Creatures.CreatureType = {};

(function($){
  $.name = '';
  $.creatureKindName = 'unknown';
  $.creatureKindEnabled = false;

  $._spriteName = '';
  $._spriteIndex = 0;
  $._direction = 2;
  $._pattern = 0;
  $._priority = 0;

  $._hitboxX = 0;
  $._hitboxY = 0;
  $._hitboxWidth = 32;
  $._hitboxHeight = 32;

  $._offsetX = 0;
  $._offsetY = 0;

  $._onePerMap = false;

  $.getSpriteName = function(creature) {
    return this._spriteName;
  };

  $.getSpriteIndex = function(creature) {
    return this._spriteIndex;
  };

  $.getHitbox = function(creature) {
    return {
      hitboxX : this._hitboxX,
      hitboxY : this._hitboxY,
      hitboxWidth : this._hitboxWidth,
      hitboxHeight : this._hitboxHeight
    };
  };

  $.getOffset = function(creature) {
    return {
      x : this._offsetX,
      y : this._offsetY
    };
  };

  $.getDirection = function(creature) {
    return creature.d || this._direction;
  };

  $.getPattern = function(creature) {
    return this._pattern;
  };

  $.getPriority = function(creature) {
    return this._priority;
  };

  $.isOnePerMap = function() {
    return this._onePerMap;
  };

  $.processCreatureNewDay = function(creature) {
  };

  $.processLateNewDay = function(creature) {
  };
})(Creatures.CreatureType);