var Variables = {
  addVariable : function(name, variableId) {
    this['_' + name] = variableId;

    MVC.accessor(Variables, name, function(value) {
      if ($gameVariables !== undefined && $gameVariables !== null) {
        $gameVariables.setValue(variableId, value);
      }
    }, function(){
      if ($gameVariables !== undefined && $gameVariables !== null) {
        return $gameVariables.value(variableId);
      } else {
        return false;
      }
    });
  },

  reset : function() {
    $gameVariables.reset();
    this.deleteCustomVariables();
    
    this.hour = 0;
    this.minute = 0;
    this.day = 0;
    this.month = 0;
    this.year = 0;
  },

  deleteCustomVariables: function() {
    var customVariables = this.getCustomVariables();
    for (var key in customVariables) {
      if (!this.hasOwnProperty(key)) continue;
      delete this[key];
    }
  },

  getCustomVariables: function() {
    var customVariables = {};

    for (var key in this) {
      if (!this.hasOwnProperty(key)) continue;
      if (typeof this[key] == "function") continue;
      if (key.substring(0, 1) == '_') {
        if (this.hasOwnProperty(key.substring(1))) continue;
      } else {
        if (this.hasOwnProperty('_' + key)) continue;
      }

      customVariables[key] = this[key];
    }

    return customVariables;
  },

  setCustomVariables: function(customVariables) {
    for (var key in customVariables) {
      if (!customVariables.hasOwnProperty(key)) continue;

      this[key] = customVariables[key];
    }
  }
};

Variables.addVariable('hour', 1);
Variables.addVariable('minute', 2);
Variables.addVariable('day', 3);
Variables.addVariable('month', 4);
Variables.addVariable('year', 5);
Variables.addVariable('itemName', 6);

Variables.addVariable('lastChickenFestivalPosition', 14);
Variables.addVariable('chickenRaceVictories', 15);
Variables.addVariable('lucasItemsRejected', 16);

Variables.addVariable('cropsHarvested', 25);
Variables.addVariable('moneyEarned', 26);
Variables.addVariable('moneySpent', 27);

Variables.addVariable('animalFriendship', 28);
Variables.addVariable('itemsShipped', 29);

Variables.addVariable('roosterIndex', 30);

Variables.addVariable('chickenName', 31);
Variables.addVariable('chickenPrice', 35);

Variables.addVariable('animalName', 36);
Variables.addVariable('itemDescription', 37);

Variables.addVariable('timesScaredDogRan', 38);
Variables.addVariable('daysRaphaelWorked', 39);
Variables.addVariable('blueCrystalsMined', 40);
Variables.addVariable('clockHour', 41);
Variables.addVariable('sprinklersMade', 42);

Variables.addVariable('viktorTerribleGiftItemId', 43);
Variables.addVariable('viktorTerribleGiftItemName', 44);
Variables.addVariable('viktorTerribleGiftReward', 45);

Variables.addVariable('autoTaskCount', 46);
Variables.addVariable('autoTaskRequester', 47);

Variables.addVariable('phiWeirdTreeItemId', 48);
Variables.addVariable('phiWeirdTreeItemName', 49);
Variables.addVariable('phiWeirdTreeReward', 50);

Variables.addVariable('bonnieTreatmentItemName', 51);
Variables.addVariable('bonnieTreatmentItemId', 52);
Variables.addVariable('bonnieTreatmentReward', 53);

Variables.addVariable('benjaminFertilizerItemName', 54);
Variables.addVariable('benjaminFertilizerItemId', 55);
Variables.addVariable('benjaminFertilizerReward', 56);

Variables.addVariable('chloeSaciDefenseItemName', 57);
Variables.addVariable('chloeSaciDefenseItemId', 58);
Variables.addVariable('chloeSaciDefenseReward', 59);

Variables.addVariable('devinBrokenFurnitureItemId', 60);
Variables.addVariable('devinBrokenFurnitureItemName', 61);
Variables.addVariable('devinBrokenFurnitureReward', 62);


Variables.addVariable('monkey1Id', 63);
Variables.addVariable('bunny1Id', 64);
Variables.addVariable('dog1Id', 65);
Variables.addVariable('turtle1Id', 66);
Variables.addVariable('turtle2Id', 67);
Variables.addVariable('turtle3Id', 68);
Variables.addVariable('cat1Id', 69);
Variables.addVariable('cat2Id', 70);
Variables.addVariable('cat3Id', 71);
Variables.addVariable('cat4Id', 72);
Variables.addVariable('dog2Id', 73);
Variables.addVariable('squirrel1Id', 74);
Variables.addVariable('monkey2Id', 75);
Variables.addVariable('monkey3Id', 76);

Variables.addVariable('viktorToolUpgradeEvent', 81);
Variables.addVariable('viktorDaysToComplete', 82);
Variables.addVariable('viktorToolBeingUpgraded', 83);
Variables.addVariable('upgradedToolId', 84);
Variables.addVariable('blueCrystalDropRate', 85);
Variables.addVariable('lastTomatoWarPosition', 86);
Variables.addVariable('shinyTrinketSpawnRate', 87);
Variables.addVariable('bigBlueCrystalDropRate', 88);
Variables.addVariable('tomatoWarBrittanyScore', 89);
Variables.addVariable('tomatoWarNathaliaScore', 90);
Variables.addVariable('tomatoWarDevinScore', 91);
Variables.addVariable('tomatoWarViktorScore', 92);
Variables.addVariable('tomatoWarPlayerScore', 93);
Variables.addVariable('tomatoWarThirdPlace', 94);
Variables.addVariable('tomatoWarFourthPlace', 95);
Variables.addVariable('tomatoWarLastPlace', 96);
Variables.addVariable('storageFeedCount', 97);
Variables.addVariable('storageHayCount', 98);

Variables.addVariable('itemsTrashed', 100);
Variables.addVariable('newRecipeName', 102);

Variables.addVariable('dogName', 103);
Variables.addVariable('farmName', 104);

Variables.addVariable('chickenSpeedScore', 105);
Variables.addVariable('chickenEggChanceScore', 106);
Variables.addVariable('chickenLuckScore', 107);
Variables.addVariable('chickenFinalScore', 108);
Variables.addVariable('playersFavoriteMovieGenre', 111);
Variables.addVariable('flowerFestivalStep', 135);
Variables.addVariable('flowerFestivalScore', 136);

Variables.addVariable('flowerFestivalViktorScore', 137);
Variables.addVariable('flowerFestivalDevinScore', 138);
Variables.addVariable('flowerFestivalCindyScore', 139);
Variables.addVariable('flowerFestivalNathaliaScore', 140);
Variables.addVariable('flowerFestivalBillyScore', 141);
Variables.addVariable('flowerFestivalBrittanyScore', 142);
Variables.addVariable('flowerFestivalFirstPlace', 143);
Variables.addVariable('flowerFestivalSecondPlace', 144);
Variables.addVariable('flowerFestivalThirdPlace', 145);
Variables.addVariable('flowerFestivalFourthPlace', 146);
Variables.addVariable('flowerFestivalFifthPlace', 147);
Variables.addVariable('flowerFestivalSixthPlace', 148);
Variables.addVariable('flowerFestivalSeventhPlace', 149);

Variables.addVariable('flowerFestivalWinner', 150);
Variables.addVariable('flowerFestivalWins', 151);
Variables.addVariable('giftLevel', 154);
Variables.addVariable('friendName', 155);

Variables.addVariable('fireCookingOldItemId', 156);
Variables.addVariable('fireCookingNewItemId', 157);

Variables.addVariable('unlockedSaciLevel', 158);
Variables.addVariable('sacisFound', 159);
Variables.addVariable('weedsLeft', 160);
Variables.addVariable('logsLeft', 161);
Variables.addVariable('rocksLeft', 162);

Variables.addVariable('yearDay', 163);
Variables.addVariable('totalDays', 164);
Variables.addVariable('shippedItems', 165);
Variables.addVariable('weekDay', 166);


// DEPRECATED
Variables.addVariable('benjaminTalkStage', 109);
Variables.addVariable('brittanyTalkStage', 113);
Variables.addVariable('cindyTalkStage', 115);
Variables.addVariable('devinTalkStage', 117);
Variables.addVariable('lucasTalkStage', 119);
Variables.addVariable('nathaliaTalkStage', 121);
Variables.addVariable('raphaelTalkStage', 123);
Variables.addVariable('stellaTalkStage', 125);
Variables.addVariable('viktorTalkStage', 127);
Variables.addVariable('annieTalkStage', 129);
Variables.addVariable('chloeTalkStage', 131);
Variables.addVariable('juliaTalkStage', 133);
Variables.addVariable('sergeTalkStage', 152);

Variables.addVariable('bathCount', 153);
Variables.addVariable('customTaskCount', 154);

Variables.addVariable('hayCount', 155);
Variables.addVariable('feedCount', 156);
Variables.addVariable('maxHayCount', 157);
Variables.addVariable('maxFeedCount', 158);
Variables.addVariable('fishTotal', 159);
Variables.addVariable('fishTotalStr', 160);

Variables.addVariable('chickenRaceChickenId', 161);
