var Switches = {
  addSwitch : function(name, switchId) {
    this['_' + name] = switchId;

    MVC.accessor(Switches, name, function(value) {
      if ($gameSwitches !== undefined && $gameSwitches !== null) {
        $gameSwitches.setValue(switchId, value);
      }
    }, function(){
      if ($gameSwitches !== undefined && $gameSwitches !== null) {
        return $gameSwitches.value(switchId);
      } else {
        return false;
      }
    });
  },

  reset : function() {
    $gameSwitches.reset();
    
    this.hidePlayer = true;
    this.alwaysOn = true;
    this.drawAffectedTiles = true;
  },

  getSwitch : function(switchName) {
    return Switches[switchName];
  },

  setSwitch : function(switchName, value) {
    Switches[switchName] = value;
  },

  deleteCustomSwitches: function() {
    var customSwitches = this.getCustomSwitches();
    for (var key in customSwitches) {
      if (!this.hasOwnProperty(key)) continue;
      delete this[key];
    }
  },

  getCustomSwitches: function() {
    var customSwitches = {};

    for (var key in this) {
      if (!this.hasOwnProperty(key)) continue;
      if (typeof this[key] == "function") continue;
      if (key.substring(0, 1) == '_') {
        if (this.hasOwnProperty(key.substring(1))) continue;
      } else {
        if (this.hasOwnProperty('_' + key)) continue;
      }

      customSwitches[key] = this[key];
    }

    return customSwitches;
  },

  setCustomSwitches: function(customSwitches) {
    for (var key in customSwitches) {
      if (!customSwitches.hasOwnProperty(key)) continue;

      this[key] = customSwitches[key];
    }
  }
};

Switches.addSwitch('timeHudEnabled', 1);
Switches.addSwitch('toolHudEnabled', 2);
Switches.addSwitch('drawAffectedTiles', 3);

Switches.addSwitch('gotFirstBag', 5);
Switches.addSwitch('gotSecondBag', 6);
Switches.addSwitch('hasRegularWateringCan', 7);
Switches.addSwitch('hasIronHoe', 8);
Switches.addSwitch('hasIronHammer', 9);
Switches.addSwitch('hasIronSickle', 10);
Switches.addSwitch('hasIronAxe', 11);
Switches.addSwitch('alwaysOn', 12);
Switches.addSwitch('hasBrush', 13);
Switches.addSwitch('hasFishingRod', 14);
Switches.addSwitch('hasClippers', 15);
Switches.addSwitch('hasMilker', 16);

Switches.addSwitch('martinLeftTheCave', 18);
Switches.addSwitch('railFixed', 19);
Switches.addSwitch('startedTutorial', 20);
Switches.addSwitch('orange_story', 21);
Switches.addSwitch('finishedIntroEvent', 22);
Switches.addSwitch('finishedTutorial', 23);



Switches.addSwitch('hidePlayer', 28);


Switches.addSwitch('hasSilverWateringCan', 31);
Switches.addSwitch('hasCopperHoe', 32);
Switches.addSwitch('hasCopperHammer', 33);
Switches.addSwitch('hasCopperSickle', 34);
Switches.addSwitch('hasCopperAxe', 35);
Switches.addSwitch('hasRedWateringCan', 36);
Switches.addSwitch('hasSilverHoe', 37);
Switches.addSwitch('hasSilverHammer', 38);
Switches.addSwitch('hasSilverSickle', 39);
Switches.addSwitch('hasSilverAxe', 40);
Switches.addSwitch('hasGreenWateringCan', 41);
Switches.addSwitch('hasGoldenHoe', 42);
Switches.addSwitch('hasGoldenHammer', 43);
Switches.addSwitch('hasGoldenSickle', 44);
Switches.addSwitch('hasGoldenAxe', 45);
Switches.addSwitch('forceToolHud', 46);

Switches.addSwitch('canAccessCenterFarm', 47);

Switches.addSwitch('checkedCaveRail', 49);

Switches.addSwitch('knowAboutPom', 55);
Switches.addSwitch('forestSpellLifted', 56);
Switches.addSwitch('caveLevel1Solved', 57);

Switches.addSwitch('caveLevel3Solved', 60);
Switches.addSwitch('isRaining', 61);

Switches.addSwitch('playedCutscene', 63);
Switches.addSwitch('isFishing', 64);

Switches.addSwitch('playedRaphaelTutorial', 70);

Switches.addSwitch('newMail', 73);
Switches.addSwitch('hasRibbon', 74);

Switches.addSwitch('isChickenFestival', 82);
Switches.addSwitch('isFestival', 83);
Switches.addSwitch('isInsideFestival', 85);

Switches.addSwitch('devinWonChickenFestival', 86);
Switches.addSwitch('miaWonChickenFestival', 87);
Switches.addSwitch('raphaelWonChickenFestival', 88);
Switches.addSwitch('nathaliaWonChickenFestival', 89);

Switches.addSwitch('isInsideFestivalCompetition', 90);
Switches.addSwitch('isFestivalEnding', 91);
Switches.addSwitch('boughtFestivalAnimal', 92);

Switches.addSwitch('playerWonChickenFestival', 93);
Switches.addSwitch('playerLostChickenFestival', 94);

Switches.addSwitch('hasDiamondHoe', 95);
Switches.addSwitch('hasDiamondSickle', 96);
Switches.addSwitch('hasDiamondAxe', 97);
Switches.addSwitch('hasDiamondHammer', 98);
Switches.addSwitch('hasBrokenAxe', 99);

Switches.addSwitch('playedAnnieIntroduction', 100);
Switches.addSwitch('knowsAboutLotteries', 101);

Switches.addSwitch('playedChloesFoodBurntEvent', 102);

Switches.addSwitch('waitingForTransfer', 104);

Switches.addSwitch('foundSecondCart', 105);
Switches.addSwitch('secondDoor', 107);
Switches.addSwitch('sixthDoor', 111);
Switches.addSwitch('playedMinimumIntroduction', 112);
Switches.addSwitch('playedMinimumIntroduction2', 113);

Switches.addSwitch('canSellMushroomSeeds', 115);
Switches.addSwitch('canSellSuperBag', 116);

Switches.addSwitch('unlockedMonkeys', 117);
Switches.addSwitch('unlockedBunnies', 118);

Switches.addSwitch('forceGoHome', 119);
Switches.addSwitch('startedLucasChickenQuest', 120);
Switches.addSwitch('ignoredLucasChickenQuest', 121);

Switches.addSwitch('canBuyRoosterFromLucas', 122);
Switches.addSwitch('boughtRoosterFromLucas', 123);


Switches.addSwitch('devinToldJoke1', 131);
Switches.addSwitch('expandedHouse', 132);

Switches.addSwitch('bathtubFilled', 133);

Switches.addSwitch('isExpandingHouse', 134);
Switches.addSwitch('hiredRaphael', 135);
Switches.addSwitch('playerNeedsToKnowAboutExpansion', 136);

Switches.addSwitch('gotMomsLetterAboutDebt', 137);


Switches.addSwitch('playerUsingCart', 140);

Switches.addSwitch('lucasLightsOn', 141);
Switches.addSwitch('juliaLightsOn', 142);
Switches.addSwitch('raphaelLightsOn', 143);
Switches.addSwitch('bonnieLightsOn', 144);
Switches.addSwitch('viktorLightsOn', 145);
Switches.addSwitch('storeLightsOn', 146);
Switches.addSwitch('nathaliaLightsOn', 147);
Switches.addSwitch('miaLightsOn', 148);
Switches.addSwitch('benjaminLightsOn', 149);
Switches.addSwitch('restaurantLightsOn', 150);
Switches.addSwitch('brittanyLightsOn', 151);
Switches.addSwitch('roryLightsOn', 152);
Switches.addSwitch('gabrielLightsOn', 153);
Switches.addSwitch('amandaLightsOn', 154);
Switches.addSwitch('ildaLightsOn', 155);
Switches.addSwitch('andreLightsOn', 156);

Switches.addSwitch('playedCutsceneFirstTurtle', 157);
Switches.addSwitch('movedCaveBarrel', 158);
Switches.addSwitch('playedRaphaelWantingGirlfriend', 159);
Switches.addSwitch('knowsAboutCindysDream', 160);

Switches.addSwitch('playerDislikesFarming', 161);
Switches.addSwitch('playerToldCindyTheyDislikeFarming', 162);
Switches.addSwitch('heardAboutMissingBlueBoots', 163);
Switches.addSwitch('deliveredLeftBoot', 164);
Switches.addSwitch('deliveredRightBoot', 165);

Switches.addSwitch('isCandyFestival', 166);
Switches.addSwitch('gaveCandyToPhi', 167);
Switches.addSwitch('gaveCandyToRichard', 168);
Switches.addSwitch('gaveCandyToNathalia', 169);
Switches.addSwitch('receivedDailyGiftFromChloe', 170);

Switches.addSwitch('doorToRuins', 171);
Switches.addSwitch('foundMountainTopCrystal', 172);
Switches.addSwitch('foundWinterAreaCart', 173);
Switches.addSwitch('playedDevinFindingMagicBook', 174);

Switches.addSwitch('devinOnAProject', 175);
Switches.addSwitch('devinFinishingSprinkler', 176);
Switches.addSwitch('unlockedSprinklers', 177);
Switches.addSwitch('devinMakingAnotherSprinkler', 178);

Switches.addSwitch('hasCustomTasks', 179);


Switches.addSwitch('raphaelTalkedAboutForest', 181);
Switches.addSwitch('forestSouthSolved', 182);

Switches.addSwitch('hideParty', 183);
Switches.addSwitch('cindyTalkedToRaphael', 184);

Switches.addSwitch('playedRaphaelForestInvestigation', 185);
Switches.addSwitch('talkedToChloeAboutCurupiraCachaca', 186);
Switches.addSwitch('talkedToRaphaelAboutCachaca', 187);

Switches.addSwitch('talkedToBenjaminAboutCurupira', 189);
Switches.addSwitch('talkedToCurupira', 191);

Switches.addSwitch('hideFollowers', 192);
Switches.addSwitch('needsRaphaelLetterAboutForest', 193);

Switches.addSwitch('benjamin_tutorial_picked_item', 194);
Switches.addSwitch('benjamin_tutorial_plowed_soil', 195);
Switches.addSwitch('benjamin_tutorial_seed_sowed', 196);

Switches.addSwitch('playedOldHorseCartEvent', 197);
Switches.addSwitch('canPlayOldHorseCartEvent', 198);
Switches.addSwitch('playedOldHorseCartEvent2', 199);

Switches.addSwitch('canPlayPhisShenanigans', 201);
Switches.addSwitch('playedPhisShenanigans', 202);
Switches.addSwitch('playedPhisShenanigans2', 203);

Switches.addSwitch('canBuyStrawberrySeeds', 204);
Switches.addSwitch('canBuyWatermelonSeeds', 205);
Switches.addSwitch('canBuyPumpkinSeeds', 206);

Switches.addSwitch('viktorIsUpgradingTool', 207);
Switches.addSwitch('isTomatoFestival', 208);
Switches.addSwitch('isFlowerFestival', 209);
Switches.addSwitch('amandaToldAboutFlowerFestival', 210);


Switches.addSwitch('lockInputForFestival', 214);

Switches.addSwitch('playerWonTomatoFestival', 215);
Switches.addSwitch('brittanyWonTomatoFestival', 216);
Switches.addSwitch('nathaliaWonTomatoFestival', 217);
Switches.addSwitch('viktorWonTomatoFestival', 218);
Switches.addSwitch('devinWonTomatoFestival', 219);

Switches.addSwitch('isFallMazeFestival', 220);

Switches.addSwitch('canBuyChillipepperSeeds', 221);
Switches.addSwitch('canBuyCassavaSeeds', 222);
Switches.addSwitch('canBuyGrapeSeeds', 223);
Switches.addSwitch('canBuyBeetSeeds', 224);
Switches.addSwitch('canBuyBellpepperSeeds', 225);
Switches.addSwitch('canBuyBroccoliSeeds', 226);
Switches.addSwitch('canBuyPeanutSeeds', 227);
Switches.addSwitch('canBuyRadishSeeds', 228);
Switches.addSwitch('canBuySpinachSeeds', 229);

Switches.addSwitch('karlLightsOn', 230);

Switches.addSwitch('hasKitchenKnife', 231);
Switches.addSwitch('hasKitchenPot', 232);
Switches.addSwitch('hasKitchenOven', 233);
Switches.addSwitch('hasKitchenPan', 234);
Switches.addSwitch('hasKitchenBlender', 235);
Switches.addSwitch('hasKitchenMixer', 236);

Switches.addSwitch('salesmanVisitedToday', 237);
Switches.addSwitch('forceTimeHud', 238);


Switches.addSwitch('gotSalesmanGoldenOrange', 240);

Switches.addSwitch('dukeLightsOn', 242);

Switches.addSwitch('playedStoryExplanation', 243);
Switches.addSwitch('playedStoryFirstIdea', 244);
Switches.addSwitch('playedStoryFirstTrophy', 245);

Switches.addSwitch('playerChoseSweet', 246);
Switches.addSwitch('playerChoseSavory', 247);
Switches.addSwitch('foundCaveGoldenOrange', 248);

Switches.addSwitch('playerKnowsBenjaminIsAnActor', 249);
Switches.addSwitch('movieTasteMatchesBenjamin', 251);

Switches.addSwitch('viktorIsLookingForSugarcanes', 252);
Switches.addSwitch('knowsLucasJob', 253);

Switches.addSwitch('gotAnyCrystalToday', 254);
Switches.addSwitch('foundTrainCaveGoldenOrange', 255);

Switches.addSwitch('hasGreenFishingRod', 256);
Switches.addSwitch('hasBlueFishingRod', 257);

Switches.addSwitch('talkingOnHouseDoor', 258);
Switches.addSwitch('builtTownSwing', 259);

Switches.addSwitch('festivalRightSideOpen', 260);
Switches.addSwitch('festivalLeftSideOpen', 261);

Switches.addSwitch('playerWonFlowerFestival', 262);
Switches.addSwitch('playerGotSecondPlaceOnFlowerFestival', 263);
Switches.addSwitch('playerGotThirdPlaceOnFlowerFestival', 264);

Switches.addSwitch('holdDoorOpen', 265);


Switches.addSwitch('hasMagnifier', 267);
Switches.addSwitch('isPlayingDate', 268);
Switches.addSwitch('playedAnnieZeroHearts', 269);
Switches.addSwitch('playedAnnieFirstHeart', 270);

Switches.addSwitch('isDukeInTown', 271);
Switches.addSwitch('playedDevinEventRichardQuestions', 272);
Switches.addSwitch('playedDevinFirstDate', 273);
Switches.addSwitch('playedDevinHeartEvent0', 274);
Switches.addSwitch('playedDevinHeartEvent0B', 275);
Switches.addSwitch('playedDevinHeartEvent0C', 276);
Switches.addSwitch('playedDevinHeartEvent0D', 277);
Switches.addSwitch('playedCindyHeartEvent0', 278);
Switches.addSwitch('playedCindyHeartEvent1', 279);
Switches.addSwitch('refusedToHelpCindy', 280);

Switches.addSwitch('burnedBridgesWithCindy', 281);
Switches.addSwitch('burnedBridgesWithViktor', 282);

Switches.addSwitch('playedCindyFirstDate', 283);
Switches.addSwitch('playedNathaliaFirstDate', 284);
Switches.addSwitch('playedLucasFirstDate', 285);
Switches.addSwitch('playedBenjaminFirstDate', 286);
Switches.addSwitch('playedBrittanyFirstDate', 287);
Switches.addSwitch('playedRaphaelFirstDate', 288);
Switches.addSwitch('playedStellaFirstDate', 289);
Switches.addSwitch('playedViktorFirstDate', 290);
Switches.addSwitch('playedAnnieFirstDate', 291);

Switches.addSwitch('playedDevinSecondDate', 292);
Switches.addSwitch('playedCindySecondDate', 293);
Switches.addSwitch('playedNathaliaSecondDate', 294);
Switches.addSwitch('playedLucasSecondDate', 295);
Switches.addSwitch('playedBenjaminSecondDate', 296);
Switches.addSwitch('playedBrittanySecondDate', 297);
Switches.addSwitch('playedRaphaelSecondDate', 298);
Switches.addSwitch('playedStellaSecondDate', 299);
Switches.addSwitch('playedViktorSecondDate', 300);
Switches.addSwitch('playedAnnieSecondDate', 301);

Switches.addSwitch('datingDevin', 302);
Switches.addSwitch('datingCindy', 303);
Switches.addSwitch('datingNathalia', 304);
Switches.addSwitch('datingLucas', 305);
Switches.addSwitch('datingBenjamin', 306);
Switches.addSwitch('datingBrittany', 307);
Switches.addSwitch('datingRaphael', 308);
Switches.addSwitch('datingStella', 309);
Switches.addSwitch('datingViktor', 310);
Switches.addSwitch('datingAnnie', 311);

Switches.addSwitch('cindyMovedOut', 312);

Switches.addSwitch('unlockedTables', 313);
Switches.addSwitch('unlockedChairs', 314);
Switches.addSwitch('unlockedBookCases', 315);

Switches.addSwitch('bagWasFullWhileBuying', 316);
Switches.addSwitch('playedSaciIntroduction', 317);

Switches.addSwitch('holdPlayer', 318);
Switches.addSwitch('devinFinishingSuperSprinkler', 319);
Switches.addSwitch('unlockedSuperSprinklers', 320);
Switches.addSwitch('playedDevinKnowsMagic', 321);
Switches.addSwitch('metAllVillagers', 322);

Switches.addSwitch('knowsCandyDay', 323);

Switches.addSwitch('lucasOpenedUp', 324);
Switches.addSwitch('benjaminOpenedUp', 325);
Switches.addSwitch('playerDrinks', 326);
Switches.addSwitch('canShowChloeFoodBurntEvent', 327);

Switches.addSwitch('unlockedBenjiHayTask', 329);
Switches.addSwitch('unlockedCindyEvents', 330);

Switches.addSwitch('unlockedBrittanyEvents', 332);
Switches.addSwitch('unlockedNathaliaEvents', 333);
Switches.addSwitch('unlockedRaphaelEvents', 334);
Switches.addSwitch('unlockedStellaEvents', 335);
Switches.addSwitch('unlockedViktorEvents', 336);

Switches.addSwitch('builtSecondFloor', 337);

Switches.addSwitch('amandaGaveFlowerSeedsToday', 338);
Switches.addSwitch('playerKnowsAboutSpringQueen', 339);
Switches.addSwitch('sawAmandaChloeDiscussionToday', 340);
Switches.addSwitch('playerChoseFlowersOverCrops', 341);

Switches.addSwitch('cindyWorkingWithRaphael', 342);
Switches.addSwitch('playedBenjaminHeartEvent0', 343);
Switches.addSwitch('playedNathaliaHeartEvent0', 344);

Switches.addSwitch('holdPlayerAsync', 345);
Switches.addSwitch('playerWearingSwimsuit', 346);

Switches.addSwitch('skipMapStore', 347);
Switches.addSwitch('isSpaDoorOpen', 348);

Switches.addSwitch('colorblindMode', 349);
Switches.addSwitch('motivationDream', 350);
Switches.addSwitch('motivationMoney', 351);
Switches.addSwitch('motivationWork', 352);
Switches.addSwitch('motivationRunningAway', 353);

Switches.addSwitch('miaExplainedVet', 356);
Switches.addSwitch('martinCameBack', 357);
Switches.addSwitch('isGaryInTown', 358);
Switches.addSwitch('lucasGaveCrystal', 359);

