function Lightmask() {
  this.initialize.apply(this, arguments);
}

Lightmask.prototype = Object.create(PIXI.Container.prototype);
Lightmask.prototype.constructor = Lightmask;

(function($) {
  Object.defineProperties($, {
    width: {
      get: function() {
        return this._width;
      },
      configurable: true
    },
    height: {
      get: function() {
        return this._height;
      },
      configurable: true
    },
    sprites: {
      get: function() {
        return this._sprites;
      },
      configurable: true
    },
    currentMapId: {
      get: function() {
        return this._currentMapId;
      },
      set: function(value) {
        this._currentMapId = value;
      },
      configurable: true
    }
  });

  $.initialize = function() {
    PIXI.Container.call(this);
    this._width = Graphics.width;
    this._height = Graphics.height;
    this._sprites = [];
    this.lightUpdateDelay = 0;
    this.createMaskBitmap();
  };

  $.update = function() {
    this.updateMask();
  };

  $.createMaskBitmap = function() {
    this._maskBitmap = new Bitmap(Graphics.width, Graphics.height);
  };

  $.maskColor = function() {
    var hour = Managers.Time.hour;
    var lightColors = LightSystem.lightColors;

    if ($gameMap.isInside()) {
      if ($gameMap.isCave()) {
        return lightColors.cave[hour % lightColors.cave.length];
      } else {
        return lightColors.inside[hour % lightColors.inside.length];
      }
    } else {
      return lightColors.outside[hour % lightColors.outside.length];
    }
  };

  $.walkColor = function(newRGB, currentRGB, colorName, tintSpeed) {
    if (newRGB[colorName] < currentRGB[colorName]) {
      currentRGB[colorName] = currentRGB[colorName] - tintSpeed;
      if (newRGB[colorName] > currentRGB[colorName]) {
        currentRGB[colorName] = newRGB[colorName];
      }
    } else if (newRGB[colorName] > currentRGB[colorName]) {
      currentRGB[colorName] = currentRGB[colorName] + tintSpeed;
      if (newRGB[colorName] < currentRGB[colorName]) {
        currentRGB[colorName] = newRGB[colorName];
      }
    }

    newRGB[colorName] = newRGB[colorName].clamp(0, 255);
  };

  $.refreshMaskColor = function() {
    var destinationColor = $.maskColor();
    var newColor = destinationColor;

    if (Managers.Lighting._lastMaskColor !== undefined && destinationColor !== Managers.Lighting._lastMaskColor) {
      var currentColor = Managers.Lighting._lastMaskColor;
      var currentRGB = Managers.Lighting._currentRGB;

      if (!!currentRGB || currentColor.charAt(0) == '#') {
        newColor = Managers.Lighting.colorNameToHex(destinationColor);
        if (newColor === false) {
          newColor = destinationColor;
        }

        if (currentRGB === undefined) {
          currentRGB = Utils.hexToRgb(currentColor);
        }
        var newRGB = Utils.hexToRgb(newColor);

        this.walkColor(newRGB, currentRGB, 'red', Constants.LIGHTMASK_TINTSPEED * Constants.LIGHTMASK_FRAMEDELAY);
        this.walkColor(newRGB, currentRGB, 'green', Constants.LIGHTMASK_TINTSPEED * Constants.LIGHTMASK_FRAMEDELAY);
        this.walkColor(newRGB, currentRGB, 'blue', Constants.LIGHTMASK_TINTSPEED * Constants.LIGHTMASK_FRAMEDELAY);

        newColor = '#' + ((1 << 24) + (Math.floor(currentRGB.red) << 16) + (Math.floor(currentRGB.green) << 8) + Math.floor(currentRGB.blue)).toString(16).slice(1);
        Managers.Lighting._currentRGB = currentRGB;
      }
    } else {
      Managers.Lighting._currentRGB = undefined;
    }

    Managers.Lighting._lastMaskColor = newColor;
  };

  $.refreshMask = function() {
    const backOpacity = 255;

    //calculates what will be the new mask color
    this.refreshMaskColor();

    // Adds the mask sprite
    if (!this.addedMaskBitmap) {
      this.addSprite(0, 0, this._maskBitmap, backOpacity, 2);
      this.addedMaskBitmap = true;
    }
    this._maskBitmap.fillRect(0, 0, Graphics.width, Graphics.height, Managers.Lighting._lastMaskColor);

    this._lastDisplayX = $gameMap._displayX;
    this._lastDisplayY = $gameMap._displayY;
  };

  $.updateMask = function() {
    if (!Managers.Lighting.isActive()) return;
    if (!Managers.Scenes._scene.isFullyLoaded()) return;

    var newId = 0;

    if ($gameMap !== undefined && $gameMap !== null) {
      newId = $gameMap._mapId;
    }

    if (newId !== this.currentMapId) {
      Managers.Lighting.dirty = true;
      this.lightUpdateDelay = 0;
    }

    if (this.lightUpdateDelay > 0) {
      this.lightUpdateDelay--;
      return;
    }

    if (Managers.Lighting._lastMaskColor === undefined || Managers.Lighting._lastMaskColor.toUpperCase() !== $.maskColor().toUpperCase()) {
      Managers.Lighting.dirty = true;
    }

    if (Managers.Lighting.dirty) {
      this.refreshMask();
      Managers.Lighting.dirty = false;
      this.currentMapId = newId;

      // Increases the delay based on zoom size, since it's a much heavier operation on larger resolutions
      this.lightUpdateDelay = Utils.getFrameCount(Constants.LIGHTMASK_FRAMEDELAY * Graphics.zoomLevel);
    }
  };

  $.addSprite = function(x, y, bitmap, opacity, blendMode, rotation, anchorX, anchorY) {
    if (opacity === undefined) opacity = 255;
    if (blendMode === undefined) blendMode = 2;
    if (rotation === undefined) rotation = 0;
    if (anchorX === undefined) anchorX = 0;
    if (anchorY === undefined) anchorY = 0;

    var sprite = new Sprite(this.viewport);
    sprite.bitmap = bitmap;
    sprite.opacity = opacity;
    sprite.blendMode = blendMode;
    sprite.x = x;
    sprite.y = y;

    this._sprites.push(sprite);
    this.addChild(sprite);

    sprite.rotation = rotation;
    sprite.ax = anchorX;
    sprite.ay = anchorY;
    sprite.opacity = opacity;

    return sprite;
  };

  $.popSprite = function() {
    var sprite = this._sprites.pop();

    if (sprite) {
      this.removeChild(sprite);
    }

    return sprite;
  };

  $.popAllSprites = function() {
    var sprite;
    while (this._sprites.length > 0) {
      sprite = this._sprites.pop();

      if (sprite) {
        this.removeChild(sprite);
      }
    }
  };

  $.setPlayerSprite = function(playerSprite) {
    this._playerSprite = playerSprite;
  };
})(Lightmask.prototype);