function FarmObject() {
  this.initialize.apply(this, arguments);
}

(function($){
  $.initialize = function() {
    this.guid = Utils.uniqueId();
  };

  $.isEmpty = function() {
    return this.state == Constants.FarmObjectState.NONE;
  };

  MVC.accessor($, 'guid');
  MVC.accessor($, 'mapId');
  MVC.accessor($, 'x');
  MVC.accessor($, 'y');

  MVC.accessor($, 'tilled');
  MVC.reader($, 'isCropOrTree', function() {
    if (this.modelName) {
      if (this.modelName.indexOf('-crop') >= 0) {
        return true;
      }

      if (this.modelName.indexOf('-tree') >= 0) {
        if (this.modelName == 'fallen-tree') {
          return false;
        }
        return true;
      }
    }

    return false;
  });

  MVC.accessor($, 'cropName', function(value) {
    if (value) {
      console.error("cropName can't be assigned anymore: " + value);
    }
  }, function() {
    if (this.modelName) {
      if (this.modelName.indexOf('-crop') >= 0) {
        return this.modelName.replace('-crop', '');
      }
    }

    return undefined;
  });

  MVC.accessor($, 'watered');
  MVC.accessor($, 'stage');
  MVC.accessor($, 'points');
  MVC.accessor($, 'spoiled');
  MVC.accessor($, 'rockType');
  MVC.accessor($, 'subtype');
  MVC.accessor($, 'broken');
  MVC.accessor($, 'targetMapId');
  MVC.accessor($, 'invisible');
  MVC.accessor($, 'immuneToPlayer');
  MVC.accessor($, 'pressed');
  MVC.accessor($, 'oneTime');
  MVC.accessor($, 'hp');
  
  MVC.accessor($, 'offsetX');
  MVC.accessor($, 'offsetY');

  $.useAlternateSprite = function() {
    if (this.modelName == Constants.FarmObjectState.GATE) {
      return !!this.pressed;
    }

    if (this.watered) return true;

    if (Managers.Weather.isRaining()) {
      if ($gameMap._mapId == this.mapId) {
        if (!$gameMap.isInside()) {
          return true;
        }
      }
    }

    return false;
  };

  $.isSameObject = function(otherObject) {
    if (!otherObject) return false;
    if (otherObject == this) return true;
    if (otherObject.guid == this.guid) return true;

    for (var key in this) {
      if (!this.hasOwnProperty(key)) continue;
      if (!key.startsWith('_')) continue;

      if (this[key] != otherObject[key]) return false;
    }
    
    for (key in otherObject) {
      if (!otherObject.hasOwnProperty(key)) continue;
      if (!key.startsWith('_')) continue;

      if (this[key] != otherObject[key]) return false;
    }

    return true;
  };

  $.getButtonState = function(detailedState) {
    if (!detailedState) return Constants.FarmObjectState.BUTTON;

    if (this.pressed) {
      return Constants.FarmObjectState.BUTTON_PRESSED;
    }

    if (!this.immuneToPlayer) {
      if ($gamePlayer.isTouchingTile(this.x, this.y)) {
        if (this.oneTime) {
          this.pressed = true;
        }
        return Constants.FarmObjectState.BUTTON_PRESSED;
      }
    }

    var objectCount = $gameMap.anythingXy(this.x, this.y).length;
    if (objectCount > 1) {
      if (this.oneTime) {
        this.pressed = true;
      }
      return Constants.FarmObjectState.BUTTON_PRESSED;
    }
    
    return Constants.FarmObjectState.BUTTON;
  };

  $.getGateState = function(detailedGate) {
    if (!detailedGate) return Constants.FarmObjectState.GATE;

    if (Managers.FarmObjects.isFenceObject(this.mapId, this.x -1, this.y, true)) {
      return Constants.FarmObjectState.GATE;
    }

    if (Managers.FarmObjects.isFenceObject(this.mapId, this.x + 1, this.y, true)) {
      return Constants.FarmObjectState.GATE;
    }

    if (Managers.FarmObjects.isFenceObject(this.mapId, this.x, this.y - 1, true)) {
      return Constants.FarmObjectState.GATE_VERTICAL;
    }
    if (Managers.FarmObjects.isFenceObject(this.mapId, this.x, this.y + 1, true)) {
      return Constants.FarmObjectState.GATE_VERTICAL;
    }

    return Constants.FarmObjectState.GATE;
  };

  $.getFenceState = function(detailedFence) {
    if (!detailedFence) return Constants.FarmObjectState.FENCE;

    var top = Managers.FarmObjects.isFenceObject(this.mapId, this.x, this.y - 1, false);
    var left = Managers.FarmObjects.isFenceObject(this.mapId, this.x -1, this.y, false);
    var right = Managers.FarmObjects.isFenceObject(this.mapId, this.x + 1, this.y, false);
    var bottom = Managers.FarmObjects.isFenceObject(this.mapId, this.x, this.y + 1, false);

    if (top) {
      if (left) {
        if (right) {
          if (bottom) {
            return Constants.FarmObjectState.FENCE_CENTER;
          }

          return Constants.FarmObjectState.FENCE_HORIZONTAL_DOWN;
        }

        if (bottom) {
          return Constants.FarmObjectState.FENCE_VERTICAL_RIGHT;
        }

        return Constants.FarmObjectState.FENCE_BOTTOM_RIGHT;
      }

      if (right) {
        if (bottom) {
          return Constants.FarmObjectState.FENCE_VERTICAL_LEFT;
        }

        return Constants.FarmObjectState.FENCE_BOTTOM_LEFT;
      }

      if (bottom) {
        return Constants.FarmObjectState.FENCE_VERTICAL;
      }

      return Constants.FarmObjectState.FENCE_DOWN;
    }

    if (bottom) {
      if (left) {
        if (right) {
          return Constants.FarmObjectState.FENCE_HORIZONTAL_UP;
        }

        return Constants.FarmObjectState.FENCE_TOP_RIGHT;
      }

      if (right) {
        return Constants.FarmObjectState.FENCE_TOP_LEFT;
      }

      return Constants.FarmObjectState.FENCE_UP;
    }

    if (left) {
      if (right) {
        return Constants.FarmObjectState.FENCE_HORIZONTAL;
      }

      return Constants.FarmObjectState.FENCE_RIGHT;
    }

    if (right) {
      return Constants.FarmObjectState.FENCE_LEFT;
    }

    return Constants.FarmObjectState.FENCE;
  };

  $.isLarge = function() {
    if (Managers.FarmObjects.isLargeModel(this.modelName)) return true;
    if (Managers.Content.isFarmObjectLarge(this)) return true;

    return false;
  };

  $.hasCollision = function() {
    if (Managers.FarmObjects.isModelWithCollision(this.modelName)) return true;

    if (this.modelName == FarmObjectState.GRASS) return false;
    if (this.modelName == FarmObjectState.BUTTON) return false;

    //#ToDo: Move those to the new system (registerModelWithCollision)
    if (this.modelName == FarmObjectState.NEW_FENCE) return true;
    if (this.modelName == FarmObjectState.WEED) return true;
    if (this.modelName == FarmObjectState.SMALL_WEED) return true;
    if (this.modelName == FarmObjectState.STUMP) return true;
    if (this.modelName == FarmObjectState.STONE) return true;
    if (this.modelName == FarmObjectState.LOG) return true;

    if (this.modelName == FarmObjectState.BARN || this.modelName == FarmObjectState.COOP) return true;
    if (this.modelName == FarmObjectState.CHEST) return true;
    
    if (this.modelName == FarmObjectState.GATE) {
      if (this.pressed) return false;

      return true;
    }

    if (this.isItem()) return true;
    // if (this.isItem()) return false;
    if (this.rockType !== undefined) return true;

    if (this.modelName !== undefined && this.modelName !== '') {
      const typeObj = this.getFarmObjectType();
      return typeObj.hasCollision();
    }

    return false;
  };

  $.getState = function(detailedState) {
    if (this.modelName == FarmObjectState.SMALL_WEED) return FarmObjectState.WEED;

    if (this.modelName == FarmObjectState.BUTTON) return this.getButtonState(detailedState);
    if (this.modelName == FarmObjectState.NEW_FENCE) return this.getFenceState(detailedState);
    if (this.modelName == FarmObjectState.GATE) return this.getGateState(detailedState);

    if (this.isItem()) return FarmObjectState.ITEM;
    if (this.rockType !== undefined) return FarmObjectState.MINING_ROCK;

    if (this.isCropOrTree) {
      if (this.spoiled) {
        if (!this.stage) {
          return FarmObjectState.SPOILED_SEED;
        }
      }
      switch (this.stage) {
        case 1 :
          return FarmObjectState.SMALL_CROP;
        case 2 :
          return FarmObjectState.MEDIUM_CROP;
        case 3 :
          return FarmObjectState.BIG_CROP;
        case 4 :
          return FarmObjectState.HAVING_FRUIT;
        default :
          return FarmObjectState.SEED;
      }
    }

    if (this.tilled) {
      return FarmObjectState.TILLED_SOIL;
    }

    if (this.modelName) {
      return this.modelName;
    }

    return FarmObjectState.NONE;
  };

  MVC.reader($, 'state', function(){
    return this.getState();
  });

  MVC.reader($, 'detailedState', function(){
    return this.getState(true);
  });

  $.isItem = function() {
    return this.itemName !== undefined && this.itemName !== '';
  };

  $.isGrownCrop = function() {
    if (!this.isCropOrTree) {
      return false;
    }

    if (this.spoiled) {
      return false;
    }

    var farmObjectType = this.getFarmObjectType();
    if (farmObjectType) {
      const stageCaps = farmObjectType.getStageCaps && farmObjectType.getStageCaps();
      if (stageCaps && stageCaps.length) {
        this.updateStage(stageCaps);

        return this.stage >= stageCaps.length;
      }
    }

    return this.stage >= 3;
  };

  $.isTree = function() {
    if (!this.isCropOrTree) {
      return false;
    }

    var type = this.getFarmObjectType();

    return type.isTree();
  };

  $.isCuttableTree = function() {
    if (!this.isCropOrTree) {
      return false;
    }

    const type = this.getFarmObjectType();
    if (type.canBeCut() === false) return false;

    return type.isTree();
  };

  $.isFlower = function() {
    const type = this.getFarmObjectType();
    return type.isFlower();
  };

  $.isBigFarmObject = function() {
    if (this.modelName == 'fence') return false;
    if (this.modelName == 'gate') return false;
    if (this.modelName == 'coop') return true;
    if (this.modelName == 'barn') return true;

    if (!this.isCropOrTree) {
      return false;
    }

    var type = this.getFarmObjectType();

    return type.isBig() || type.isTree() || Managers.Content.isFarmObjectLarge(this);
  };

  $.clear = function() {
    this.tilled = false;
    this.watered = false;
    this.stage = 0;
    this.modelName = '';
    this.itemName = '';
    this.spoiled = false;
    this.points = 0;
    this.rockType = undefined;
    this.broken = false;
    this.subtype = '';
    this.invisible = false;
    this.targetMapId = 0;
    this.immuneToPlayer = false;
    this.pressed = false;
    this.oneTime = false;
    this.lastFruit = false;
    this.type = '';
    this.age = 0;
  };

  $.erase = function() {
    this.clear();
    Managers.FarmObjects.eraseFarmObject(this, true);
  };

  $.doPickEffect = function(farmObjectEvent) {
    var type = this.getFarmObjectType();

    if (type.regrows() && !this.lastFruit) {
      const stageCaps = type.getStageCaps();

      this.stage = stageCaps.length - 1;
      this.points = stageCaps[this.stage - 1];
      this.updateEvent(farmObjectEvent, false);
    } else if (this.tilled) {
      const watered = this.watered;
      const isFlower = type.isFlower();

      this.clear();
      this.tilled = !isFlower;
      this.watered = watered;
      this.updateEvents(farmObjectEvent, false);
    } else {
      this.erase();
      farmObjectEvent.erase();
    }
  };

  $.isBuilding = function() {
    if (this.modelName == Constants.FarmObjectState.BARN) return true;
    if (this.modelName == Constants.FarmObjectState.COOP) return true;

    return false;
  };

  $.isNewGrass = function() {
    if (this.modelName == Constants.FarmObjectState.NEW_GRASS) return true;

    return false;
  };

  $.doPickWeed = function(farmObjectEvent) {
    let itemId = 'weeds';
    if (Managers.Time.mapMonth == Seasons.FALL) {
      itemId = 'yellow-weeds';
    }

    const customClear = Managers.Content.onClearObject(this);
    if (customClear === false) {
      return false;
    }

    if (customClear === true) {
      this.erase();
      this.updateEvents(true, false);
      return false;
    }

    if (Managers.Items.pickItemId(itemId, 1)) {
      this.erase();
      this.updateEvents(true, false);
      return true;
    }

    return false;
  };

  $.doPickCrop = function(farmObjectEvent) {
    const model = this.getFarmObjectType();
    if (!model) return false;

    const cropName = model.cropName;
    if (!cropName) return false;

    if (!Managers.Items.itemIdExists(cropName)) return false;
    if (Managers.Items.isOutOfSeason(cropName, this.mapId)) {
      if (model.isModel(Models.TreeCrop)) {
        return false;
      }
      if (model.isModel(Models.BushCrop)) {
        return false;
      }
    }
    if (!Managers.Items.pickItemId(cropName)) return false;

    const isCrop = this.isCropOrTree && model.isCrop();

    this.doPickEffect(farmObjectEvent);

    if (isCrop) {
      Managers.History.registerCropHarvested(cropName);
    }
    return true;
  };

  $.doPickItem = function(farmObjectEvent) {
    const itemName = this.itemName;
    const customClear = Managers.Content.onClearObject(this);

    if (customClear === false) {
      return false;
    }

    if (customClear === true) {
      this.erase();
      this.updateEvents(true, false);
      return false;
    }

    if (Managers.Items.pickItemId(itemName, this.amount || 1)) {
      this.erase();
      this.updateEvents(true, false);
      return true;
    }

    return false;
  };

  $.pick = function(farmObjectEvent) {
    var success = false;
    let cropName = this.cropName;

    if (this.modelName == Constants.FarmObjectState.WEED || this.modelName == Constants.FarmObjectState.SMALL_WEED) {
      success = this.doPickWeed(farmObjectEvent);
    } else {
      if (cropName) {
        if (cropName == FarmObjectState.SMALL_WEED || cropName == FarmObjectState.WEED) {
          success = this.doPickWeed(farmObjectEvent);
        } else if (this.isGrownCrop()) {
          success = this.doPickCrop(farmObjectEvent);
        }
      } else if (this.itemName !== undefined && this.itemName !== '') {
        success = this.doPickItem(farmObjectEvent);
      }
    }

    if (success) {
      Managers.FarmObjects.clearEmptyItems();
    }

    return success;
  };

  $.isStaticPosition = function() {
    if (this.itemName !== undefined && this.itemName !== '') {
      return true;
    }

    if (this.rockType !== undefined && this.rockType !== '') {
      return true;
    }

    if (this.modelName == FarmObjectState.NEW_FENCE || this.modelName == FarmObjectState.GATE) {
      return true;
    }

    var objectType = Managers.FarmObjects.getFarmObjectType(this.modelName || this.state);

    if (objectType && objectType.isStaticPosition) {
      return objectType.isStaticPosition();
    }

    return false;
  };

  $.updateStage = function(stages) {
    if (!stages) {
      const type = this.getFarmObjectType();
      if (!type) return;

      stages = type.getStageCaps();
    }

    var stage = 0;

    for (var i = 0; i < stages.length; i++) {
      if (this.points >= stages[i]) {
        stage = i + 1;
      } else {
        break;
      }
    }

    this.stage = stage;
  };

  $.increasePoints = function(stages, pointsToIncrease) {
    if (this.spoiled) {
      return;
    }

    if (pointsToIncrease === undefined) pointsToIncrease = 1;
    this.points += pointsToIncrease;

    this.updateStage(stages);
  };

  $.updateEvent = function(farmObjectEvent, updateSiblings) {
    Managers.FarmObjects.updateFarmObjectEvent(this, farmObjectEvent);

    if (updateSiblings) {
      Managers.FarmObjects.updateEventsAt(this.mapId, this.x - 1, this.y);
      Managers.FarmObjects.updateEventsAt(this.mapId, this.x + 1, this.y);
      Managers.FarmObjects.updateEventsAt(this.mapId, this.x, this.y - 1);
      Managers.FarmObjects.updateEventsAt(this.mapId, this.x, this.y + 1);
    }
  };

  $.eraseEvents = function() {
    var farmObjectEvents = $gameMap.farmObjectsXy(this.x, this.y);

    var event = this.getCorrectEvent(farmObjectEvents);
    if (event) {
      event.erase();
    }
  };

  $.findEvent = function() {
    var events = $gameMap.farmObjectsXy(this.x, this.y);
    return this.getCorrectEvent(events);
  };

  $.getCorrectEvent = function(events) {
    for (var i = 0; i < events.length; i++) {
      var event = events[i];
      if (!event) continue;
      if (!event._farmObjectData) continue;

      if (this.isSameObject(event._farmObjectData)) {
        return event;
      }
    }

    return undefined;
  };

  $.getObjectClassType = function() {
    const contentClass = Managers.Content.getObjectClassType(this);
    if (contentClass) {
      return contentClass;
    }

    if (this.isBuilding()) {
      return Objects.Building;
    }

    if (this.modelName == FarmObjectState.SPRINKLER || this.modelName == FarmObjectState.SUPER_SPRINKLER) {
      return Objects.Sprinkler;
    }

    return Objects.Object;
  };

  $.updateEvents = function(checkIfExists, updateSiblings) {
    if (checkIfExists === undefined) checkIfExists = true;
    if (updateSiblings === undefined) updateSiblings = false;
    if ($gameMap._mapId !== this.mapId) return;

    var farmObjectEvent;
    if (checkIfExists) {
      farmObjectEvent = this.findEvent();
    } else {
      farmObjectEvent = false;
    }

    if (farmObjectEvent) {
      Managers.FarmObjects.updateFarmObjectEvent(this, farmObjectEvent);
    } else {
      // Keep in mind that this is only called when the event is created and it won't change as it updates
      const classType = this.getObjectClassType();
      farmObjectEvent = Managers.FarmObjects.createFarmObjectEvent(this, classType);
    }

    if (updateSiblings) {
      Managers.FarmObjects.updateSiblings(this.mapId, this.x, this.y);
    }

    return farmObjectEvent;
  };

  $.playAnimation = function(animationId) {
    if ($gameMap._mapId !== this.mapId) return;

    var farmObjectEvent = this.findEvent();
    if (farmObjectEvent) {
      farmObjectEvent.requestAnimation(animationId);
    }
  };

  $.breakEvents = function(spriteIndex, spriteName, pattern, updateSiblings) {
    if (updateSiblings === undefined) updateSiblings = false;

    if ($gameMap._mapId !== this.mapId) return;

    var farmObjectEvent = this.findEvent();
    if (farmObjectEvent) {
      farmObjectEvent.doBreakingAnimation(spriteIndex, spriteName, pattern);
    }

    if (updateSiblings) {
      Managers.FarmObjects.updateSiblings(this.mapId, this.x, this.y);
    }
  };

  $.getFarmObjectType = function() {
    if (this.tilled && !this.modelName) {
      return Models.TilledSoil;
    }

    if (this.itemName !== undefined && this.itemName !== '') {
      return Managers.FarmObjects.getFarmObjectType('item');
    }

    if (this.rockType !== undefined && this.rockType !== '') {
      return Managers.FarmObjects.getFarmObjectType(`rock-${ this.rockType }`);
    }

    if (this.modelName == FarmObjectState.NEW_FENCE || this.modelName == FarmObjectState.GATE) {
      const detailedState = this.detailedState;
      const detailedType = Managers.FarmObjects.getFarmObjectType(detailedState);
      if (detailedType) {
        if (detailedType.cropName == detailedState || detailedType.modelName == detailedState) {
          return detailedType;
        }
      }
    }

    if (this.modelName) {
      if (this._modelState) {
        const modelState = Managers.FarmObjects.getFarmObjectType(`${ this.modelName }-${ this._modelState}`);
        if (modelState && modelState !== Models.BaseModel) {
          return modelState;
        }
      }

      return Managers.FarmObjects.getFarmObjectType(this.modelName);
    }

    return Managers.FarmObjects.getFarmObjectType(this.type || this.state);
  };

  $.processNewDay = function() {
    if (!this.age) {
      this.age = 0;
    }
    this.age++;

    var type = this.getFarmObjectType();
    if (type) {
      if (type.processFarmObjectNewDay) {
        type.processFarmObjectNewDay(this);
      } else if (type.processGameObjectNewDay) {
        type.processGameObjectNewDay(this);
      }
    } else {
      if (this.tilled) {
        this.watered = false;

        if (Managers.Weather.isRaining()) {
          if (InsideFarmMaps.indexOf(this.mapId) < 0) {
            this.watered = true;
          }
        }

        if (!this.watered) {
          this.watered = Managers.FarmObjects.isTileWithinRangeOfASprinkler(this.mapId, this.x, this.y);
        }
      }
    }
  };

  $.shouldShowSoil = function() {
    if (PlayerFarmMaps.indexOf(this._mapId) < 0) return false;

    if (!this._tilled) return false;
    if (!this.isCropOrTree) return false;
    if (this.isFlower()) return false;

    return true;
  };

  $.clear();
})(FarmObject.prototype);