function DevHelpers() {

}

DevHelpers.savePalleteImage = function(bitmap, characterName) {
  if (!Utils.isNwjs()) return;

  var fs = require('fs');
  var userDocs = Managers.Storage.getUserDocs();
  const folder = Wrapper.joinFileNames(userDocs, 'OrangeSeason', 'Palletes');

  try {
    fs.mkdir(folder, function() {
      try{
        const fileName = Wrapper.joinFileNames(folder, characterName + '.png');
        var regex = /^data:image\/png;base64,/;

        var callback = function(error) {
          if (error !== undefined && error !== null) {
            console.error('An error occured while saving the generated character', error);
          }
        };

        var urlData = bitmap.canvas.toDataURL('image/png', 1);
        var base64Data = urlData.replace(regex, "");

        window.fs.writeFile(fileName, base64Data, 'base64', callback);
      } catch (error) {
        if (error !== undefined && error !== null) {
          console.error('An error occured while saving the generated character:', error);
        }
      }
    });
  } catch (error) {
    if (error !== undefined && error !== null) {
      console.error('An error occured while saving the generated pallete character:', error);
    }
  }
};

DevHelpers.savePaperDollImage = function(bitmap, characterName) {
  if (!Utils.isNwjs()) return;

  var fs = require('fs');
  var userDocs = Managers.Storage.getUserDocs();
  const folder = Wrapper.joinFileNames(userDocs, 'OrangeSeason', 'PaperDolls');

  try {
    fs.mkdir(folder, function() {
      try{
        const fileName = Wrapper.joinFileNames(folder, characterName + '.png');
        var regex = /^data:image\/png;base64,/;

        var callback = function(error) {
          if (error !== undefined && error !== null) {
            console.error('An error occured while saving the generated character', error);
          }
        };

        var urlData = bitmap.canvas.toDataURL('image/png', 1);
        var base64Data = urlData.replace(regex, "");

        window.fs.writeFile(fileName, base64Data, 'base64', callback);
      } catch (error) {
        if (error !== undefined && error !== null) {
          console.error('An error occured while saving the generated character:', error);
        }
      }
    });
  } catch (error) {
    if (error !== undefined && error !== null) {
      console.error('An error occured while saving the generated pallete character:', error);
    }
  }
};

DevHelpers.loadAllPalleteImages = function(pattern) {
  let count = 1;
  for (let key in Managers.Palletes.palleteCharacters) {
    if (!Managers.Palletes.palleteCharacters.hasOwnProperty(key)) continue;

    if (pattern && !key.includes(pattern)) {
      continue;
    }

    setTimeout(function(key){
      console.log(key);
      Managers.Palletes.loadCharacter(key);
    }.bind(this, key), count);
    count += 100;
  }

  for (let key in Managers.Palletes.palletePortraits) {
    if (!Managers.Palletes.palletePortraits.hasOwnProperty(key)) continue;

    if (pattern && !key.includes(pattern)) {
      continue;
    }

    setTimeout(function(key){
      console.log(key);
      Managers.Palletes.loadPortrait(key);
    }.bind(this, key), count);
    count += 100;
  }

  for (let key in Managers.Palletes.palletePictures) {
    if (!Managers.Palletes.palletePictures.hasOwnProperty(key)) continue;

    if (pattern && !key.includes(pattern)) {
      continue;
    }

    setTimeout(function(key){
      console.log(key);
      Managers.Palletes.loadPicture(key);
    }.bind(this, key), count);
    count += 100;
  }
};

DevHelpers.saveAllPalleteImages = function(loadedOnly, pattern) {
  var count = 1;
  for (let key in Managers.Palletes.palleteCharacters) {
    if (!Managers.Palletes.palleteCharacters.hasOwnProperty(key)) continue;

    if (pattern && !key.includes(pattern)) {
      continue;
    }

    if (loadedOnly) {
      const cacheKey = 'pallete-' + key;
      const cache = Managers.Images.cache.getItem(cacheKey);
      if (cache) {
        console.log('saved ', key);
        DevHelpers.savePalleteImage(cache, key);
      }
    } else {
      setTimeout(function(key){
        const bitmap = Managers.Palletes.loadCharacter(key);
        bitmap.addLoadListener(function(){
          console.log('saved ', key);
          DevHelpers.savePalleteImage(bitmap, key);

          setTimeout(function(){
            bitmap.free();
          }, 500);
        });
      }.bind(this, key), count);
    }
    count += 100;
  }

  for (let key in Managers.Palletes.palletePortraits) {
    if (!Managers.Palletes.palletePortraits.hasOwnProperty(key)) continue;

    if (pattern && !key.includes(pattern)) {
      continue;
    }

    if (loadedOnly) {
      const cacheKey = 'pallete-portrait-' + key;
      const cache = Managers.Images.cache.getItem(cacheKey);
      if (cache) {
        console.log('saved ', key);
        DevHelpers.savePalleteImage(cache, key);
      }
    } else {
      setTimeout(function(key){
        const bitmap = Managers.Palletes.loadPortrait(key);
        bitmap.addLoadListener(function(){
          console.log('saved ', key);
          DevHelpers.savePalleteImage(bitmap, key);

          setTimeout(function(){
            bitmap.free();
          }, 500);
        });
      }.bind(this, key), count);
    }
    count += 100;
  }

  for (let key in Managers.Palletes.palletePictures) {
    if (!Managers.Palletes.palletePictures.hasOwnProperty(key)) continue;

    if (pattern && !key.includes(pattern)) {
      continue;
    }

    if (loadedOnly) {
      const cacheKey = 'pallete-picture-' + key;
      const cache = Managers.Images.cache.getItem(cacheKey);
      if (cache) {
        console.log('saved ', key);
        DevHelpers.savePalleteImage(cache, key);
      }
    } else {
      setTimeout(function(key){
        const bitmap = Managers.Palletes.loadPicture(key);
        bitmap.addLoadListener(function(){
          console.log('saved ', key);
          DevHelpers.savePalleteImage(bitmap, key);

          setTimeout(function(){
            bitmap.free();
          }, 500);
        });
      }.bind(this, key), count);
    }
    count += 100;
  }
};

DevHelpers.saveAllPaperDolls = function() {
  var count = 1;
  for (var key in Managers.PaperDolls.paperDolls) {
    if (!Managers.PaperDolls.paperDolls.hasOwnProperty(key)) continue;

    setTimeout(function(key){
      var bitmap = Managers.PaperDolls.loadCharacter(key);
      bitmap.addLoadListener(function(){
        DevHelpers.savePaperDollImage(bitmap, key);

        setTimeout(function(){
          bitmap.free();
        }, 500);
      });
    }.bind(this, key), count);
    count += 100;
  }
};

DevHelpers.logImage = function(canvas, text) {
  var url = canvas.toDataURL();

  var scale = 1;
  var img = new Image();

  function getBox(width, height) {
    return {
      string: "+",
      style: "font-size: 1px; padding: " + Math.floor(height/2) + "px " + Math.floor(width/2) + "px; line-height: " + height + "px;"
    };
  }

  img.onload = function() {
    var dim = getBox(this.width * scale, this.height * scale);
    if (text) {
      console.log(text);
    }
    console.log("%c" + dim.string, dim.style + "background: url(" + url + "); background-size: " + (this.width * scale) + "px " + (this.height * scale) + "px; color: transparent;");
  };

  img.src = url;
};

DevHelpers.addAllItemsToStorage = function() {
  for (var i = 0; i < $dataItems.length; i++) {
    var item = $dataItems[i];

    if (!Managers.Items.itemTypeCanBeStored(item.type)) continue;
    if (item.disabled) continue;
    if (item.type == 'tool') continue;
    if (item.type == 'seed-box') continue;
    if (item['placeholder-for']) continue;

    Managers.Items.storageContainer.gainItemId(item.id);
  }
};

DevHelpers.generateItemDatabase = function(destinationFolder) {
  const lists = {};

  for (let item of $dataItems) {
    if (!item) continue;
    if (item['placeholder-for']) continue;
    if (item.type == 'animal') continue;
    if (item.type == 'seed-box') continue;
    if (item.type == 'seed' && item.disabled) continue;
    if (!item.category) continue;

    const lines = [];
    lines.push(`# ${ Managers.Text.item(item.id) }`);
    lines.push('');

    const description = Managers.Text.itemDescription(item.id);
    if (description) {
      lines.push(description);
      lines.push('');
    }

    lines.push('## Basic Information');
    lines.push('');

    if (item.buyPrice) {
      lines.push(`- **Buy Price**: ${ Managers.Text.formatMoney(item.buyPrice) }`);
    }

    if (item.sellPrice) {
      lines.push(`- **Sell Price**: ${ Managers.Text.formatMoney(item.sellPrice) }`);
    }

    if (item.type == 'seed') {
      const cropId = item.id.replace('-seeds', '');
      const cropData = Managers.Items.getItemData(cropId);
      if (cropData) {
        lines.push(`- **Crop Name**: ${ Managers.Text.item(cropId) }`);
        if (cropData.sellPrice) {
          lines.push(`- **Crop Sell Price**: ${ Managers.Text.formatMoney(cropData.sellPrice) }`);
        }
      }

      if (item.daysToGrow) {
        lines.push(`- **Time to Grow**: ${ item.daysToGrow } days.`);

        if (item.daysToRegrow) {
          lines.push(`- **Time to Grow again**: ${ item.daysToRegrow } days.`);
        }
      }
    }

    const soldBySalesman = !item.ignoredBySalesman && !item.disabled && item.buyPrice >= 2 && item.category != 'tools' && !item.ingredients;
    lines.push(`- **Sold by Wandering Salesman**: ${ soldBySalesman ? 'YES' : 'NO'}`);

    if (item.defaultGift && item.possibleGift) {
      const giftLabel = item.defaultGift.substr(0, 1).toUpperCase() + item.defaultGift.substr(1).toLowerCase();
      lines.push(`- **Default Gift Reaction**: ${ giftLabel }`);
    }

    if (item.restores) {
      if (item.restores.stamina || item.restores.fatigue) {
        lines.push('- **Heals**:');

        if (item.restores.stamina) {
          lines.push(`  - ${ item.restores.stamina } points of Stamina`);
        }

        if (item.restores.fatigue) {
          lines.push(`  - ${ item.restores.fatigue } points of Fatigue`);
        }
      }

      if (item.restores.maxStamina) {
        lines.push(`- Increases max stamina by ${ item.restores.maxStamina } points.`);
      }
    }

    if (item.seasons) {
      lines.push('- **Seasons**:');
      for (let season of item.seasons) {
        lines.push(`  - ${ season }`);
      }
    }

    if (item.ingredients) {
      lines.push('- **Materials**:');

      const listOnly = [];
      const itemCounter = {};

      for (let ingredient of item.ingredients) {
        if (typeof ingredient == 'object') {
          if (listOnly.indexOf(ingredient.itemId) >= 0) {
            itemCounter[ingredient.itemId] += ingredient.amount;
          } else {
            listOnly.push(ingredient.itemId);
            itemCounter[ingredient.itemId] = ingredient.amount;
          }
        } else {
          if (listOnly.indexOf(ingredient) >= 0) {
            itemCounter[ingredient]++;
          } else {
            listOnly.push(ingredient);
            itemCounter[ingredient] = 1;
          }
        }
      }

      for (let item of listOnly) {
        const ingredientName = Managers.Text.item(item);
        if (itemCounter[item] > 1) {
          lines.push(`  - ${ ingredientName } x ${ itemCounter[item] }`);
        } else {
          lines.push(`  - ${ ingredientName }`);
        }
      }
    }

    if (window.$dataRecipes) {
      const recipes = [];
      for (let recipe of $dataRecipes) {
        if (!recipe) continue;
        if (recipe.itemId != item.id) continue;

        recipes.push(recipe);
      }

      if (recipes.length > 0) {
        if (recipes.length > 1) {
          lines.push('- **Recipes**:');
        } else {
          lines.push('- **Recipe**:');
        }

        let count = 0;
        for (let recipe of recipes) {
          let prefix = '  ';
          count++;

          if (recipes.length > 1) {
            lines.push(`  - Recipe ${ count }:`);
            prefix = '    ';
          }

          lines.push(`${ prefix }- **Utensil**: ${ Managers.Text.item(recipe.utensil) }`);
          lines.push(`${ prefix }- **Ingredients**:`);

          for (let ingredient of recipe.ingredients) {
            lines.push(`${ prefix }  - ${ Managers.Text.item(ingredient) }`);
          }
        }
      }
    }

    if (!lists[item.category]) {
      lists[item.category] = [];
    }
    lists[item.category].push(item.id);

    let file = lines.join('\n');
    const filePath = path.join(destinationFolder, `${ item.id }.md`);

    if (window.fs.existsSync(filePath)) {
      const existingData = window.fs.readFileSync(filePath, 'utf-8');
      if (existingData) {
        const idx = existingData.indexOf('---');
        if (idx >= 0){
          const extraContent = existingData.substr(idx);
          file += '\n\n';
          file += extraContent;
        }
      }
    }

    window.fs.writeFileSync(filePath, file);
  }

  for (let category in lists) {
    const lines = [];
    const categoryLabel = category.substr(0, 1).toUpperCase() + category.substr(1).toLowerCase();
    lines.push(`# ${ categoryLabel }`);
    lines.push('');

    for (let item of lists[category]) {
      lines.push(`- [${ Managers.Text.item(item) }](items/${ item }.md)`);
    }

    const filePath = path.join(destinationFolder, '..', `items-${category}.md`);
    window.fs.writeFileSync(filePath, lines.join('\n'));
  }
};

DevHelpers.generateVillagerBasicInformationFile = function(destinationFolder, villagerName) {
  const lines = [];

  const data = Managers.Villagers.getActorData(villagerName);
  if (!data) {
    return 'No data available';
  }

  lines.push(`# ${ villagerName }`);
  lines.push('');
  lines.push('## Family');
  lines.push('');
  lines.push('## Likes and Dislikes');
  lines.push('');
  lines.push("Any items not on those lists will be liked or disliked according to the item's default.");
  lines.push('');
  lines.push('### Loved Items');
  lines.push('');

  if (data.gifts && data.gifts.love && data.gifts.love.length) {
    for (let itemId of data.gifts.love) {
      const itemName = Managers.Text.item(itemId);
      lines.push(`- [${ itemName }](../items/${ itemId }.md)`);
    }
  } else {
    lines.push('No Info.');
  }

  lines.push('');
  lines.push('### Liked Items');
  lines.push('');

  if (data.gifts && data.gifts.like && data.gifts.like.length) {
    for (let itemId of data.gifts.like) {
      const itemName = Managers.Text.item(itemId);
      lines.push(`- [${ itemName }](../items/${ itemId }.md)`);
    }
  } else {
    lines.push('No Info.');
  }


  lines.push('');
  lines.push('### Disliked Items');
  lines.push('');

  if (data.gifts && data.gifts.dislike && data.gifts.dislike.length) {
    for (let itemId of data.gifts.dislike) {
      const itemName = Managers.Text.item(itemId);
      lines.push(`- [${ itemName }](../items/${ itemId }.md)`);
    }
  } else {
    lines.push('No Info.');
  }

  lines.push('');
  lines.push('### Hated Items');
  lines.push('');

  if (data.gifts && data.gifts.hate && data.gifts.hate.length) {
    for (let itemId of data.gifts.hate) {
      const itemName = Managers.Text.item(itemId);
      lines.push(`- [${ itemName }](../items/${ itemId }.md)`);
    }
  } else {
    lines.push('No Info.');
  }

  const filePath = path.join(destinationFolder, `${villagerName}.md`);
  window.fs.writeFileSync(filePath, lines.join('\n'));
};


DevHelpers.validateItemSeasons = function() {
  for (let item of $dataItems) {
    if (!item) {
      continue;
    }

    const id = item.id;
    const seedId = `${id}-seeds`;

    const seed = Managers.Items.getItemData(seedId);
    if (!seed) {
      continue;
    }

    if (!item.seasons) {
      console.log('Item is missing season information: ', item.id);
      continue;
    }

    if (!seed.seasons) {
      console.log('Item is missing season information: ', seed.id);
      continue;
    }

    if (item.seasons && seed.seasons) {
      if (item.seasons.length != seed.seasons.length) {
        console.log("Seasons don't match: ", item.id, seed.id);
        continue;
      }

      for (let season of item.seasons) {
        if (seed.seasons.indexOf(season) < 0) {
          console.log('Missing season', item.id, season);
        }
      }

    }
  }
};

DevHelpers.generateEmptyTranslationFile = function(destinationFolder) {
  const file = {};

  for (let language in $dataStrings) {
    const strings = $dataStrings[language];
    if (!strings) continue;

    for (let key in strings) {
      file[key] = '';
    }
  }

  const keys = Object.keys(file).sort();
  const sortedFile = {};
  for (let key of keys) {
    sortedFile[key] = '';
  }

  const json = JsonEx.stringify(sortedFile, undefined, 2);
  const yaml = YAML.stringify(sortedFile);

  window.fs.writeFileSync(Wrapper.joinFileNames(destinationFolder, 'emptyTranslation.json'), json);
  window.fs.writeFileSync(Wrapper.joinFileNames(destinationFolder, 'emptyTranslation.yaml'), yaml);
};

DevHelpers.generateDatabase = function(destinationFolder, includeVillagers) {
  const itemsFolder = Wrapper.joinFileNames(destinationFolder, 'items');
  const villagersFolder = Wrapper.joinFileNames(destinationFolder, 'villagers');
  const translationFolder = Wrapper.joinFileNames(destinationFolder, 'emptyTranslation');

  this.generateItemDatabase(itemsFolder);

  let villagers = ['Amanda', 'Annie', 'Benjamin', 'Billy', 'Bonnie', 'Brittany', 'Chloe', 'Cindy', 'Devin', 'Gabriel', 'Ilda', 'Julia', 'Karl', 'Lucas', 'Martin', 'Mia', 'Nathalia', 'Phi', 'Raphael', 'Richard', 'Rory', 'Serge', 'Stella', 'Viktor'];
  if (includeVillagers) {
    if (includeVillagers !== true) {
      villagers = includeVillagers;
    }

    for (let villagerName of villagers) {
      this.generateVillagerBasicInformationFile(villagersFolder, villagerName);
    }
  }

  this.generateEmptyTranslationFile(translationFolder);
};