require('engine/core/MVCommons');

function Creature() {
}

(function($){
  $.isEmpty = function() {
    return false;
  };

  MVC.accessor($, 'mapId');
  MVC.accessor($, 'id');
  MVC.accessor($, 'x');
  MVC.accessor($, 'y');
  MVC.accessor($, 'creatureName');
  MVC.accessor($, 'type');

  MVC.accessor($, 'homeMapId');
  MVC.accessor($, 'homeX');
  MVC.accessor($, 'homeY');

  MVC.accessor($, 'spokenTo');
  MVC.accessor($, 'age');
  MVC.accessor($, 'upsetLevel');
  MVC.accessor($, 'friendship');
  MVC.accessor($, 'timeOutside');

  $.clear = function() {
    this.creatureName = '';
    this.type = '';
    this.spokenTo = false;
    this.age = 0;
    this.upsetLevel = 0;
    this.friendship = 0;
    this.timeOutside = 0;
  };

  $.eraseEvents = function() {
    var creatureEvents = $gameMap.creaturesXy(this.x, this.y);
    for (var i = 0; i < creatureEvents.length; i++) {
      if (creatureEvents[i]) {
        creatureEvents[i].erase();
      }
    }
  };

  $.isCreatureBeingUsed = function() {
    if ($gamePlayer.isRidingAnimal(this.id)) {
      return true;
    }

    if (Managers.Items._specialItem) {
      const itemId = Managers.Items._specialItem.id;
      if (!!itemId && !!Managers.Creatures.creatureList[itemId]) {
        const animalData = Managers.Items.getItemInfo('animalData');
        if (animalData && animalData.id == this._id) {
          return true;
        }
      }
    }

    return false;
  };

  $.updateEvents = function(checkIfExists, isDroping) {
    if (checkIfExists === undefined) checkIfExists = true;
    if ($gameMap._mapId !== this.mapId) return;

    var creatureEvent;

    if (checkIfExists) {
      creatureEvent = $gameMap.creatureEvent(this.id);
    }

    const isUsed = isDroping !== true && this.isCreatureBeingUsed();

    if (creatureEvent) {
      if (isUsed) {
        creatureEvent.erase();
        return;
      }

      Managers.Creatures.updateCreatureEvent(this, creatureEvent);
    } else {
      if (isUsed) {
        return;
      }

      creatureEvent = Managers.Creatures.createCreatureEvent(this);
    }

    return creatureEvent;
  };

  $.getCreatureType = function() {
    return Managers.Creatures.getCreatureType(this.type);
  };

  $.increaseFriendshipForTheDay = function() {
    this.friendship += 20;
  };

  $.processNewDay = function() {
    if (!this.age) this.age = 0;
    if (!this.upset) this.upset = 0;

    this.age += 1;
    if (this.spokenTo) {
      this.increaseFriendshipForTheDay();
    }

    this.spokenTo = false;
    this._gotGiftToday = false;

    var type = this.getCreatureType();
    if (type) {
      type.processCreatureNewDay(this);
    }
  };

  $.processLateNewDay = function() {
    var type = this.getCreatureType();
    if (type) {
      type.processLateNewDay(this);
    }
  };


  $.actorId = function() {
    return this.id;
  };

  $.actor = function() {
    var creatureType = this.getCreatureType();
    var spriteName = creatureType.getSpriteName(this);
    var spriteIndex = creatureType.getSpriteIndex(this);
    var hitbox = creatureType.getHitbox(this);
    var offset = creatureType.getOffset(this);

    return {
      id : this.id,
      characterIndex : spriteIndex,
      characterName : spriteName,
      name : this.creatureName,
      hitboxX : hitbox.hitboxX,
      hitboxY : hitbox.hitboxY,
      hitboxHeight : hitbox.hitboxHeight,
      hitboxWidth : hitbox.hitboxWidth,
      offsetX : offset.x,
      offsetY : offset.y
    };
  };

  $.name = function() {
    return this.creatureName;
  };

  $.setName = function(name) {
    this.creatureName = name;
  };

  $.characterName = function() {
    var creatureType = this.getCreatureType();
    return creatureType.getSpriteName(this);
  };

  $.characterIndex = function() {
    var creatureType = this.getCreatureType();
    return creatureType.getSpriteIndex(this);
  };

  $.index = function() {
    return $gameParty.members().indexOf(this);
  };

  $.onPlayerWalk = function() {

  };

  $.increaseTimeOutside = function() {
    this.timeOutside++;
    this.increaseFriendshipForBeingOutside();
  };

  $.increaseFriendshipForBeingOutside = function() {
    if (Managers.Weather.isBadWeather()) {
      this.friendship -= 0.02;
    } else {
      this.friendship += 0.02;
    }
  };

  $.onChangeTime = function() {
    if (!this.timeOutside) {
      this.timeOutside = 0;
    }

    // If it is a named creature and is currently on the farm map, increase the timeoutside flag
    if (this.creatureName) {
      if (Managers.Map.mapIsFarm(this.mapId)) {
        this.increaseTimeOutside();
      }
    }
  };

  $.clear();
})(Creature.prototype);

module.exports = Creature;