/* eslint no-unused-vars: 0 */

var Constants = {};

Constants.MAGIC_SLEEP_FACTOR = 5;
Constants.COOP_MAX_BIRDS = 14;
Constants.STONE_ANIMATION_ID = 2;
Constants.STUMP_ANIMATION_ID = 2;
Constants.WEED_ANIMATION_ID_UP = 3;
Constants.WEED_ANIMATION_ID_DOWN = 4;
Constants.WEED_ANIMATION_ID_LEFT = 5;
Constants.WEED_ANIMATION_ID_RIGHT = 6;
Constants.TELEPORT_ANIMATION = 7;
Constants.THUNDER_ANIMATION = 8;

Constants.FRIENDSHIP_FOR_UNIQUE_CHAT = 30;

Constants.MAX_EVENT_DISTANCE_MOUSE_OVER = 1;
Constants.ANIMATE_PROGRESS_BAR = false;

Constants.TILE_SIZE = 32;
Constants.WHEELTHRESHOLD = 20;
Constants.EVENT_BALLOON_DISTANCE = 2;
Constants.SHADOW_ICON = 432;

Constants.NEW_MAIL_ICON = 178;
Constants.BALLOON_HEIGHT = 47;
Constants.BALLOON_WIDTH = 47;

Constants.UNKNOWN_RECIPE_ICON = 550;

Constants.DUKE_MIN_DAY = 29;
Constants.DUKE_MAX_DAY = 65;

var Achievements = {
  FIRST_DATE : 'FIRST_DATE',
  SHIP_EVERYTHING : 'SHIP_EVERYTHING',
  GET_IRON_SICKLE : 'GET_IRON_SICKLE',
  GET_IRON_HAMMER : 'GET_IRON_HAMMER',
  GET_IRON_AXE : 'GET_IRON_AXE',
  GET_FISHING_ROD : 'GET_FISHING_ROD',
  FISH_1000 : 'FISH_1000',
  FISH_10000 : 'FISH_10000',
  EARN_GOLD_1 : 'EARN_GOLD_1',
  EARN_GOLD_2 : 'EARN_GOLD_2',
  EARN_GOLD_3 : 'EARN_GOLD_3',
  HARVEST_1 : 'HARVEST_1',
  HARVEST_100 : 'HARVEST_100',
  HARVEST_1000 : 'HARVEST_1000',
  HARVEST_10000 : 'HARVEST_10000',
  HARVEST_100000 : 'HARVEST_100000',
  SHIP_EVERY_CROP : 'SHIP_EVERY_CROP',
  SHIP_EVERY_CROP_50 : 'SHIP_EVERY_CROP_50',
  SHIP_EVERY_CROP_500 : 'SHIP_EVERY_CROP_500',
  REACH_SUMMER : 'REACH_SUMMER',
  REACH_FALL : 'REACH_FALL',
  REACH_WINTER : 'REACH_WINTER',
  REACH_YEAR_2 : 'REACH_YEAR_2',
  FIND_GOLDEN_ORANGES : 'FIND_GOLDEN_ORANGES',
  COMPLETE_TASK : 'COMPLETE_TASK',
  COMPLETE_50_TASKS : 'COMPLETE_50_TASKS',
  COMPLETE_100_TASKS : 'COMPLETE_100_TASKS',
  GET_A_ROOSTER : 'GET_A_ROOSTER'
};


var DayPeriods = {
  EARLY_MORNING: 1,
  DAY: 2,
  EVENING: 3,
  NIGHT: 4
};

var Days = {
  SUNDAY : 0,
  MONDAY : 1,
  TUESDAY : 2,
  WEDNESDAY : 3,
  THURSDAY : 4,
  FRIDAY : 5,
  SATURDAY : 6
};

// Managers.CommonEvent.possibleBalloons
var Balloons = {
  EXCLAMATION : 1,
  QUESTION : 2,
  MUSIC : 3,
  HEART : 4,
  ANGER : 5,
  DROP : 6,
  WEB : 7,
  SILENCE : 8,
  LIGHT : 9,
  SLEEP : 10,
  CRY: 11,
  ITEM: 12,
  THINKING: 13,
  QUICK_ITEM: 14,
  FULL_BACKPACK: 15,
  FAILURE: 16,
  TALKING: 17,
  SECRET: 18
};

var TerrainTags = {
  GRASS : 1,
  SOIL : 2,
  ROAD : 3,
  SNOW : 4,
  ICE : 5,
  WATER : 6,
  SAND : 7
};

var Festivals = {
  FLOWER: 9,
  CHICKEN : 18,
  TOMATO : 59,
  CANDY : 102
};

var DayDescriptions = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];

var Seasons = {
  SPRING : 1,
  SUMMER : 2,
  FALL : 3,
  WINTER : 4
};

var WeatherType = {
  SUN : 0,
  RAIN : 1,
  SNOW : 2,
  STORM : 3,
  SNOWSTORM : 4,
  HEAT : 5
};

var Birthdays = {
  RICHARD: 21,
  ANNIE: 27,
};

var WeatherIcons = {};
WeatherIcons[WeatherType.SUN] = 311;
WeatherIcons[WeatherType.RAIN] = 312;
WeatherIcons[WeatherType.SNOW] = 320;
WeatherIcons[WeatherType.STORM] = 314;

Constants.FarmObjectState = {
  ITEM : -1,
  NONE : 0,
  TILLED_SOIL : 2,
  SPOILED_SEED : 3,
  SPOILED_CROP : 4,
  DEAD_TREE : 'dead-tree',

  
  WEED : 'weed',
  SMALL_WEED : 'small-weed',
  LOG : 'treeLog',
  STUMP : 'stump',
  FALLEN_TREE: 'fallen-tree',
  STONE : 'stone',
  BOULDER : 'boulder',
  TERMITE_NEST: 'termite-nest',
  DIRT: 'dirt',

  MINING_ROCK : 30,

  GRASS: 'grass',
  GRASS_CENTER : 'grass-center',
  GRASS_LEFT : 'grass-left',
  GRASS_TOP : 'grass-top',
  GRASS_TOP_LEFT : 'grass-top-left',
  GRASS_TOP_RIGHT : 'grass-top-right',
  GRASS_LEFT_ONLY : 'grass-left-only',
  GRASS_BOTTOM : 'grass-bottom',
  GRASS_BOTTOM_LEFT : 'grass-bottom-left',
  GRASS_BOTTOM_RIGHT : 'grass-bottom-right',
  GRASS_RIGHT_ONLY : 'grass-right-only',
  GRASS_TOP_ONLY : 'grass-top-only',
  GRASS_BOTTOM_ONLY : 'grass-bottom-only',
  GRASS_RIGHT : 'grass-right',
  GRASS_VERTICAL : 'grass-vertical',
  GRASS_HORIZONTAL : 'grass-horizontal',

  NEW_GRASS : 'new-grass',

  BARN : 'barn',
  COOP : 'coop',

  NEW_FENCE : 'fence',

  FENCE : 'fence',
  FENCE_HORIZONTAL : 'fence-horizontal',
  FENCE_TOP_LEFT : 'fence-top-left',
  FENCE_TOP_RIGHT : 'fence-top-right',
  FENCE_VERTICAL : 'fence-vertical',
  FENCE_UP : 'fence-up',
  FENCE_DOWN : 'fence-down',
  // This fence is on the left side of another fence
  FENCE_LEFT : 'fence-left',
  FENCE_RIGHT : 'fence-right',
  FENCE_BOTTOM_LEFT : 'fence-bottom-left',
  FENCE_BOTTOM_RIGHT : 'fence-bottom-right',
  FENCE_HORIZONTAL_UP : 'fence-horizontal-up',
  FENCE_HORIZONTAL_DOWN : 'fence-horizontal-down',
  FENCE_VERTICAL_LEFT : 'fence-vertical-left',
  FENCE_VERTICAL_RIGHT : 'fence-vertical-right',
  FENCE_CENTER : 'fence-center',

  GATE : 'gate',
  GATE_VERTICAL : 'gate-vertical',

  SEED : 1000,
  SMALL_CROP : 1001,
  MEDIUM_CROP : 1002,
  BIG_CROP : 1003,
  HAVING_FRUIT : 'having-fruit',

  BUTTON : 'button',
  BUTTON_PRESSED : 'button-pressed',
  CHEST : 'chest',
  SPRINKLER : 'sprinkler',
  SUPER_SPRINKLER: 'super-sprinkler'
};

var FarmObjectState = Constants.FarmObjectState;

Constants.Direction = {
  LEFT : 4,
  RIGHT : 6,
  UP : 8,
  DOWN : 2,
  UP_LEFT: 7,
  UP_RIGHT: 9,
  DOWN_LEFT: 1,
  DOWN_RIGHT: 3
};

var Direction = Constants.Direction;
var UP = Direction.UP;
var DOWN = Direction.DOWN;
var RIGHT = Direction.RIGHT;
var LEFT = Direction.LEFT;

var Region = {
  BLOCKED_MOVEMENT : 1,
  STAIR_TILES : 2,
  BLOCK_ANIMALS : 3,
  BLOCK_FISHING_ON_WINTER : 4,
  PLACEHOLDER : 5,

  RARE_SHINY_ITEM : 6,
  COMMON_SHINY_ITEM : 7,
  
  SUPER_BLOCKED_MOVEMENT : 8,

  // JUMP_UP : 2,
  // JUMP_LEFT : 4,
  // JUMP_RIGHT: 6,
  // JUMP_DOWN : 8,
  // JUMP_UP_LEFT : 24,
  // JUMP_UP_RIGHT : 26,
  // JUMP_UP_DOWN : 28,
  // JUMP_LEFT_RIGHT : 46,
  // JUMP_DOWN_LEFT : 84,
  // JUMP_DOWN_RIGHT : 86,


  PROTECTED : 21,
  BRIDGE : 22,
  SUPER_PROTECTED : 23,
  BLOCK_FISHING : 24,
  SACI: 25,

  
  ROCK_ON_STARTUP : 30,
  STUMP_ON_STARTUP : 31,
  WEEDS_ON_STARTUP : 32,
  GRASS_ON_STARTUP : 33,
  TREE_ON_STARTUP_BACKWARD_COMPATIBILITY : 34,
  
  LOG_ON_STARTUP : 36,
  DESERT_TREE_ON_STARTUP : 37,
  BOULDER_ON_STARTUP : 38,

  ROCK1_ON_STARTUP : 39,
  ROCK2_ON_STARTUP : 40,
  ROCK3_ON_STARTUP : 41,
  ROCK4_ON_STARTUP : 42,

  THICK_WEEDS_ON_STARTUP : 43,
  LIGHT_THICK_WEEDS_ON_STARTUP : 44,

  FALLEN_TREE_ON_STARTUP : 45,

  // water corner - diagonally blocked (bottom/left side is blocked, top/right side is free)
  COLLISION_BOX_1: 50,
  // water corner - diagonally blocked (bottom/right side is blocked, top/left side is free)
  COLLISION_BOX_2: 51,
  // water corner - diagonally blocked (top/left side is blocked, bottom/right side is free)
  COLLISION_BOX_3: 52,
  // water corner - diagonally blocked (top/right side is blocked, bottom/left side is free)
  COLLISION_BOX_4: 53,
  // mountain corner - diagonally blocked (bottom/left side is blocked, top/right side is free)
  COLLISION_BOX_5: 54,
  // mountain corner - diagonally blocked (bottom/right side is blocked, top/left side is free)
  COLLISION_BOX_6: 55,
  // water corner (EXCEPT WINTER) - diagonally blocked (bottom/left side is blocked, top/right side is free)
  COLLISION_BOX_7: 56,
  // water corner (EXCEPT WINTER) - diagonally blocked (bottom/right side is blocked, top/left side is free)
  COLLISION_BOX_8: 57,
  // water corner (EXCEPT WINTER)- diagonally blocked (top/left side is blocked, bottom/right side is free)
  COLLISION_BOX_9: 58,
  // water corner (EXCEPT WINTER) - diagonally blocked (top/right side is blocked, bottom/left side is free)
  COLLISION_BOX_10: 59,

  // wall ground - block a small corner on the top left
  COLLISION_BOX_11: 60,
  // wall ground - block a small corner on the top right
  COLLISION_BOX_12: 61,

  ONE_TIME_BUTTON : 107,
  NO_PLAYER_BUTTON : 108,
  INVISIBLE_BUTTON : 109,
  BUTTON : 110,
  OPEN_BARREL : 111,
  CLOSED_BARREL : 112,
  BOX : 113,

  RASPBERRY_BUSH_ON_STARTUP : 114,
  DAILY_RUINS_ITEM : 115,

  BENJAMINS_FARM : 151,
  MIAS_FARM : 152,
  NATHALIAS_FARM : 153,
  DEVINS_FARM : 154,
  SERGES_FARM : 155,
  BONNIES_FARM : 156,
  LUCAS_FARM : 157,
  JULIAS_FARM : 158,
  SOMEONES_FARM_5 : 159,
  BRITTANYS_FARM : 160,
  SOMEONES_FARM_7 : 161,
  SOMEONES_FARM_8 : 162,
  SOMEONES_FARM_9 : 162,
  SOMEONES_FARM_10 : 163,
  SOMEONES_FARM_11 : 164,
  SOMEONES_FARM_12 : 165,
  SOMEONES_FARM_13 : 167,
  TOWN_TREE : 168,
  TOWN_ORANGE_TREE : 169,
  TOWN_FARM : 170,

  GREEN_TREE_ON_STARTUP : 171,
  PINK_TREE_ON_STARTUP : 172,
  BLUE_TREE_ON_STARTUP : 173,
  HIGHER_GREEN_TREE_ON_STARTUP : 174,

  MEDIUM_GREEN_TREE_ON_STARTUP : 176,
  MEDIUM_PINK_TREE_ON_STARTUP : 177,
  MEDIUM_BLUE_TREE_ON_STARTUP : 178,
  HIGHER_MEDIUM_GREEN_TREE_ON_STARTUP : 179,

  SMALL_GREEN_TREE_ON_STARTUP : 181,
  SMALL_PINK_TREE_ON_STARTUP : 182,
  SMALL_BLUE_TREE_ON_STARTUP : 183,
  HIGHER_SMALL_GREEN_TREE_ON_STARTUP : 184,

  IPE_TREE: 185,

  DAILY_FALLEN_TREE : 189,
  MEDIUM_TREE_ON_STARTUP: 190,
  GIANT_TREE_ON_STARTUP: 191,
  CLAY_ROCK_ON_STARTUP : 192,
  DAILY_SILVER_ROCK : 193,
  DAILY_STICK : 194,
  DAILY_GOLD_MINE_ITEM : 195,
  RANDOM_GOLD_MINE_ITEM : 196,

  GRASSY_FARM : 197,
  BLACKBERRY_BUSH_ON_STARTUP : 198,
  DAILY_BEACH_ITEM : 199,

  FARM_NEW_GRASS : 200,

  DAILY_ITEM : 201,
  RANDOM_ITEM : 202,

  DAILY_GOOD_ITEM : 203,
  RANDOM_GOOD_ITEM : 204,

  DAILY_BAD_ITEM : 205,
  RANDOM_BAD_ITEM : 206,

  DAILY_CAVE_ITEM : 207,
  RANDOM_CAVE_ITEM : 208,

  DAILY_FLOWER : 209,

  // 10% Iron, 20% Clay, 70% Stone
  DAILY_MINE_LEVEL_0 : 210,
  // 15% Copper, 25% Clay, 46% Stone, 14% Nothing
  DAILY_MINE_LEVEL_1 : 211,
  // 17% Silver (1% blue, 98% normal), 16% Copper (4% blue, 96% normal), 18% Clay, 49% Nothing
  DAILY_MINE_LEVEL_2 : 212,
  // 30% Silver, 20% Copper, 60% Nothing
  DAILY_MINE_LEVEL_3 : 213,
  // 10% Gold, 10% Clay
  DAILY_MINE_LEVEL_4 : 214,
  // 1% Ruby, 15% Gold
  DAILY_MINE_LEVEL_5 : 215,
  // 10% Ruby, 6% Gold, 100% reason to remember the mine
  DAILY_MINE_LEVEL_6 : 216,
  // 2% Sapphire
  DAILY_MINE_LEVEL_7 : 217,
  
  // 5% Emerald
  DAILY_MINE_LEVEL_8 : 218,
  // 30% blue copper
  DAILY_MINE_LEVEL_9 : 219,
  // 30% blue silver
  DAILY_MINE_LEVEL_10 : 220,

  DAILY_MINE_LEVEL_11 : 221,
  DAILY_MINE_LEVEL_12 : 222,
  DAILY_MINE_LEVEL_13 : 223,
  DAILY_MINE_LEVEL_14 : 224,
  DAILY_MINE_LEVEL_15 : 225,
  DAILY_MINE_LEVEL_16 : 226,
  DAILY_MINE_LEVEL_17 : 227,
  DAILY_MINE_LEVEL_18 : 228,
  DAILY_MINE_LEVEL_19 : 229,

  DAILY_ROCK : 230,
  DAILY_LOG : 231,
  DAILY_WEED : 232,
  DAILY_GRASS : 233,
  DAILY_STUMP : 234,
  
  DAILY_CLAY_ROCK : 235,
  RANDOM_CLAY_ROCK : 236,
  DAILY_IRON_ROCK : 237,
  RANDOM_IRON_ROCK : 238,
  
  RANDOM_TERMITE_NEST : 239,
  DAILY_TERMITE_NEST : 240,

  TREE_ON_STARTUP : 241,
  COCONUT_TREE_ON_STARTUP : 242,
  FARM_NON_EMPTY : 243,
  FARM_OBSTACLE : 244,

  FARM_FLOWER : 245,

  FARM_EMPTY : 246,
  FARM_ROCK : 247,
  FARM_FRUIT_TREE : 248,
  FARM_WEEDS : 249,
  FARM_GRASS : 250,

  ORANGE_TREE_ON_STARTUP : 251,
  APPLE_TREE_ON_STARTUP : 252,
  DEAD_TREE_ON_STARTUP : 253,
  PEACH_TREE_ON_STARTUP : 254,
  FARM : 255
};

var Maps = {
  MOUNTAIN: 2,
  HOME : 3,
  FARM : 4,
  BLACKSMITH : 5,
  EXPANDED_COOP: 6,
  CLINIC : 7,
  LIBRARY : 8,
  BARN : 9,
  EXPANDED_BARN : 10,
  RACE_TRACKS : 11,
  BRITTANYS_FARM : 12,
  
  INTRO : 14,
  FOREST : 15,
  PATH_TO_WINTER_FIELDS : 16,
  SMALL_CAVE : 17,
  HOME_3 : 19,
  HOME_2 : 20,
  RESTAURANT : 21,
  CITY_HALL : 22,
  FESTIVAL_RECEPTION : 23,
  SPRING_FLOWERS: 24,

  GENERAL_STORE : 25,
  WAR_GROUNDS : 26,
  ORANGE_TOWN : 27,

  MOUNTAIN_TOP : 28,

  PATH_TO_SUMMER_FIELD : 30,
  SPRING_FIELDS : 31,
  INN : 32,
  FARM_CENTER : 33,

  MAIN_MINE: 34,
  MINE_LEVEL_2: 35,

  BEACH: 36,
  PETTING_ZOO: 37,
  HOME_3B: 38,

  ANIMAL_CAMP: 40,

  FOREST_CENTER : 41,
  WORLD: 42,
  TRAIN_STATION_CAVE : 43,
  CARPENTER_HOUSE : 44,
  MAZE : 45,
  MOUNTAIN_S_SMALL_CAVE: 46,
  CAVEPATH_TO_FALLFIELDS : 47,
  FOREST_S : 48,
  PATH_TO_RUINS : 49,
  RORYS_FARM : 50,
  GOLD_MINE : 51,
  BENJAMINS_HOUSE : 52,

  ANIMAL_CLINIC : 53,
  MIAS_HOUSE : 53,

  LUCAS_HOUSE : 54,
  BLACKSMITH_ROOMS : 55,
  DUKES_HOUSE: 56,
  CAVE_FARM : 57,  
  AMANDAS_HOUSE : 58,
  ILDAS_HOUSE : 59,
  GABRIELS_HOUSE : 60,
  KARLS_HOUSE : 61,
  
  COOP : 66,
  SUMMER_AREA : 89,
  WINTER_FARM : 91,
  FALL_FIELDS : 96,
};

// Used on schedule files and on teleport commands
var MapAlias = {
  HOUSE: 3,
  COOP2: 6,
  BARN2: 10,
  TRACKS: 11,
  BRITTANY: 12,
  WINTER_CAVE: 16,
  SMALL_CAVE: 17,
  HOUSE3: 19,
  HOUSE2: 20,
  JULIA: 22,
  FESTIVAL: 23,
  FLOWER_FESTIVAL: 24,
  STORE: 25,
  WAR: 26,
  TOWN: 27,
  SUMMER_CAVE: 29,
  SPRING_FIELD: 31,
  MINE: 34,
  MINE2: 35,
  ZOO: 37,
  HOUSE3B: 38,
  TRAIN_CAVE: 43,
  RAPHAEL: 44,
  SOUTH_SMALL_CAVE: 46,
  FALL_CAVE: 47,
  FOREST_SOUTH: 48,
  RUBY_MINE: 49,
  RORY: 50,
  BENJAMIN: 52,
  MIA: 53,
  LUCAS: 54,
  VIKTOR: 55,
  DUKE: 56,
  MUSHROOM: 57,
  AMANDA: 58,
  ILDA: 59,
  GABRIEL: 60,
  KARL: 61,
  COOP: 66,
  SUMMER_FIELD: 89,
  WINTER_FIELD: 91,
  FALL_FIELD: 96
};


var InsideFarmMaps = [
  Maps.CAVE_FARM
];

var PlayerFarmMaps = [
  Maps.FARM,
  Maps.FARM_CENTER,
  Maps.CAVE_FARM,
  Maps.SUMMER_AREA,
  Maps.WINTER_FARM,
  Maps.SPRING_FIELDS,
  Maps.FALL_FIELDS
];

var EventTriggers = {
  ACTION_BUTTON: 0,
  PLAYER_TOUCH: 1, //Disabled
  EVENT_TOUCH: 2, //Disabled
  AUTORUN: 3,
  PARALLEL: 4
};

var EventPriorities = {
  UNDER_PLAYER: 0,
  NORMAL: 1,
  OVER_PLAYER: 2,
  FLYING: 5,
};


Constants.FAILED_MOVEMENT_DELAY = 30;
Constants.LIGHTMASK_TINTSPEED = 0.5;
Constants.LIGHTMASK_FRAMEDELAY = 5;

// Those may be changed 
Constants.MESSAGE_WINDOW_OPACITY = 255;
Constants.MESSAGE_WINDOW_FONT_SIZE = 34;
Constants.MESSAGE_WINDOW_OLD_FONT_SIZE = 28;

Constants.MESSAGE_WINDOW_TEST_IGNORE_CHARS = ['$', '.', '|', '!', '>', '<', '^'];
Constants.MESSAGE_WINDOW_CURSOR_ZOOM = 0.01;

var LightSystem = {
  lightColors : {
    inside : [
      '#FFFFFF'
    ],

    cave : [
      '#333377',
      '#333377',
      '#333377',
      '#333377',
      '#333377',
      '#444488',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#7766AA',
      '#665599',
      '#444488',
      '#444488',
      '#333377',
      '#333377'
    ],

    outside : [
      '#333377',
      '#333377',
      '#333377',
      '#333377',
      '#333377',
      '#444444',
      '#AAAABB',
      '#EEEEEE',
      '#EEEEEE',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#FFFFFF',
      '#EEEEEE',
      '#AAAABB',
      '#7766AA',
      '#444488',
      '#333377',
      '#333377'
    ]
  }
};

var WindowSizes = {
  DEFAULT_WIDTH : 1280,
  DEFAULT_HEIGHT : 720
};

var TaskStatus = {
  NONE : 0,
  AVAILABLE : 1,
  ACCEPTED : 2,
  COMPLETED : 3,
  CANCELED : 4,
  FAILED : 5,
  DISABLED : 6
};

var Events = {
  FIRST_DAY : 1
};

var Tilesets = {
  SPRING : 1,
  SUMMER : 2,
  FALL : 3,
  WINTER : 4,
  ETERNAL_SPRING : 5,
  ETERNAL_SUMMER : 6,
  ETERNAL_FALL : 7,
  ETERNAL_WINTER : 8,

  TITLE : 17,
  COOP : 18,
  BARN : 19,
  CAVES : 20,

  LIBRARY : 21,
  RESTAURANT : 22,
  CLINIC: 23,
  STORE: 24,
  CARPENTER: 25,
  PLAYERHOUSE: 26,
  RANCH: 27,
  BLACKSMITH: 28
};

var HouseTilesets = [
  Tilesets.LIBRARY,
  Tilesets.RESTAURANT,
  Tilesets.CLINIC,
  Tilesets.STORE,
  Tilesets.CARPENTER,
  Tilesets.PLAYERHOUSE,
  Tilesets.RANCH,
  Tilesets.BLACKSMITH,
  Tilesets.BARN,
  Tilesets.COOP,
];

var InsideTilesets = [
  Tilesets.CAVES,
  Tilesets.BARN,
  Tilesets.COOP,
].concat(HouseTilesets);

var LATIN1 =
    [ 'A','B','C','D','E',  'a','b','c','d','e',
      'F','G','H','I','J',  'f','g','h','i','j',
      'K','L','M','N','O',  'k','l','m','n','o',
      'P','Q','R','S','T',  'p','q','r','s','t',
      'U','V','W','X','Y',  'u','v','w','x','y',
      'Z','[',']','^','_',  'z','{','}','|','~',
      '0','1','2','3','4',  '!','#','$','%','&',
      '5','6','7','8','9',  '(',')','*','+','-',
      '/','=','@','<','>',  ':',';',' ','Page','OK' ];
var LATIN2 =
    [ 'Á','É','Í','Ó','Ú',  'á','é','í','ó','ú',
      'À','È','Ì','Ò','Ù',  'à','è','ì','ò','ù',
      'Â','Ê','Î','Ô','Û',  'â','ê','î','ô','û',
      'Ä','Ë','Ï','Ö','Ü',  'ä','ë','ï','ö','ü',
      'Ā','Ē','Ī','Ō','Ū',  'ā','ē','ī','ō','ū',
      'Ã','Å','Æ','Ç','Ð',  'ã','å','æ','ç','ð',
      'Ñ','Õ','Ø','Š','Ŵ',  'ñ','õ','ø','š','ŵ',
      'Ý','Ŷ','Ÿ','Ž','Þ',  'ý','ÿ','ŷ','ž','þ',
      'Ĳ','Œ','ĳ','œ','ß',  '«','»',' ','Page','OK' ];
var RUSSIA =
    [ 'А','Б','В','Г','Д',  'а','б','в','г','д',
      'Е','Ё','Ж','З','И',  'е','ё','ж','з','и',
      'Й','К','Л','М','Н',  'й','к','л','м','н',
      'О','П','Р','С','Т',  'о','п','р','с','т',
      'У','Ф','Х','Ц','Ч',  'у','ф','х','ц','ч',
      'Ш','Щ','Ъ','Ы','Ь',  'ш','щ','ъ','ы','ь',
      'Э','Ю','Я','^','_',  'э','ю','я','%','&',
      '0','1','2','3','4',  '(',')','*','+','-',
      '5','6','7','8','9',  ':',';',' ','','OK' ];
var JAPAN1 =
    [ 'あ','い','う','え','お',  'が','ぎ','ぐ','げ','ご',
      'か','き','く','け','こ',  'ざ','じ','ず','ぜ','ぞ',
      'さ','し','す','せ','そ',  'だ','ぢ','づ','で','ど',
      'た','ち','つ','て','と',  'ば','び','ぶ','べ','ぼ',
      'な','に','ぬ','ね','の',  'ぱ','ぴ','ぷ','ぺ','ぽ',
      'は','ひ','ふ','へ','ほ',  'ぁ','ぃ','ぅ','ぇ','ぉ',
      'ま','み','む','め','も',  'っ','ゃ','ゅ','ょ','ゎ',
      'や','ゆ','よ','わ','ん',  'ー','～','・','＝','☆',
      'ら','り','る','れ','ろ',  'ゔ','を','　','カナ','決定' ];
var JAPAN2 =
    [ 'ア','イ','ウ','エ','オ',  'ガ','ギ','グ','ゲ','ゴ',
      'カ','キ','ク','ケ','コ',  'ザ','ジ','ズ','ゼ','ゾ',
      'サ','シ','ス','セ','ソ',  'ダ','ヂ','ヅ','デ','ド',
      'タ','チ','ツ','テ','ト',  'バ','ビ','ブ','ベ','ボ',
      'ナ','ニ','ヌ','ネ','ノ',  'パ','ピ','プ','ペ','ポ',
      'ハ','ヒ','フ','ヘ','ホ',  'ァ','ィ','ゥ','ェ','ォ',
      'マ','ミ','ム','メ','モ',  'ッ','ャ','ュ','ョ','ヮ',
      'ヤ','ユ','ヨ','ワ','ン',  'ー','～','・','＝','☆',
      'ラ','リ','ル','レ','ロ',  'ヴ','ヲ','　','英数','決定' ];
var JAPAN3 =
    [ 'Ａ','Ｂ','Ｃ','Ｄ','Ｅ',  'ａ','ｂ','ｃ','ｄ','ｅ',
      'Ｆ','Ｇ','Ｈ','Ｉ','Ｊ',  'ｆ','ｇ','ｈ','ｉ','ｊ',
      'Ｋ','Ｌ','Ｍ','Ｎ','Ｏ',  'ｋ','ｌ','ｍ','ｎ','ｏ',
      'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ',  'ｐ','ｑ','ｒ','ｓ','ｔ',
      'Ｕ','Ｖ','Ｗ','Ｘ','Ｙ',  'ｕ','ｖ','ｗ','ｘ','ｙ',
      'Ｚ','［','］','＾','＿',  'ｚ','｛','｝','｜','～',
      '０','１','２','３','４',  '！','＃','＄','％','＆',
      '５','６','７','８','９',  '（','）','＊','＋','－',
      '／','＝','＠','＜','＞',  '：','；','　','かな','決定' ];

var Routes = {
  ROUTE_END : 0,
  ROUTE_MOVE_DOWN : 1,
  ROUTE_MOVE_LEFT : 2,
  ROUTE_MOVE_RIGHT : 3,
  ROUTE_MOVE_UP : 4,
  ROUTE_MOVE_LOWER_L : 5,
  ROUTE_MOVE_LOWER_R : 6,
  ROUTE_MOVE_UPPER_L : 7,
  ROUTE_MOVE_UPPER_R : 8,
  ROUTE_MOVE_RANDOM : 9,
  ROUTE_MOVE_TOWARD : 10,
  ROUTE_MOVE_AWAY : 11,
  ROUTE_MOVE_FORWARD : 12,
  ROUTE_MOVE_BACKWARD : 13,
  ROUTE_JUMP : 14,
  ROUTE_WAIT : 15,
  ROUTE_TURN_DOWN : 16,
  ROUTE_TURN_LEFT : 17,
  ROUTE_TURN_RIGHT : 18,
  ROUTE_TURN_UP : 19,
  ROUTE_TURN_90D_R : 20,
  ROUTE_TURN_90D_L : 21,
  ROUTE_TURN_180D : 22,
  ROUTE_TURN_90D_R_L : 23,
  ROUTE_TURN_RANDOM : 24,
  ROUTE_TURN_TOWARD : 25,
  ROUTE_TURN_AWAY : 26,
  ROUTE_SWITCH_ON : 27,
  ROUTE_SWITCH_OFF : 28,
  ROUTE_CHANGE_SPEED : 29,
  ROUTE_CHANGE_FREQ : 30,
  ROUTE_WALK_ANIME_ON : 31,
  ROUTE_WALK_ANIME_OFF : 32,
  ROUTE_STEP_ANIME_ON : 33,
  ROUTE_STEP_ANIME_OFF : 34,
  ROUTE_DIR_FIX_ON : 35,
  ROUTE_DIR_FIX_OFF : 36,
  ROUTE_THROUGH_ON : 37,
  ROUTE_THROUGH_OFF : 38,
  ROUTE_TRANSPARENT_ON : 39,
  ROUTE_TRANSPARENT_OFF : 40,
  ROUTE_CHANGE_IMAGE : 41,
  ROUTE_CHANGE_OPACITY : 42,
  ROUTE_CHANGE_BLEND_MODE : 43,
  ROUTE_PLAY_SE : 44,
  ROUTE_SCRIPT : 45,
};


Constants.Weather = {
  // Duration until the next thunderflash. (Adjusted based on Power)
  ThunderWait : 300,
  // Deviate wait time up to X value until the next thunderflash.
  ThunderWaitVariation: 45,

  // Flash the screen and play a sound effect occasionally during Storm.
  StormThunder: true,

  // Strength of the screen flash played when a thunderflash occurs.
  ThunderFlash: 180,

  // Deviate flash power up to X value when a thunderflash occurs.
  ThunderFlashVariation: 50,

  // Controls how long a raindrop should last during Rain.
  RaindropLifetime : 5,
  // Deviate raindrop sizes up to X% during Rain. (No effect when not using an image.)
  RainSizeVariation : 20,
  // Controls the base angle at which raindrops fall during Rain. (-60 to 60)
  RainAngleC: 9,
  // Deviate raindrop angle up to X degrees during Rain. (4 is +-4°) (0 to 180)
  RainAngleV: 4,
  // Controls the opacity of raindrops during Rain.
  RainAlphaC: 180,
  // Deviate raindrop opacity up to X value during Rain. (60 is +-60 opacity)
  RainAlphaV: 60,
  // Controls the speed of a raindrop during Rain.
  RainSpeed: 35,


  StormLifetime: 2,
  StormSizeV: 33,
  StormAngleC: 18,
  StormAngleV: 12,
  StormAlphaC: 210,
  StormAlphaV: 125,
  StormSpeed: 75,

  SnowLifetime: 32,
  SnowSizeV: 40,
  SnowAlphaC: 220,
  SnowAlphaV: 20,
  SnowSpeedC: 25,
  SnowSpeedV: 10,

  LeafLifetime: 80,
  LeafSizeV: 32,
  LeafSpeedC: 3,
  LeafSpeedV: 2,

  HeatLifetime: 33,
  HeatSizeV: 40,
  HeatSpeedV: 25,

  ShineLifetime: 25,
  ShineSizeV : 80,
  ShineAlphaC : 220,
  ShineAlphaV : 20
};

Constants.FriendshipLevels = [
  350,
  700,
  1100,
  1600,
  2250,
  3100,
  4100,
  5200,
  6500,
  8000
];

module.exports = Constants;