const Window_Base = require('engine/windows/Window_Base');

//-----------------------------------------------------------------------------
// Window_Title
//
// base window for Window_Help and similar simple windows

class Window_Title extends Window_Base {
  initialize(x, y, width, numLines, lineHeight, align) {
    if (lineHeight === undefined) lineHeight = 36;
    this._lineHeight = lineHeight;

    if (align) this._textAlign = align;

    const height = this.fittingHeight(numLines || 2);
    super.initialize(x, y, width, height);
    this._text = '';
  }

  lineHeight() {
    return this._lineHeight || 36;
  }

  setText(text) {
    if (this._text !== text) {
      this._text = text;
      this.refresh();
    }
  }

  clear() {
    this.setText('');
  }

  refresh() {
    this.contents.clear();

    if (this._textAlign) {
      this.drawText(this._text, this.textPadding(), 0, this.contentsWidth() - this.textPadding(), this._textAlign);
    } else {
      this.drawTextEx(this._text, this.textPadding(), 0);
    }
  }

  textPadding() {
    return 12;
  }

  standardPadding() {
    return Math.floor(this._lineHeight / 3);
  }

  standardFontSize() {
    return 32;
  }
}

module.exports = Window_Title;
