const Window_Title = require('./Window_Title');

//-----------------------------------------------------------------------------
// Window_Help
//
// The window for displaying the description of the selected item.

class Window_Help extends Window_Title {
  initialize(numLines, width) {
    super.initialize(0, 0, width || Graphics.width, numLines);
    this._numLines = numLines;
  }

  setItem(item) {
    if (!item || !item.id) {
      this.setText('');
      return;
    }

    let description = '<WordWrap>';
    if (item.description) {
      description += item.description;
    } else {
      description += Managers.Text.item(item.id);
    }

    if (this._numLines > 1) {
      description = `${Managers.Text.replaceTextVariables('<color:item>') + description}.${Managers.Text.replaceTextVariables('</color>')} `;
      description += Managers.Text.itemDescription(item.id);
    }

    this.setText(description);
  }
}

module.exports = Window_Help;
