const Window_Command = require('engine/windows/Window_Command');
//-----------------------------------------------------------------------------
// Window_CloseButton
//
// The window for displaying a close button on menu scenes

class Window_CloseButton extends Window_Command {
  initialize() {
    super.initialize(0, 0);
    this._checkInput = false;

    this.x = Graphics.width - this.windowWidth();
    this.y = 0;
    this.select(-1);
  }

  enableWindowFrame() {
    return false;
  }

  enableCursorSprite() {
    return false;
  }

  windowWidth() {
    return 24 * Graphics.windowZoomLevel;
  }

  windowHeight() {
    return this.fittingHeight(1);
  }

  numVisibleRows() {
    return 1;
  }

  updateCursor() {
    if (this._clicked) return;
    super.updateCursor();
  }

  maxCols() {
    return 1;
  }

  onTouchOutside() {
    if (this._index >= 0) {
      this.select(-1);
    }
  }

  makeCommandList() {
    this.addCommand('X', 'cancel', true);
  }

  drawItem(index) {
    const rect = this.itemRectForText(index);
    this.resetTextColor();

    this.contents.fontSize = 40;
    this.changeTextColor('#ff0000');

    let closeIcon = 340;
    if (this._clicked) {
      closeIcon++;
    }

    this.drawIcon(closeIcon, rect.x - 6, rect.y + 4);
  }

  textPadding() {
    return 6;
  }

  standardPadding() {
    return 0;
  }

  spacing() {
    return 0;
  }

  lineHeight() {
    return 24 * Graphics.windowZoomLevel;
  }
}

module.exports = Window_CloseButton;