const Window_Command = require('./Window_Command');
const { Input } = require('engine/core/Input');

//-----------------------------------------------------------------------------
// Window_ChoiceList
//
// The window used for the event command [Show Choices].

class Window_ChoiceList extends Window_Command {
  initialize(messageWindow) {
    this._messageWindow = messageWindow;
    super.initialize(0, 0);
    this.openness = 0;
    this.deactivate();
    this._background = 0;

    this.backOpacity = Constants.MESSAGE_WINDOW_OPACITY;
  }

  start() {
    this.updatePlacement();
    this.updateBackground();
    this.refresh();
    this.selectDefault();
    this.open();
    this.activate();

    setTimeout(() => {
      if (this._index < 0) this.select(0);
    }, 1000);
  }

  selectDefault() {
    this.select($gameMessage.choiceDefaultType());
  }

  updatePlacement() {
    let messageY = this._messageWindow.y;

    if (this._messageWindow._nameWindow && this._messageWindow._nameWindow.visible) {
      messageY = this._messageWindow._nameWindow.y;
    }

    this.width = this.windowWidth();
    this.height = this.windowHeight();

    this.x = (Graphics.width - this.width) / 2;

    if (messageY >= Graphics.height / 2) {
      this.y = messageY - this.height;
    } else {
      this.y = messageY + this._messageWindow.height;
    }

    if (this.x < 0) {
      this.x = 0;
    }

    if (this.y < 0) {
      this.y = 0;
    }
  }

  updateBackground() {
    this._background = $gameMessage.choiceBackground();
    this.setBackgroundType(this._background);
  }

  windowWidth() {
    const width = this.maxChoiceWidth() + this.padding * 2;
    return Math.min(width, Graphics.width);
  }

  numVisibleRows() {
    const messageY = this._messageWindow.y;
    const messageHeight = this._messageWindow.height;
    const centerY = Graphics.height / 2;
    const choices = $gameMessage.choices();
    let numLines = choices.length;
    let maxLines = 12;

    if (messageY < centerY && messageY + messageHeight > centerY) {
      maxLines = 6;
    }

    if (numLines > maxLines) {
      numLines = maxLines;
    }
    return numLines;
  }

  maxChoiceWidth() {
    let maxWidth = 96;
    const choices = $gameMessage.choices();
    for (let i = 0; i < choices.length; i++) {
      const choiceWidth = this.textWidthEx(choices[i]) + this.textPadding() * 2;
      if (maxWidth < choiceWidth) {
        maxWidth = choiceWidth;
      }
    }
    return maxWidth;
  }

  textWidthEx(text) {
    return this.drawTextEx(text, 0, this.contents.height);
  }

  makeCommandList() {
    const choices = $gameMessage.choices();
    for (let i = 0; i < choices.length; i++) {
      this.addCommand(choices[i], 'choice');
    }
  }

  drawItem(index) {
    const rect = this.itemRectForText(index);
    this.drawTextEx(this.commandName(index), rect.x, rect.y);
  }

  isCancelEnabled() {
    return $gameMessage.choiceCancelType() !== -1;
  }

  isOkTriggered() {
    return Input.isTriggered('ok');
  }

  callOkHandler() {
    $gameMessage.onChoice(this.index());
    this._messageWindow.terminateMessage();
    this.close();
  }

  callCancelHandler() {
    $gameMessage.onChoice($gameMessage.choiceCancelType());
    this._messageWindow.terminateMessage();
    this.close();
  }

  standardFontFace() {
    return 'GameFont';
  }

  standardFontSize() {
    return Utils.convertFontSize(26, Graphics.windowZoomLevel);
  }

  standardOutlineWidth() {
    return 0;
  }

  normalColor() {
    return this.blackColor();
  }
}

module.exports = Window_ChoiceList;