class Sprite_Weather extends Sprite {
  initialize(...args) {
    super.initialize(...args);
    this._type = 'none';
    this._lifetime = 0;
    this._size = 0;
    this._anglev = 0;
    this._alpha = 0;
    this._particleSpeed = 0;
    this.setupDone = false;
  }

  update() {
    if (!this.setupDone) {
      return;
    }

    if (this._lifetime > 0) {
      switch(this._type) {
        case 'snow':
          this.opacity = Math.min(this.opacity + 24, this._alpha);
          this.scale.x = this._size * Graphics.zoomLevel;
          this.scale.y = this._size * Graphics.zoomLevel;
          break;
        case 'shine':
          this.opacity = Math.min(this.opacity + 48, this._alpha);
          this.scale.x += 0.09 * Graphics.zoomLevel;
          this.scale.y += 0.09 * Graphics.zoomLevel;
          break;
        case 'embers':
          {
            this.opacity = Math.min(this.opacity + 32, this._alpha);
            const newTone = this.getColorTone();
            newTone[0] *= 0.98;
            newTone[1] *= 0.95;

            this.setColorTone(newTone);
            this.scale.x = this._size * Graphics.zoomLevel;
            this.scale.y = this._size * Graphics.zoomLevel;
          }

          break;
        default:
          this.opacity = Math.min(this.opacity + 75, this._alpha);
          this.scale.x = this._size * Graphics.zoomLevel;
          this.scale.y = this._size * Graphics.zoomLevel;
          break;
      }

      this._lifetime -= 1;
      this._randomSeed -= 1;
    } else {
      switch(this._type) {
        case 'snow':
          this.opacity -= 16;
          break;
        case 'shine':
          this.opacity -= 15;
          this.scale.x -= 0.09 * Graphics.zoomLevel;
          this.scale.y -= 0.09 * Graphics.zoomLevel;
          break;
        case 'leaves':
        case 'embers':
          this.scale.x -= 0.01 * Graphics.zoomLevel;
          this.scale.y -= 0.01 * Graphics.zoomLevel;
          this.opacity -= 8;
          break;
        default:
          this.opacity -= 48;
          break;
      }
    }
  }

  setup(type, life, size, getangle, alpha, particleSpeed = 0) {
    this._type = type;
    this._lifetime = life + Math.randomInt(life * 0.25);
    this._size = size;
    this._anglev = getangle;
    this._alpha = alpha;
    this._particleSpeed = particleSpeed;
    this._randomSeed = Math.randomInt(16777216);

    switch (this._type) {
      case 'shine':
        this.scale.x = 0;
        this.scale.y = 0;
        this.anchor = new Point(0.5, 0.5);
        this.blendMode = PIXI.BLEND_MODES.ADD;
        this.setColorTone([Math.randomInt(2) * -255, Math.randomInt(2) * -255, Math.randomInt(2) * -255, 0]);
        break;
      case 'leaves':
        this.scale.x = 1 * Graphics.zoomLevel;
        this.scale.y = 1 * Graphics.zoomLevel;
        this.anchor = new Point(0.5, 0.5);
        this.blendMode = PIXI.BLEND_MODES.NORMAL;
        this.setColorTone([0, 0, 0, 0]);
        break;
      case 'embers':
        this.scale.x = 1 * Graphics.zoomLevel;
        this.scale.y = 1 * Graphics.zoomLevel;
        this.anchor = new Point(0.5, 0.5);
        this.blendMode = PIXI.BLEND_MODES.NORMAL;
        this.setColorTone([255, 200, 0, 0]);
        break;
      default:
        this.scale.x = 1 * Graphics.zoomLevel;
        this.scale.y = 1 * Graphics.zoomLevel;
        this.anchor = new Point(0, 0);
        this.blendMode = PIXI.BLEND_MODES.NORMAL;
        this.setColorTone([0, 0, 0, 0]);
        break;
    }

    this.setupDone = true;
  }

  getVelocity(speed) {
    const speedX = speed * Math.cos(this._anglev * (Math.PI / 180));
    const speedY = -1 * speed * Math.sin(this._anglev * (Math.PI / 180));
    return [speedY, speedX];
  }
}

module.exports = Sprite_Weather;