//-----------------------------------------------------------------------------
// Sprite_UpperTile
//
// The sprite for displaying a tile with star passability

function Sprite_UpperTile() {
  this.initialize.apply(this, arguments);
}

Sprite_UpperTile.prototype = Object.create(Sprite_Base.prototype);
Sprite_UpperTile.prototype.constructor = Sprite_UpperTile;

Sprite_UpperTile.prototype.initialize = function(tileId) {
  Sprite_Base.prototype.initialize.call(this);
  this.initMembers();
  this.tileId = tileId;
};

Sprite_UpperTile.prototype.initMembers = function() {
  this.anchor.x = 0.5;
  this.anchor.y = 1;
  this._tilesetId = 0;
  this._tileId = 0;
};

Sprite_UpperTile.prototype.update = function() {
  Sprite_Base.prototype.update.call(this);

  this.updateBitmap();
  this.updateFrame();
  this.updatePosition();
};

Sprite_UpperTile.prototype.tilesetBitmap = function(tileId) {
  var tileset = $gameMap.tileset();
  var setNumber = 5 + Math.floor(tileId / 256);
  return Managers.Images.loadTileset(tileset.tilesetNames[setNumber]);
};

Sprite_UpperTile.prototype.updateBitmap = function() {
  if (this.isImageChanged()) {
    this._tilesetId = $gameMap.tilesetId();
    this._tileId = this.tileId;

    this.bitmap = this.tilesetBitmap(this._tileId);
  }
};

Sprite_UpperTile.prototype.isImageChanged = function() {
  return (this._tilesetId !== $gameMap.tilesetId() || this._tileId !== this.tileId);
};

Sprite_UpperTile.prototype.updateFrame = function() {
  this._mirror = false;

  var pw = this.patternWidth();
  var ph = this.patternHeight();
  var sx = (Math.floor(this._tileId / 128) % 2 * 8 + this._tileId % 8) * pw;
  var sy = Math.floor(this._tileId % 256 / 8) % 16 * ph;
  this.setFrame(sx, sy, pw, ph);
};

Sprite_UpperTile.prototype.patternWidth = function() {
  return $gameMap.tileWidth();
};

Sprite_UpperTile.prototype.patternHeight = function() {
  return $gameMap.tileHeight();
};

Sprite_UpperTile.prototype.updatePosition = function() {
  this.z = 5;
  this.zIndex = this.z;
  this.zOrder = -this.y;
};