require('./Sprite_Base');

class Sprite_StaticTile extends Sprite_Base {
  initialize(character) {
    super.initialize();
    this.initMembers();
    this.setCharacter(character);

    this._randomCacheIndex = Math.randomInt(10);
  }

  initMembers() {
    this.anchor.x = 0.5;
    this.anchor.y = 1;
    this._character = null;
    this._tilesetId = 0;

    this._frameWidth = $gameMap.tileWidth();
    this._frameHeight = $gameMap.tileHeight();
  }

  setCharacter(character) {
    this._character = character;
  }

  isNearTheScreen() {
    return $gameScreen.isPositionNearTheScreen(this.x, this.y);
  }

  shouldSkipUpdate() {
    if (Graphics.frameCount % 10 !== this._randomCacheIndex) {
      if (this.y > Graphics.height * 2 || this.y < (0 - Graphics.height)) {
        return true;
      }
      if (this.x > Graphics.width * 2 || this.x < (0 - Graphics.width)) {
        return true;
      }
    }

    return false;
  }

  update() {
    super.update();

    if (this._character && this._character._erased) {
      if (this.parent) {
        this.removeItself();
        this.destroy();
      }
      return;
    }

    if (this.shouldSkipUpdate()) {
      return;
    }

    this.updateBitmap();
    this.updateFrame();
    this.updatePosition();
  }

  isTile() {
    return true;
  }

  tilesetBitmap(tileId) {
    const tileset = $gameMap.tileset();
    const setNumber = 5 + Math.floor(tileId / 256);

    return Managers.Images.loadTileset(tileset.tilesetNames[setNumber]);
  }

  updateBitmap() {
    if (!this.isImageChanged()) {
      return;
    }

    this._tilesetId = $gameMap.tilesetId();
    this._tileId = this._character.tileId();
  
    this.setTileBitmap();
  }

  isImageChanged() {
    return this._tilesetId !== $gameMap.tilesetId() || this._tileId !== this._character.tileId();
  }

  setTileBitmap() {
    this.bitmap = this.tilesetBitmap(this._tileId);
  }

  updateFrame() {
    this._mirror = false;
    this.updateTileFrame();
  }

  updateTileFrame() {
    const pw = this._frameWidth || 0;
    const ph = this._frameHeight || 0;
    const sx = (Math.floor(this._tileId / 128) % 2 * 8 + this._tileId % 8) * pw;
    const sy = Math.floor(this._tileId % 256 / 8) % 16 * ph;
    this.setFrame(sx, sy, pw, ph);
  }

  updatePosition() {
    const newX = this._character.screenX();
    const newY = this._character.screenY();

    this.x = newX;
    this.y = newY;

    this.z = this._character.screenZ();
    this.zIndex = this.z;
    this.zOrder = -newY;
  }

  _refresh() {
    if (this._character && this._character._erased) {
      this.visible = false;
      return;
    }

    super._refresh();
  }
}

Sprites.StaticTile = Sprite_StaticTile;