const { Inventory } = require('engine/managers/Inventory');

//-----------------------------------------------------------------------------
// Sprite_Player
//
// The sprite for displaying the player character.

function Sprite_Player() {
  this.initialize.apply(this, arguments);
}

Sprite_Player.prototype = Object.create(Sprite_HumanCharacter.prototype);
Sprite_Player.prototype.constructor = Sprite_Player;

Sprite_Player.prototype.initialize = function(character) {
  Sprite_HumanCharacter.prototype.initialize.call(this, character);

  this._mountSprite = new Sprite_MountedAnimal();
  this._mountSprite.z = 0;
  this.addChild(this._mountSprite);

  this._ridingSprite = new Sprite_PlayerRiding();
  this._ridingSprite.z = 1;
  this.addChild(this._ridingSprite);
};

Sprite_Player.prototype.updatePosition = function() {
  Sprite_HumanCharacter.prototype.updatePosition.call(this);
  if (Switches.onRaft) {
    this.updateRaftOffset();
  }
  
  this.y -= 8;
  this.zOrder += 8;
  
  this.zIndex = this.z;
  Managers.Map.updatePlayerSpritePosition(this);
};

Sprite_Player.prototype.updateRaftOffset = function() {
  var event = Managers.Villagers.getVillagerData('Raft');
  if (!event) return;

  switch (event.pattern()) {
    case 0 :
      this.y += 1;
      break;
    case 2 :
      this.y -= 1;
      break;
  }
};

Sprite_Player.prototype.isHiddenBySwitches = function() {
  return Switches.hidePlayer || Switches.hideParty;
};

Sprite_Player.prototype.isWaitingForItem = function() {
  return Inventory.waiting && !Inventory.displayItemId;
};

Sprite_Player.prototype.pattern = function() {
  if (Switches.onRaft) return 1;

  return Sprite_HumanCharacter.prototype.pattern.call(this);
};

Sprite_Player.prototype.toolYOffset = function() {
  return 24;
};