require('./Sprite_Character');
//-----------------------------------------------------------------------------
// Sprite_HumanCharacter
//
// The sprite for displaying the player's and villagers' characters.

function Sprite_HumanCharacter() {
  this.initialize.apply(this, arguments);
}

Sprite_HumanCharacter.prototype = Object.create(Sprite_Character.prototype);
Sprite_HumanCharacter.prototype.constructor = Sprite_HumanCharacter;

Sprite_HumanCharacter.prototype.initialize = function(character) {
  Sprite_Character.prototype.initialize.call(this, character);

  this._itemSprite = new Sprite_ItemIcon();
  this._itemSprite.z = 1;
  this.addChild(this._itemSprite);
};

Sprite_HumanCharacter.prototype.isHiddenBySwitches = function() {
  return false;
};

Sprite_HumanCharacter.prototype.isWaitingForItem = function() {
  return false;
};

Sprite_HumanCharacter.prototype.canShowItem = function() {
  if (!this._character.isHoldingItem()) return false;
  if (this._character._itemWaitCount !== undefined && this._character._itemWaitCount > 0) return false;
  if (this.isHiddenBySwitches()) return false;
  if (this._character._toolId !== undefined) return false;
  if (this.isWaitingForItem()) return false;
  if (this._character.isRiding()) return false;

  return true;
};

Sprite_HumanCharacter.prototype.updateOther = function() {
  Sprite_Character.prototype.updateOther.call(this);

  if (this.canShowItem()) {
    var characterItem = this._character.itemToDisplay();

    if (characterItem) {
      this._itemSprite._iconIndex = characterItem.iconIndex;
      this._itemSprite._characterName = characterItem.characterName || '';
      this._itemSprite._characterIndex = characterItem.characterIndex;
      this._itemSprite._direction = this._character._direction;
      this._itemSprite._iconX = characterItem.iconX || 0;
      this._itemSprite._iconY = characterItem.iconY || 0;
      this._itemSprite._animate = characterItem.animateSprite || false;
    }
  } else {
    this._itemSprite._iconIndex = -1;
    this._itemSprite._characterName = '';
    this._itemSprite._characterIndex = -1;
  }
};

Sprite_HumanCharacter.prototype.isImageChanged = function() {
  if (this._characterName !== this._character.characterName() ||
    this._characterIndex !== this._character.characterIndex() ||
    this._toolId !== this._character.toolId() ||
    this._toolState !== this._character.toolState()) {
    return true;
  }

  if (this._character.isHoldingItem() && this._character._itemWaitCount <= 0 && !this.isWaitingForItem()) {
    var characterItem = this._character.itemToDisplay();

    if (this._itemSprite.iconIndex != characterItem.iconIndex) return true;
    if (this._itemSprite.characterName != characterItem.characterName) return true;
    if (this._itemSprite.characterIndex != characterItem.characterIndex) return true;
  } else {

    if (this._itemSprite.iconIndex !== -1) return true;
    if (this._itemSprite.characterName !== '') return true;
    if (this._itemSprite.characterIndex !== -1) return true;
  }

  return false;
};
