require('./Sprite_HumanCharacter');
//-----------------------------------------------------------------------------
// Sprite_Follower
//
// The sprite for displaying the player character.

function Sprite_Follower() {
  this.initialize.apply(this, arguments);
}

Sprite_Follower.prototype = Object.create(Sprite_HumanCharacter.prototype);
Sprite_Follower.prototype.constructor = Sprite_Follower;

Sprite_Follower.prototype.initialize = function(character) {
  Sprite_HumanCharacter.prototype.initialize.call(this, character);
};

Sprite_Follower.prototype.updatePosition = function() {
  Sprite_HumanCharacter.prototype.updatePosition.call(this);
  this.y -= 8;

  if (Switches.onRaft) {
    this.updateRaftOffset();
  }

  Managers.Map.updatePlayerSpritePosition(this);
  this.zOrder = -this.y;
};

Sprite_Follower.prototype.updateRaftOffset = function() {
  var event = Managers.Villagers.getVillagerData('Raft');
  if (!event) return;

  switch (event.pattern()) {
    case 0 :
      this.y += 1;
      break;
    case 2 :
      this.y -= 1;
      break;
  }
};

Sprite_Follower.prototype.pattern = function() {
  if (Switches.onRaft) return 1;

  return Sprite_HumanCharacter.prototype.pattern.call(this);
};

Sprite_Follower.prototype.isHiddenBySwitches = function() {
  return Switches.hideFollowers || Switches.hideParty;
};
