require('./Sprite_Character');
//-----------------------------------------------------------------------------
// Sprite_Event
//
// The sprite for displaying rpg maker events.

function Sprite_Event() {
  this.initialize.apply(this, arguments);
}

Sprite_Event.prototype = Object.create(Sprite_Character.prototype);
Sprite_Event.prototype.constructor = Sprite_Event;

Sprite_Event.prototype.initialize = function(/*character*/) {
  Sprite_Character.prototype.initialize.apply(this, arguments);
  this.cache = {};
  this.longCache = {};
};

Sprite_Event.prototype.initMembers = function() {
  this.cache = {};
  this.longCache = {};
  Sprite_Character.prototype.initMembers.call(this);
};

Sprite_Event.prototype.update = function() {
  this.cache = {};
  Sprite_Character.prototype.update.call(this);
};

Sprite_Event.prototype.updatePosition = function() {
  var shouldUpdatePosition = true;
  var shouldUseRelativePosition = false;

  if (this._oldY == this._character._realY && this._oldX == this._character._realX) {
    if (this._oldScreenX == $gameMap._displayX && this._oldScreenY == $gameMap._displayY) {
      shouldUpdatePosition = false;
    } else {
      // shouldUseRelativePosition = true;
    }
  }

  if (shouldUpdatePosition) {
    this._oldScreenX = $gameMap._displayX;
    this._oldScreenY = $gameMap._displayY;

    if (shouldUseRelativePosition && this._relativeX !== undefined && this._relativeY !== undefined) {
      this.x = this._relativeX - this._oldScreenX;
      this.y = this._relativeY - this._oldScreenY;
    } else {
      this.x = this._character.screenX();
      this.y = this._character.screenY();

      this._oldY = this._character._realY;
      this._oldX = this._character._realX;
    }

    this._relativeX = this._oldX + this._oldScreenX;
    this._relativeY = this._oldY + this._oldScreenY;
  }

  if (this._oldPriority != this._character._priorityType) {
    var newZ = this._character.screenZ();
    this.z = newZ;

    this._oldPriority = this._character._priorityType;
  }

  if (this.zIndex != this.z) {
    this.zIndex = this.z;
  }
  if (this.zOrder != -this.y) {
    this.zOrder = -this.y;
  }
};

Sprite_Event.prototype.patternWidth = function() {
  if (this.cache.patternWidth !== undefined) {
    return this.cache.patternWidth;
  }
  if (this.longCache.patternWidth !== undefined) {
    return this.longCache.patternWidth;
  }

  this.cache.patternWidth = Sprite_Character.prototype.patternWidth.call(this);
  this.longCache.patternWidth = this.cache.patternWidth;
  return this.cache.patternWidth;
};

Sprite_Event.prototype.patternHeight = function() {
  if (this.cache.patternHeight !== undefined) {
    return this.cache.patternHeight;
  }
  if (this.longCache.patternHeight !== undefined) {
    return this.longCache.patternHeight;
  }

  this.cache.patternHeight = Sprite_Character.prototype.patternHeight.call(this);
  this.longCache.patternHeight = this.cache.patternHeight;
  return this.cache.patternHeight;
};

Sprite_Event.prototype.onImageChanged = function() {
  Sprite_Character.prototype.onImageChanged.call(this);
  this.longCache = {};
  this.cache = {};

  if (this._bitmap && !this._bitmap.isReady()) {
    this._bitmap.addLoadListener(function(){
      this.longCache = {};
      this.cache = {};
    }.bind(this));
  }
};