require('engine/core/Sprite');
//-----------------------------------------------------------------------------
// Sprite_Base
//
// The sprite class with a feature which displays animations.

function Sprite_Base() {
  this.initialize.apply(this, arguments);
}

Sprite_Base.prototype = Object.create(Sprite.prototype);
Sprite_Base.prototype.constructor = Sprite_Base;

Sprite_Base.prototype.initialize = function() {
  Sprite.prototype.initialize.call(this);
  this._animationTarget = this;
  this._animationSprites = [];
  this._hiding = false;
};

Sprite_Base.prototype.update = function() {
  Sprite.prototype.update.call(this);
  this.updateVisibility();
  this.updateAnimationSprites();
};

Sprite_Base.prototype.hide = function() {
  this._hiding = true;
  this.updateVisibility();
};

Sprite_Base.prototype.show = function() {
  this._hiding = false;
  this.updateVisibility();
};

Sprite_Base.prototype.updateVisibility = function() {
  this.visible = !this._hiding;
};

Sprite_Base.prototype.updateAnimationSprites = function() {
  if (this._animationSprites.length > 0) {
    var sprites = this._animationSprites.clone();
    this._animationSprites = [];
    for (var i = 0; i < sprites.length; i++) {
      var sprite = sprites[i];
      if (sprite.isPlaying()) {
        this._animationSprites.push(sprite);
      } else {
        sprite.remove();
      }
    }
  }
};

Sprite_Base.prototype.startAnimation = function(animation, mirror, delay) {
  if (!Managers.Config.enableAnimations) return;

  var sprite = new Sprite_Animation();

  this._heightForAnimation = this.height;

  var parent = this.parent;
  if (Managers.Scenes._scene instanceof GameScenes.Map) {
    var spriteset = Managers.Scenes._scene._spriteset;
    if (spriteset) {
      parent = spriteset._tilemap;
    }
  }

  sprite.setup(this._animationTarget, animation, mirror, delay);
  parent.addChild(sprite);
  this._animationSprites.push(sprite);
};

Sprite_Base.prototype.isAnimationPlaying = function() {
  return this._animationSprites.length > 0;
};

Sprite_Base.prototype.removeItself = function() {
  if (this.parent) {
    this.parent.removeChild(this);
  }

  if (Managers.Scenes._scene instanceof GameScenes.Map) {
    const scene = Managers.Scenes._scene;
    if (scene._spriteset) {
      scene._spriteset.removeSpriteReferences(this);
    }
  }
};