const Scene_Base = require('./Scene_Base');
const Window_Help = require('../windows/Window_Help');
const Window_CloseButton = require('../windows/Window_CloseButton');
//-----------------------------------------------------------------------------
// Scene_MenuBase
//
// The superclass of all the menu-type scenes.
class Scene_MenuBase extends Scene_Base {
  create() {
    this.screenRatio = this.measureScreenRatio();
    super.create();
    this.createBackground();
    this.createWindowLayer();
    if ($gamePlayer) {
      $gamePlayer.clearPerformedTransferInfo();
    }
  }
  actor() {
    return this._actor;
  }

  loadingBgBitmap() {
    return Managers.Images.loadPicture('loading_bg_image');
  }

  backgroundOpacity() {
    return 128;
  }

  backgroundX() {
    if (Graphics.width == 2560) {
      return Math.floor((2560 * this.screenRatio) - Graphics.width) * -1;
    }

    return Math.floor((1920 * this.screenRatio) - Graphics.width) * -1;
  }

  createBackground() {
    this._backgroundSprite = new Sprite(this.loadingBgBitmap());
    this._backgroundSprite.scale.x = this._backgroundSprite.scale.y = this.screenRatio;
    this._backgroundSprite.x = this.backgroundX();

    this.addChild(this._backgroundSprite);
    this.setBackgroundOpacity(this.backgroundOpacity());
  }

  measureScreenRatio() {
    return Graphics.height / 1080;
  }

  setBackgroundOpacity(opacity) {
    if (this._backgroundSprite) {
      this._backgroundSprite.opacity = opacity;
    }
  }

  createHelpWindow() {
    this._helpWindow = new Window_Help();
    this.addWindow(this._helpWindow);
  }

  createCloseButton() {
    this._closeButtonWindow = new Window_CloseButton();
    this.addWindow(this._closeButtonWindow);
    this._closeButtonWindow.setHandler('cancel', this.onClickCancelButton.bind(this));
  }

  onClickCancelButton() {
    if (this._closeButtonWindow) {
      this._closeButtonWindow._clicked = true;
      this._closeButtonWindow.refresh();
      this.popScene();
    }
  }

  onActorChange() {
  }

  createHoverBitmap() {
    this._hoverBitmap = new Bitmap(Graphics.width, Graphics.height);
    this._hoverSprite = new Sprite(this._hoverBitmap);
    this.addChild(this._hoverSprite);
  }

  updateHover() {
    if (!this._hoverBitmap) {
      return;
    }

    var x = TouchInput.mouseX;
    var y = TouchInput.mouseY;

    if (x == this._lastHoverX && y == this._lastHoverY) {
      return;
    }

    this._lastHoverX = x;
    this._lastHoverY = y;
    this._hoverBitmap.clear();

    var label = this.getPositionLabel(x, y);
    if (label) {
      var align = 'left';
      if (y < 200) {
        y += 25;
      } else {
        y -= 20;
      }

      if (x > Graphics.width - 200) {
        x -= 400;
        align = 'right';
      }
      this._hoverBitmap.fontSize = Utils.convertFontSize(24, Graphics.windowZoomLevel);
      this._hoverBitmap.drawText(label, x, y, 400, 20, align);
    }
  }

  getPositionLabel( /*x, y*/) {
    return '';
  }
}

module.exports = Scene_MenuBase;