//-----------------------------------------------------------------------------
// Game_Variables
//
// The game object class for variables.

Objects.Variables = class Variables {
  constructor() {
    this.initialize(...arguments);
  }

  initialize() {
    this.clear();
  }

  getDataForSaveFile() {
    return Object.assign({}, this);
  }

  clear() {
    this._data = [];
  }

  value(variableId) {
    if (this._data[variableId] === '') return '';
    return this._data[variableId] || 0;
  }

  setValue(variableId, value) {
    if (variableId > 0) {
      if (typeof value === 'number') {
        value = Math.floor(value);
      }
      this._data[variableId] = value;
      this.onChange();
    }
  }

  onChange() {
    $gameMap.requestRefresh();
  }
};