//-----------------------------------------------------------------------------
// Game_Switches
//
// The game object class for switches.

Objects.Switches = class Switches {
  constructor() {
    this.initialize(...arguments);
  }

  initialize() {
    this.clear();
  }

  getDataForSaveFile() {
    return Object.assign({}, this);
  }

  clear() {
    this._data = [];
    this._customData = {};
  }

  value(switchId) {
    return this._data[switchId] || false;
  }

  booleanValue(switchId) {
    return !!this._data[switchId];
  }

  reset() {
    for (let i = 0; i < this._data.length; i++) {
      this._data[i] = false;
    }
  }

  setValue(switchId, value) {
    if (switchId > 0 && switchId < $dataSystem.switches.length) {
      this._data[switchId] = value;
      this.onChange();
    }
  }

  onChange() {
    $gameMap.requestRefresh();
  }
};
