//-----------------------------------------------------------------------------
// Game_SelfSwitches
//
// The game object class for self switches.

Objects.SelfSwitches = class SelfSwitches {
  constructor() {
    this.initialize(...arguments);
  }

  initialize() {
    this.clear();
  }

  getDataForSaveFile() {
    return Object.assign({}, this);
  }

  clear() {
    this._data = {};
  }

  value(key) {
    return !!this._data[key];
  }

  setValue(key, value) {
    if (value) {
      this._data[key] = true;
    } else {
      delete this._data[key];
    }
    this.onChange();
  }

  onChange() {
    $gameMap.requestRefresh();
  }
};
